/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.cute;

import java.util.Map;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.cute.Cheese;
import znaishaded.net.sourceforge.plantuml.cute.Circle;
import znaishaded.net.sourceforge.plantuml.cute.CuteShape;
import znaishaded.net.sourceforge.plantuml.cute.Group;
import znaishaded.net.sourceforge.plantuml.cute.Positionned;
import znaishaded.net.sourceforge.plantuml.cute.PositionnedImpl;
import znaishaded.net.sourceforge.plantuml.cute.Rectangle;
import znaishaded.net.sourceforge.plantuml.cute.Stick;
import znaishaded.net.sourceforge.plantuml.cute.Triangle;
import znaishaded.net.sourceforge.plantuml.cute.VarArgs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CuteShapeFactory {
    private final Map<String, Group> groups;

    public CuteShapeFactory(Map<String, Group> map) {
        this.groups = map;
    }

    public Positionned createCuteShapePositionned(String string) {
        VarArgs varArgs = new VarArgs(string);
        return new PositionnedImpl(this.createCuteShape(string), varArgs);
    }

    private CuteShape createCuteShape(String string) {
        string = StringUtils.trin(string.toLowerCase());
        VarArgs varArgs = new VarArgs(string);
        if (string.startsWith("circle ")) {
            return new Circle(varArgs);
        }
        if (string.startsWith("cheese ")) {
            return new Cheese(varArgs);
        }
        if (string.startsWith("stick ")) {
            return new Stick(varArgs);
        }
        if (string.startsWith("rectangle ") || string.startsWith("rect ")) {
            return new Rectangle(varArgs);
        }
        if (string.startsWith("triangle ")) {
            return new Triangle(varArgs);
        }
        String string2 = string.split(" ")[0];
        Group group = this.groups.get(string2);
        if (group == null) {
            throw new IllegalArgumentException("Cannot find group " + string2 + " in " + this.groups.keySet());
        }
        return group;
    }
}

