/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.geom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dijkstra {
    private final double[][] basic;
    private final double[] dist;
    private final int[] previous;
    private final Set<Integer> q = new HashSet<Integer>();
    private final int size;

    public Dijkstra(int n) {
        this.size = n;
        this.basic = new double[n][n];
        this.dist = new double[n];
        this.previous = new int[n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                this.basic[i][j] = i == j ? 0.0 : Double.MAX_VALUE;
            }
        }
    }

    public void addLink(int n, int n2, double d) {
        if (n == n2) {
            throw new IllegalArgumentException();
        }
        this.basic[n][n2] = d;
        this.basic[n2][n] = d;
    }

    private void init() {
        for (int i = 0; i < this.size; ++i) {
            this.dist[i] = Double.MAX_VALUE;
            this.previous[i] = -1;
            this.q.add(i);
        }
        this.dist[0] = 0.0;
    }

    private void computePrevious() {
        this.init();
        while (this.q.size() > 0) {
            int n = this.smallest();
            if (this.dist[n] == Double.MAX_VALUE) {
                return;
            }
            this.q.remove(n);
            for (int i = 0; i < this.size; ++i) {
                double d;
                if (this.basic[n][i] == Double.MAX_VALUE || !((d = this.dist[n] + this.basic[n][i]) < this.dist[i])) continue;
                this.dist[i] = d;
                this.previous[i] = n;
            }
        }
    }

    public List<Integer> getBestPath() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        this.computePrevious();
        int n = this.size - 1;
        while (this.previous[n] >= 0) {
            arrayList.add(0, n);
            n = this.previous[n];
        }
        arrayList.add(0, 0);
        return Collections.unmodifiableList(arrayList);
    }

    private int smallest() {
        int n = -1;
        for (Integer n2 : this.q) {
            if (n != -1 && !(this.dist[n2] < this.dist[n])) continue;
            n = n2;
        }
        return n;
    }

    public final int getSize() {
        return this.size;
    }
}

