/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.math;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.Icon;
import znaishaded.net.sourceforge.plantuml.SvgString;
import znaishaded.net.sourceforge.plantuml.math.ConverterSvg;
import znaishaded.net.sourceforge.plantuml.math.ScientificEquation;
import znaishaded.net.sourceforge.plantuml.math.TeXIconBuilder;

public class LatexBuilder
implements ScientificEquation {
    private final String tex;
    private Dimension2D dimension;

    public LatexBuilder(String string) {
        this.tex = string;
    }

    public Dimension2D getDimension() {
        return this.dimension;
    }

    private Icon buildIcon(Color color) throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return new TeXIconBuilder(this.tex, color).getIcon();
    }

    public SvgString getSvg(double d, Color color, Color color2) throws ClassNotFoundException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, InstantiationException, IOException {
        Icon icon = this.buildIcon(color);
        ConverterSvg converterSvg = new ConverterSvg(icon);
        String string = converterSvg.getSvg(d, true, color2);
        this.dimension = converterSvg.getDimension();
        return new SvgString(string, d);
    }

    public BufferedImage getImage(double d, Color color, Color color2) throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Icon icon = this.buildIcon(color);
        BufferedImage bufferedImage = new BufferedImage((int)((double)icon.getIconWidth() * d), (int)((double)icon.getIconHeight() * d), 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.scale(d, d);
        if (color2 != null) {
            graphics2D.setColor(color2);
            graphics2D.fillRect(0, 0, icon.getIconWidth(), icon.getIconHeight());
        }
        icon.paintIcon(null, graphics2D, 0, 0);
        return bufferedImage;
    }

    public String getSource() {
        return this.tex;
    }
}

