/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.stats;

import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.prefs.Preferences;
import znaishaded.net.sourceforge.plantuml.FileFormat;
import znaishaded.net.sourceforge.plantuml.PSystemError;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ActivityDiagram3;
import znaishaded.net.sourceforge.plantuml.core.Diagram;
import znaishaded.net.sourceforge.plantuml.directdot.PSystemDot;
import znaishaded.net.sourceforge.plantuml.ditaa.PSystemDitaa;
import znaishaded.net.sourceforge.plantuml.eggs.PSystemWelcome;
import znaishaded.net.sourceforge.plantuml.jcckit.PSystemJcckit;
import znaishaded.net.sourceforge.plantuml.math.PSystemMath;
import znaishaded.net.sourceforge.plantuml.salt.PSystemSalt;
import znaishaded.net.sourceforge.plantuml.stats.FormatCounter;
import znaishaded.net.sourceforge.plantuml.stats.ParsedGenerated;
import znaishaded.net.sourceforge.plantuml.stats.StatsUtils;
import znaishaded.net.sourceforge.plantuml.stats.api.Stats;
import znaishaded.net.sourceforge.plantuml.sudoku.PSystemSudoku;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatsUtilsIncrement {
    private static final Preferences prefs = StatsUtils.prefs;
    private static final ConcurrentMap<String, ParsedGenerated> byTypeEver = StatsUtils.byTypeEver;
    private static final ConcurrentMap<String, ParsedGenerated> byTypeCurrent = StatsUtils.byTypeCurrent;
    private static final FormatCounter formatCounterCurrent = StatsUtils.formatCounterCurrent;
    private static final FormatCounter formatCounterEver = StatsUtils.formatCounterEver;
    private static final Lock lockXml = new ReentrantLock();
    private static final Lock lockHtml = new ReentrantLock();

    public static void onceMoreParse(long l, Class<? extends Diagram> clazz) {
        StatsUtilsIncrement.getByTypeCurrent(clazz).parsed().addValue(l);
        ParsedGenerated parsedGenerated = StatsUtilsIncrement.getByTypeEver(clazz);
        parsedGenerated.parsed().addValue(l);
        StatsUtils.fullEver.parsed().addValue(l);
        StatsUtils.historicalData.current().parsed().addValue(l);
        StatsUtils.historicalData.current().parsed().save(prefs);
        StatsUtils.fullEver.parsed().save(prefs);
        parsedGenerated.parsed().save(prefs);
        StatsUtilsIncrement.realTimeExport();
    }

    public static void onceMoreGenerate(long l, Class<? extends Diagram> clazz, FileFormat fileFormat) {
        StatsUtilsIncrement.getByTypeCurrent(clazz).generated().addValue(l);
        ParsedGenerated parsedGenerated = StatsUtilsIncrement.getByTypeEver(clazz);
        parsedGenerated.generated().addValue(l);
        StatsUtils.fullEver.generated().addValue(l);
        StatsUtils.historicalData.current().generated().addValue(l);
        formatCounterCurrent.plusOne(fileFormat, l);
        formatCounterEver.plusOne(fileFormat, l);
        formatCounterEver.save(prefs, fileFormat);
        StatsUtils.historicalData.current().generated().save(prefs);
        StatsUtils.fullEver.generated().save(prefs);
        parsedGenerated.generated().save(prefs);
        StatsUtilsIncrement.realTimeExport();
    }

    private static ParsedGenerated getByTypeCurrent(Class<? extends Diagram> clazz) {
        String string = StatsUtilsIncrement.name(clazz);
        ParsedGenerated parsedGenerated = (ParsedGenerated)byTypeCurrent.get(string);
        if (parsedGenerated == null) {
            byTypeCurrent.putIfAbsent(string, ParsedGenerated.createVolatileDated());
            parsedGenerated = (ParsedGenerated)byTypeCurrent.get(string);
        }
        return parsedGenerated;
    }

    private static ParsedGenerated getByTypeEver(Class<? extends Diagram> clazz) {
        String string = StatsUtilsIncrement.name(clazz);
        ParsedGenerated parsedGenerated = (ParsedGenerated)byTypeEver.get(string);
        if (parsedGenerated == null) {
            byTypeEver.putIfAbsent(string, ParsedGenerated.loadDated(prefs, "type." + string));
            parsedGenerated = (ParsedGenerated)byTypeEver.get(string);
        }
        return parsedGenerated;
    }

    private static String name(Class<? extends Diagram> clazz) {
        if (clazz == PSystemError.class) {
            return "Error";
        }
        if (clazz == ActivityDiagram3.class) {
            return "ActivityDiagramBeta";
        }
        if (clazz == PSystemSalt.class) {
            return "Salt";
        }
        if (clazz == PSystemSudoku.class) {
            return "Sudoku";
        }
        if (clazz == PSystemDot.class) {
            return "Dot";
        }
        if (clazz == PSystemWelcome.class) {
            return "Welcome";
        }
        if (clazz == PSystemDitaa.class) {
            return "Ditaa";
        }
        if (clazz == PSystemJcckit.class) {
            return "Jcckit";
        }
        if (clazz == PSystemMath.class) {
            return "Math";
        }
        String string = clazz.getSimpleName();
        if (string.endsWith("Diagram")) {
            return string;
        }
        return "Other";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void realTimeExport() {
        block8: {
            if (StatsUtils.realTimeStats) {
                Stats stats = StatsUtils.getStatsLazzy();
                try {
                    if (StatsUtils.xmlStats && lockXml.tryLock()) {
                        try {
                            StatsUtils.xmlOutput(stats);
                            Object var2_1 = null;
                            lockXml.unlock();
                        }
                        catch (Throwable throwable) {
                            Object var2_2 = null;
                            lockXml.unlock();
                            throw throwable;
                        }
                    }
                    if (!StatsUtils.htmlStats || !lockHtml.tryLock()) break block8;
                    try {
                        StatsUtils.htmlOutput(stats);
                        Object var4_5 = null;
                        lockHtml.unlock();
                    }
                    catch (Throwable throwable) {
                        Object var4_6 = null;
                        lockHtml.unlock();
                        throw throwable;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }
}

