/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.suggest;

import java.util.ArrayList;
import java.util.Iterator;
import znaishaded.net.sourceforge.plantuml.AbstractPSystem;
import znaishaded.net.sourceforge.plantuml.CharSequence2;
import znaishaded.net.sourceforge.plantuml.CharSequence2Impl;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.command.BlocLines;
import znaishaded.net.sourceforge.plantuml.command.CommandControl;
import znaishaded.net.sourceforge.plantuml.command.UmlDiagramFactory;
import znaishaded.net.sourceforge.plantuml.core.UmlSource;
import znaishaded.net.sourceforge.plantuml.suggest.SuggestEngineResult;
import znaishaded.net.sourceforge.plantuml.suggest.SuggestEngineStatus;
import znaishaded.net.sourceforge.plantuml.suggest.VariatorAddOneCharBetweenWords;
import znaishaded.net.sourceforge.plantuml.suggest.VariatorIteratorAdaptor;
import znaishaded.net.sourceforge.plantuml.suggest.VariatorRemoveOneChar;
import znaishaded.net.sourceforge.plantuml.suggest.VariatorSwapLetter;
import znaishaded.net.sourceforge.plantuml.utils.StartUtils;
import znaishaded.net.sourceforge.plantuml.version.IteratorCounter2;
import znaishaded.net.sourceforge.plantuml.version.IteratorCounter2Impl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SuggestEngine {
    private static final int LIMIT = 120;
    private final UmlDiagramFactory systemFactory;
    private final IteratorCounter2 it99;

    public SuggestEngine(UmlSource umlSource, UmlDiagramFactory umlDiagramFactory) {
        this.systemFactory = umlDiagramFactory;
        this.it99 = umlSource.iterator2();
        CharSequence charSequence = (CharSequence)this.it99.next();
        if (!StartUtils.isArobaseStartDiagram(charSequence)) {
            throw new UnsupportedOperationException();
        }
    }

    public SuggestEngineResult tryToSuggest(AbstractPSystem abstractPSystem) {
        return this.executeUmlCommand(abstractPSystem);
    }

    private SuggestEngineResult executeUmlCommand(AbstractPSystem abstractPSystem) {
        while (this.it99.hasNext()) {
            if (StartUtils.isArobaseEndDiagram(this.it99.peek())) {
                return SuggestEngineResult.SYNTAX_OK;
            }
            SuggestEngineResult suggestEngineResult = this.checkAndCorrect();
            if (suggestEngineResult.getStatus() != SuggestEngineStatus.SYNTAX_OK) {
                return suggestEngineResult;
            }
            CommandControl commandControl = this.systemFactory.isValid2(this.it99);
            if (commandControl == CommandControl.OK_PARTIAL) {
                this.systemFactory.goForwardMultiline(this.it99);
                continue;
            }
            if (commandControl == CommandControl.OK) {
                this.it99.next();
                continue;
            }
            return SuggestEngineResult.CANNOT_CORRECT;
        }
        return SuggestEngineResult.CANNOT_CORRECT;
    }

    SuggestEngineResult checkAndCorrect() {
        String string = this.it99.peek().toString();
        if (string.length() > 120) {
            return SuggestEngineResult.CANNOT_CORRECT;
        }
        CommandControl commandControl = this.systemFactory.isValid2(this.it99);
        if (commandControl != CommandControl.NOT_OK) {
            return SuggestEngineResult.SYNTAX_OK;
        }
        if (StringUtils.trin(string).startsWith("{") && this.systemFactory.isValid(BlocLines.single(this.it99.peekPrevious() + " {")) != CommandControl.NOT_OK) {
            return new SuggestEngineResult(this.it99.peekPrevious() + " {");
        }
        ArrayList<VariatorIteratorAdaptor> arrayList = new ArrayList<VariatorIteratorAdaptor>();
        arrayList.add(new VariatorRemoveOneChar(string));
        arrayList.add(new VariatorSwapLetter(string));
        arrayList.add(new VariatorAddOneCharBetweenWords(string, '-'));
        arrayList.add(new VariatorAddOneCharBetweenWords(string, ' '));
        for (Iterator iterator : arrayList) {
            SuggestEngineResult suggestEngineResult = this.tryThis(iterator);
            if (suggestEngineResult == null) continue;
            return suggestEngineResult;
        }
        return SuggestEngineResult.CANNOT_CORRECT;
    }

    private SuggestEngineResult tryThis(Iterator<String> iterator) {
        while (iterator.hasNext()) {
            CommandControl commandControl;
            String string = iterator.next();
            if (StringUtils.trin(string).length() == 0 || (commandControl = this.systemFactory.isValid2(this.replaceFirstLine(string))) != CommandControl.OK) continue;
            return new SuggestEngineResult(string);
        }
        return null;
    }

    private IteratorCounter2 replaceFirstLine(String string) {
        ArrayList<CharSequence2> arrayList = new ArrayList<CharSequence2>();
        arrayList.add(new CharSequence2Impl(string, null));
        IteratorCounter2 iteratorCounter2 = this.it99.cloneMe();
        if (iteratorCounter2.hasNext()) {
            iteratorCounter2.next();
        }
        while (iteratorCounter2.hasNext()) {
            arrayList.add(new CharSequence2Impl((CharSequence)iteratorCounter2.next(), null));
        }
        return new IteratorCounter2Impl(arrayList);
    }
}

