/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.ColorParam;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.FontParam;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.SkinParamUtils;
import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.cucadiagram.ILeaf;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Stereotype;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.svek.AbstractEntityImage;
import znaishaded.net.sourceforge.plantuml.svek.ShapeType;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChangeColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UEllipse;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class EntityImageLollipopInterface
extends AbstractEntityImage {
    private static final int SIZE = 10;
    private final TextBlock desc;
    private final Url url;

    public EntityImageLollipopInterface(ILeaf iLeaf, ISkinParam iSkinParam) {
        super(iLeaf, iSkinParam);
        Stereotype stereotype = iLeaf.getStereotype();
        this.desc = iLeaf.getDisplay().create(new FontConfiguration(this.getSkinParam(), FontParam.CLASS, stereotype), HorizontalAlignment.CENTER, iSkinParam);
        this.url = iLeaf.getUrl99();
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return new Dimension2DDouble(10.0, 10.0);
    }

    public final void drawU(UGraphic uGraphic) {
        UEllipse uEllipse = new UEllipse(10.0, 10.0);
        if (this.getSkinParam().shadowing()) {
            uEllipse.setDeltaShadow(4.0);
        }
        uGraphic = uGraphic.apply(new UChangeBackColor(SkinParamUtils.getColor(this.getSkinParam(), ColorParam.classBackground, this.getStereo()))).apply(new UChangeColor(SkinParamUtils.getColor(this.getSkinParam(), ColorParam.classBorder, this.getStereo())));
        if (this.url != null) {
            uGraphic.startUrl(this.url);
        }
        uGraphic.apply(new UStroke(1.5)).draw(uEllipse);
        Dimension2D dimension2D = this.desc.calculateDimension(uGraphic.getStringBounder());
        double d = dimension2D.getWidth();
        double d2 = 5.0 - d / 2.0;
        this.desc.drawU(uGraphic.apply(new UTranslate(d2, 10.0)));
        if (this.url != null) {
            uGraphic.closeAction();
        }
    }

    public ShapeType getShapeType() {
        return ShapeType.CIRCLE_IN_RECT;
    }
}

