/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.svg;

import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import znaishaded.net.sourceforge.plantuml.Log;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.SvgString;
import znaishaded.net.sourceforge.plantuml.code.Base64Coder;
import znaishaded.net.sourceforge.plantuml.eps.EpsGraphics;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColorGradient;
import znaishaded.net.sourceforge.plantuml.ugraphic.ColorMapper;
import znaishaded.net.sourceforge.plantuml.ugraphic.UPath;
import znaishaded.net.sourceforge.plantuml.ugraphic.USegment;
import znaishaded.net.sourceforge.plantuml.ugraphic.USegmentType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvgGraphics {
    private final Document document;
    private final Element root;
    private final Element defs;
    private final Element gRoot;
    private String fill = "black";
    private String stroke = "black";
    private String strokeWidth;
    private String strokeDasharray = null;
    private final String backcolor;
    private int maxX = 10;
    private int maxY = 10;
    private final double scale;
    private final String filterUid;
    private final String shadowId;
    private final String gradientId;
    private Element pendingBackground;
    private Map<List<Object>, String> gradients = new HashMap<List<Object>, String>();
    private final List<Element> pendingLink2 = new ArrayList<Element>();
    private final Map<String, String> filterBackColor = new HashMap<String, String>();
    private StringBuilder currentPath = null;
    private final Map<String, String> images = new HashMap<String, String>();
    private boolean withShadow = false;
    private boolean hidden;

    protected final void ensureVisible(double d, double d2) {
        if (d > (double)this.maxX) {
            this.maxX = (int)(d + 1.0);
        }
        if (d2 > (double)this.maxY) {
            this.maxY = (int)(d2 + 1.0);
        }
    }

    public SvgGraphics(Dimension2D dimension2D, double d, String string, long l) {
        this(dimension2D, null, d, string, l);
    }

    public SvgGraphics(Dimension2D dimension2D, String string, double d, String string2, long l) {
        try {
            this.scale = d;
            this.document = this.getDocument();
            this.backcolor = string;
            this.ensureVisible(dimension2D.getWidth(), dimension2D.getHeight());
            this.root = this.getRootNode();
            this.defs = this.simpleElement("defs");
            this.gRoot = this.simpleElement("g");
            this.strokeWidth = "" + d;
            this.filterUid = "b" + SvgGraphics.getSeed(l);
            this.shadowId = "f" + SvgGraphics.getSeed(l);
            this.gradientId = "g" + SvgGraphics.getSeed(l);
            if (string2 != null) {
                this.defs.appendChild(this.getPathHover(string2));
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
            throw new IllegalStateException(parserConfigurationException);
        }
    }

    private Element getPathHover(String string) {
        Element element = this.simpleElement("style");
        CDATASection cDATASection = this.document.createCDATASection("path:hover { stroke: " + string + " !important;}");
        element.setAttribute("type", "text/css");
        element.appendChild(cDATASection);
        return element;
    }

    private static String getSeed(long l) {
        return Long.toString(Math.abs(l), 36);
    }

    public void paintBackcolorGradient(ColorMapper colorMapper, HtmlColorGradient htmlColorGradient) {
        String string = this.createSvgGradient(StringUtils.getAsHtml(colorMapper.getMappedColor(htmlColorGradient.getColor1())), StringUtils.getAsHtml(colorMapper.getMappedColor(htmlColorGradient.getColor2())), htmlColorGradient.getPolicy());
        this.setFillColor("url(#" + string + ")");
        this.setStrokeColor(null);
        this.pendingBackground = this.createRectangleInternal(0.0, 0.0, 0.0, 0.0);
        this.getG().appendChild(this.pendingBackground);
    }

    private Element simpleElement(String string) {
        Element element = this.document.createElement(string);
        this.root.appendChild(element);
        return element;
    }

    private Document getDocument() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        document.setXmlStandalone(true);
        return document;
    }

    private Element getRootNode() {
        Element element = this.document.createElement("svg");
        this.document.appendChild(element);
        element.setAttribute("xmlns", "http://www.w3.org/2000/svg");
        element.setAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
        element.setAttribute("version", "1.1");
        return element;
    }

    public void svgEllipse(double d, double d2, double d3, double d4, double d5) {
        this.manageShadow(d5);
        if (!this.hidden) {
            Element element = this.document.createElement("ellipse");
            element.setAttribute("cx", this.format(d));
            element.setAttribute("cy", this.format(d2));
            element.setAttribute("rx", this.format(d3));
            element.setAttribute("ry", this.format(d4));
            element.setAttribute("fill", this.fill);
            element.setAttribute("style", this.getStyle());
            this.addFilterShadowId(element, d5);
            this.getG().appendChild(element);
        }
        this.ensureVisible(d + d3 + d5 * 2.0, d2 + d4 + d5 * 2.0);
    }

    public void svgArcEllipse(double d, double d2, double d3, double d4, double d5, double d6) {
        if (!this.hidden) {
            String string = "M" + this.format(d3) + "," + this.format(d4) + " A" + this.format(d) + "," + this.format(d2) + " 0 0 0 " + this.format(d5) + " " + this.format(d6);
            Element element = this.document.createElement("path");
            element.setAttribute("d", string);
            element.setAttribute("fill", this.fill);
            element.setAttribute("style", this.getStyle());
            this.getG().appendChild(element);
        }
        this.ensureVisible(d3, d4);
        this.ensureVisible(d5, d6);
    }

    public String createSvgGradient(String string, String string2, char c) {
        List<Object> list = Arrays.asList(string, string2, Character.valueOf(c));
        String string3 = this.gradients.get(list);
        if (string3 == null) {
            Element element = this.document.createElement("linearGradient");
            if (c == '|') {
                element.setAttribute("x1", "0%");
                element.setAttribute("y1", "50%");
                element.setAttribute("x2", "100%");
                element.setAttribute("y2", "50%");
            } else if (c == '\\') {
                element.setAttribute("x1", "0%");
                element.setAttribute("y1", "100%");
                element.setAttribute("x2", "100%");
                element.setAttribute("y2", "0%");
            } else if (c == '-') {
                element.setAttribute("x1", "50%");
                element.setAttribute("y1", "0%");
                element.setAttribute("x2", "50%");
                element.setAttribute("y2", "100%");
            } else {
                element.setAttribute("x1", "0%");
                element.setAttribute("y1", "0%");
                element.setAttribute("x2", "100%");
                element.setAttribute("y2", "100%");
            }
            string3 = this.gradientId + this.gradients.size();
            this.gradients.put(list, string3);
            element.setAttribute("id", string3);
            Element element2 = this.document.createElement("stop");
            element2.setAttribute("stop-color", string);
            element2.setAttribute("offset", "0%");
            Element element3 = this.document.createElement("stop");
            element3.setAttribute("stop-color", string2);
            element3.setAttribute("offset", "100%");
            element.appendChild(element2);
            element.appendChild(element3);
            this.defs.appendChild(element);
        }
        return string3;
    }

    public final void setFillColor(String string) {
        this.fill = string == null ? "none" : string;
    }

    public final void setStrokeColor(String string) {
        this.stroke = string == null ? "none" : string;
    }

    public final void setStrokeWidth(double d, String string) {
        this.strokeWidth = "" + this.scale * d;
        this.strokeDasharray = string;
    }

    public void closeLink() {
        if (this.pendingLink2.size() > 0) {
            Element element = this.pendingLink2.get(0);
            this.pendingLink2.remove(0);
            this.getG().appendChild(element);
        }
    }

    public void openLink(String string, String string2, String string3) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (this.pendingLink2.size() > 0) {
            this.closeLink();
        }
        this.pendingLink2.add(0, this.document.createElement("a"));
        this.pendingLink2.get(0).setAttribute("target", string3);
        this.pendingLink2.get(0).setAttribute("xlink:href", string);
        this.pendingLink2.get(0).setAttribute("xlink:type", "simple");
        this.pendingLink2.get(0).setAttribute("xlink:actuate", "onRequest");
        this.pendingLink2.get(0).setAttribute("xlink:show", "new");
        if (string2 == null) {
            this.pendingLink2.get(0).setAttribute("xlink:title", string);
        } else {
            string2 = string2.replaceAll("\\\\n", "\n");
            this.pendingLink2.get(0).setAttribute("xlink:title", string2);
        }
    }

    public final Element getG() {
        if (this.pendingLink2.size() == 0) {
            return this.gRoot;
        }
        return this.pendingLink2.get(0);
    }

    public void svgRectangle(double d, double d2, double d3, double d4, double d5, double d6, double d7, String string) {
        if (d4 <= 0.0 || d3 <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.manageShadow(d7);
        if (!this.hidden) {
            Element element = this.createRectangleInternal(d, d2, d3, d4);
            this.addFilterShadowId(element, d7);
            if (d5 > 0.0 && d6 > 0.0) {
                element.setAttribute("rx", this.format(d5));
                element.setAttribute("ry", this.format(d6));
            }
            if (string != null) {
                element.setAttribute("id", string);
            }
            this.getG().appendChild(element);
        }
        this.ensureVisible(d + d3 + 2.0 * d7, d2 + d4 + 2.0 * d7);
    }

    private Element createRectangleInternal(double d, double d2, double d3, double d4) {
        Element element = this.document.createElement("rect");
        element.setAttribute("x", this.format(d));
        element.setAttribute("y", this.format(d2));
        element.setAttribute("width", this.format(d3));
        element.setAttribute("height", this.format(d4));
        element.setAttribute("fill", this.fill);
        element.setAttribute("style", this.getStyle());
        return element;
    }

    public void svgLine(double d, double d2, double d3, double d4, double d5) {
        this.manageShadow(d5);
        if (!this.hidden) {
            Element element = this.document.createElement("line");
            element.setAttribute("x1", this.format(d));
            element.setAttribute("y1", this.format(d2));
            element.setAttribute("x2", this.format(d3));
            element.setAttribute("y2", this.format(d4));
            element.setAttribute("style", this.getStyle());
            this.addFilterShadowId(element, d5);
            this.getG().appendChild(element);
        }
        this.ensureVisible(d + 2.0 * d5, d2 + 2.0 * d5);
        this.ensureVisible(d3 + 2.0 * d5, d4 + 2.0 * d5);
    }

    private String getStyle() {
        return SvgGraphics.getStyleInternal(this.stroke, this.strokeWidth, this.strokeDasharray);
    }

    private static String getStyleInternal(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder("stroke: " + string + "; stroke-width: " + string2 + ";");
        if (string3 != null) {
            stringBuilder.append(" stroke-dasharray: " + string3 + ";");
        }
        return stringBuilder.toString();
    }

    public void svgPolygon(double d, double ... dArray) {
        this.manageShadow(d);
        if (!this.hidden) {
            Element element = this.document.createElement("polygon");
            StringBuilder stringBuilder = new StringBuilder();
            for (double d2 : dArray) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(this.format(d2));
            }
            element.setAttribute("points", stringBuilder.toString());
            element.setAttribute("fill", this.fill);
            element.setAttribute("style", this.getStyle());
            this.addFilterShadowId(element, d);
            this.getG().appendChild(element);
        }
        for (int i = 0; i < dArray.length; i += 2) {
            this.ensureVisible(dArray[i] + 2.0 * d, dArray[i + 1] + 2.0 * d);
        }
    }

    public void text(String string, double d, double d2, String string2, int n, String string3, String string4, String string5, double d3, Map<String, String> map, String string6) {
        if (!this.hidden) {
            Element element = this.document.createElement("text");
            element.setAttribute("x", this.format(d));
            element.setAttribute("y", this.format(d2));
            element.setAttribute("fill", this.fill);
            element.setAttribute("font-size", this.format(n));
            element.setAttribute("lengthAdjust", "spacingAndGlyphs");
            element.setAttribute("textLength", this.format(d3));
            if (string3 != null) {
                element.setAttribute("font-weight", string3);
            }
            if (string4 != null) {
                element.setAttribute("font-style", string4);
            }
            if (string5 != null) {
                element.setAttribute("text-decoration", string5);
            }
            if (string2 != null) {
                if ("monospaced".equalsIgnoreCase(string2)) {
                    string2 = "monospace";
                }
                element.setAttribute("font-family", string2);
                if (string2.equalsIgnoreCase("monospace") || string2.equalsIgnoreCase("courier")) {
                    string = string.replace(' ', '\u00a0');
                }
            }
            if (string6 != null) {
                String string7 = this.getFilterBackColor(string6);
                element.setAttribute("filter", "url(#" + (String)string7 + ")");
            }
            for (Map.Entry entry : map.entrySet()) {
                element.setAttribute((String)entry.getKey(), (String)entry.getValue());
            }
            element.setTextContent(string);
            this.getG().appendChild(element);
            if (string5 != null && string5.contains("underline")) {
                Element element2 = this.document.createElement("line");
                element2.setAttribute("x1", this.format(d));
                element2.setAttribute("y1", this.format(d2 + 2.0));
                element2.setAttribute("x2", this.format(d + d3));
                element2.setAttribute("y2", this.format(d2 + 2.0));
                element2.setAttribute("style", SvgGraphics.getStyleInternal(this.fill, "1.0", null));
                this.getG().appendChild(element2);
            }
        }
        this.ensureVisible(d, d2);
        this.ensureVisible(d + d3, d2);
    }

    private String getIdFilterBackColor(String string) {
        String string2 = this.filterBackColor.get(string);
        if (string2 == null) {
            string2 = this.filterUid + this.filterBackColor.size();
            this.filterBackColor.put(string, string2);
        }
        return string2;
    }

    private String getFilterBackColor(String string) {
        String string2 = this.filterBackColor.get(string);
        if (string2 != null) {
            return string2;
        }
        string2 = this.getIdFilterBackColor(string);
        Element element = this.document.createElement("filter");
        element.setAttribute("id", string2);
        element.setAttribute("x", "0");
        element.setAttribute("y", "0");
        element.setAttribute("width", "1");
        element.setAttribute("height", "1");
        this.addFilter(element, "feFlood", "flood-color", string, "result", "flood");
        this.addFilter(element, "feComposite", "in", "SourceGraphic", "in2", "flood", "operator", "over");
        this.defs.appendChild(element);
        return string2;
    }

    private Transformer getTransformer() throws TransformerException {
        Object object;
        TransformerFactory transformerFactory = null;
        try {
            object = Class.forName("com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl");
            transformerFactory = (TransformerFactory)((Class)object).newInstance();
        }
        catch (Exception exception) {
            transformerFactory = TransformerFactory.newInstance();
        }
        Log.info("TransformerFactory=" + transformerFactory.getClass());
        object = transformerFactory.newTransformer();
        Log.info("Transformer=" + object.getClass());
        ((Transformer)object).setOutputProperty("standalone", "no");
        return object;
    }

    public void createXml(OutputStream outputStream) throws TransformerException, IOException {
        if (this.images.size() == 0) {
            this.createXmlInternal(outputStream);
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.createXmlInternal(byteArrayOutputStream);
        String string = new String(byteArrayOutputStream.toByteArray());
        for (Map.Entry<String, String> entry : this.images.entrySet()) {
            String string2 = "\\<" + entry.getKey() + "/\\>";
            string = string.replaceAll(string2, entry.getValue());
        }
        outputStream.write(string.getBytes());
    }

    private void createXmlInternal(OutputStream outputStream) throws TransformerException {
        DOMSource dOMSource = new DOMSource(this.document);
        int n = (int)((double)this.maxX * this.scale);
        int n2 = (int)((double)this.maxY * this.scale);
        String string = "width:" + n + "px;height:" + n2 + "px;";
        if (this.backcolor != null) {
            string = string + "background:" + this.backcolor + ";";
        }
        this.root.setAttribute("style", string);
        this.root.setAttribute("width", this.format(this.maxX) + "px");
        this.root.setAttribute("height", this.format(this.maxY) + "px");
        this.root.setAttribute("viewBox", "0 0 " + n + " " + n2);
        this.root.setAttribute("zoomAndPan", "magnify");
        this.root.setAttribute("preserveAspectRatio", "none");
        this.root.setAttribute("contentScriptType", "application/ecmascript");
        this.root.setAttribute("contentStyleType", "text/css");
        if (this.pendingBackground != null) {
            this.pendingBackground.setAttribute("width", this.format(this.maxX));
            this.pendingBackground.setAttribute("height", this.format(this.maxY));
        }
        StreamResult streamResult = new StreamResult(outputStream);
        this.getTransformer().transform(dOMSource, streamResult);
    }

    public void svgPath(double d, double d2, UPath uPath, double d3) {
        this.manageShadow(d3);
        this.ensureVisible(d, d2);
        StringBuilder stringBuilder = new StringBuilder();
        for (Object object : uPath) {
            USegmentType uSegmentType = ((USegment)object).getSegmentType();
            double[] dArray = ((USegment)object).getCoord();
            if (uSegmentType == USegmentType.SEG_MOVETO) {
                stringBuilder.append("M" + this.format(dArray[0] + d) + "," + this.format(dArray[1] + d2) + " ");
                this.ensureVisible(dArray[0] + d + 2.0 * d3, dArray[1] + d2 + 2.0 * d3);
                continue;
            }
            if (uSegmentType == USegmentType.SEG_LINETO) {
                stringBuilder.append("L" + this.format(dArray[0] + d) + "," + this.format(dArray[1] + d2) + " ");
                this.ensureVisible(dArray[0] + d + 2.0 * d3, dArray[1] + d2 + 2.0 * d3);
                continue;
            }
            if (uSegmentType == USegmentType.SEG_QUADTO) {
                stringBuilder.append("Q" + this.format(dArray[0] + d) + "," + this.format(dArray[1] + d2) + " " + this.format(dArray[2] + d) + "," + this.format(dArray[3] + d2) + " ");
                this.ensureVisible(dArray[0] + d + 2.0 * d3, dArray[1] + d2 + 2.0 * d3);
                this.ensureVisible(dArray[2] + d + 2.0 * d3, dArray[3] + d2 + 2.0 * d3);
                continue;
            }
            if (uSegmentType == USegmentType.SEG_CUBICTO) {
                stringBuilder.append("C" + this.format(dArray[0] + d) + "," + this.format(dArray[1] + d2) + " " + this.format(dArray[2] + d) + "," + this.format(dArray[3] + d2) + " " + this.format(dArray[4] + d) + "," + this.format(dArray[5] + d2) + " ");
                this.ensureVisible(dArray[0] + d + 2.0 * d3, dArray[1] + d2 + 2.0 * d3);
                this.ensureVisible(dArray[2] + d + 2.0 * d3, dArray[3] + d2 + 2.0 * d3);
                this.ensureVisible(dArray[4] + d + 2.0 * d3, dArray[5] + d2 + 2.0 * d3);
                continue;
            }
            if (uSegmentType == USegmentType.SEG_ARCTO) {
                stringBuilder.append("A" + this.format(dArray[0]) + "," + this.format(dArray[1]) + " " + this.format(dArray[2]) + "," + this.format(dArray[3]) + " " + this.format(dArray[4]) + "," + this.format(dArray[5] + d) + "," + this.format(dArray[6] + d2) + " ");
                this.ensureVisible(dArray[5] + dArray[0] + d + 2.0 * d3, dArray[6] + dArray[1] + d2 + 2.0 * d3);
                continue;
            }
            if (uSegmentType == USegmentType.SEG_CLOSE) continue;
            Log.println("unknown " + object);
        }
        if (!this.hidden) {
            Object object;
            Element element = this.document.createElement("path");
            element.setAttribute("d", stringBuilder.toString());
            element.setAttribute("style", this.getStyle());
            element.setAttribute("fill", this.fill);
            object = uPath.getComment();
            if (object != null) {
                element.setAttribute("id", (String)object);
            }
            this.addFilterShadowId(element, d3);
            this.getG().appendChild(element);
        }
    }

    private void addFilterShadowId(Element element, double d) {
        if (d > 0.0) {
            element.setAttribute("filter", "url(#" + this.shadowId + ")");
        }
    }

    public void newpath() {
        this.currentPath = new StringBuilder();
    }

    public void moveto(double d, double d2) {
        this.currentPath.append("M" + this.format(d) + "," + this.format(d2) + " ");
        this.ensureVisible(d, d2);
    }

    public void lineto(double d, double d2) {
        this.currentPath.append("L" + this.format(d) + "," + this.format(d2) + " ");
        this.ensureVisible(d, d2);
    }

    public void closepath() {
        this.currentPath.append("Z ");
    }

    public void curveto(double d, double d2, double d3, double d4, double d5, double d6) {
        this.currentPath.append("C" + this.format(d) + "," + this.format(d2) + " " + this.format(d3) + "," + this.format(d4) + " " + this.format(d5) + "," + this.format(d6) + " ");
        this.ensureVisible(d, d2);
        this.ensureVisible(d3, d4);
        this.ensureVisible(d5, d6);
    }

    public void quadto(double d, double d2, double d3, double d4) {
        this.currentPath.append("Q" + this.format(d) + "," + this.format(d2) + " " + this.format(d3) + "," + this.format(d4) + " ");
        this.ensureVisible(d, d2);
        this.ensureVisible(d3, d4);
    }

    private String format(double d) {
        return EpsGraphics.format(d * this.scale);
    }

    public void fill(int n) {
        if (!this.hidden) {
            Element element = this.document.createElement("path");
            element.setAttribute("d", this.currentPath.toString());
            this.getG().appendChild(element);
        }
        this.currentPath = null;
    }

    public void svgImage(BufferedImage bufferedImage, double d, double d2) throws IOException {
        if (!this.hidden) {
            Element element = this.document.createElement("image");
            element.setAttribute("width", this.format(bufferedImage.getWidth()));
            element.setAttribute("height", this.format(bufferedImage.getHeight()));
            element.setAttribute("x", this.format(d));
            element.setAttribute("y", this.format(d2));
            String string = this.toBase64(bufferedImage);
            element.setAttribute("xlink:href", "data:image/png;base64," + string);
            this.getG().appendChild(element);
        }
        this.ensureVisible(d, d2);
        this.ensureVisible(d + (double)bufferedImage.getWidth(), d2 + (double)bufferedImage.getHeight());
    }

    public void svgImage(SvgString svgString, double d, double d2) {
        if (!this.hidden) {
            String string = this.manageScale(svgString);
            String string2 = "<svg x=\"" + this.format(d) + "\" y=\"" + this.format(d2) + "\">";
            string = string2 + string.substring(5);
            String string3 = "imagesvginlined" + this.images.size();
            Element element = this.document.createElement(string3);
            this.getG().appendChild(element);
            this.images.put(string3, string);
        }
        this.ensureVisible(d, d2);
        this.ensureVisible(d + (double)svgString.getData("width"), d2 + (double)svgString.getData("height"));
    }

    private String manageScale(SvgString svgString) {
        double d = svgString.getScale();
        if (d * this.scale == 1.0) {
            return svgString.getSvg();
        }
        String string = "<g transform=\"scale(" + this.format(d) + "," + this.format(d) + ")\" ";
        return svgString.getSvg().replaceFirst("\\<g\\b", string);
    }

    private String toBase64(BufferedImage bufferedImage) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        return new String(Base64Coder.encode(byArray));
    }

    private void manageShadow(double d) {
        if (d != 0.0) {
            if (!this.withShadow) {
                Element element = this.document.createElement("filter");
                element.setAttribute("id", this.shadowId);
                element.setAttribute("x", "-1");
                element.setAttribute("y", "-1");
                element.setAttribute("width", "300%");
                element.setAttribute("height", "300%");
                this.addFilter(element, "feGaussianBlur", "result", "blurOut", "stdDeviation", "" + 2.0 * this.scale);
                this.addFilter(element, "feColorMatrix", "type", "matrix", "in", "blurOut", "result", "blurOut2", "values", "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 .4 0");
                this.addFilter(element, "feOffset", "result", "blurOut3", "in", "blurOut2", "dx", "" + 4.0 * this.scale, "dy", "" + 4.0 * this.scale);
                this.addFilter(element, "feBlend", "in", "SourceGraphic", "in2", "blurOut3", "mode", "normal");
                this.defs.appendChild(element);
            }
            this.withShadow = true;
        }
    }

    private void addFilter(Element element, String string, String ... stringArray) {
        Element element2 = this.document.createElement(string);
        for (int i = 0; i < stringArray.length; i += 2) {
            element2.setAttribute(stringArray[i], stringArray[i + 1]);
        }
        element.appendChild(element2);
    }

    public void setHidden(boolean bl) {
        this.hidden = bl;
    }

    public void addComment(String string) {
        Comment comment = this.document.createComment(string);
        this.getG().appendChild(comment);
    }
}

