/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.diagrams.slides;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.diagrams.slides.DiagramSlides;
import org.testingisdocumenting.znai.parser.MarkupParser;
import org.testingisdocumenting.znai.parser.MarkupParserResult;
import org.testingisdocumenting.znai.parser.docelement.DocElement;

public class MarkupDiagramSlides {
    private DiagramSlides diagramSlides;
    private List<DocElement> sections;
    private List<String> currentIds;
    private MarkupParser parser;
    private MarkupParserResult parserResult;

    public MarkupDiagramSlides(MarkupParser parser) {
        this.parser = parser;
    }

    public DiagramSlides create(Path path2, String markupContent) {
        this.parse(path2, markupContent);
        this.currentIds = new ArrayList<String>();
        this.diagramSlides = new DiagramSlides();
        this.sections.forEach(this::convert);
        return this.diagramSlides;
    }

    public List<AuxiliaryFile> getAuxiliaryFiles() {
        return this.parserResult.getAuxiliaryFiles();
    }

    private void parse(Path path2, String markupContent) {
        this.parserResult = this.parser.parse(path2, markupContent);
        this.sections = this.parserResult.getDocElement().getContent().stream().filter(e -> e.getType().equals("Section")).collect(Collectors.toList());
    }

    private void convert(DocElement section) {
        this.currentIds.add(section.getProp("title").toString());
        if (!section.getContent().isEmpty()) {
            this.diagramSlides.add(this.currentIds, section.getContent());
            this.currentIds = new ArrayList<String>();
        }
    }
}

