/*
 * Decompiled with CFR 0.152.
 */
package smetana.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import smetana.core.CType;
import smetana.core.JUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bucket {
    public final String name;
    public final CType ctype;
    private final boolean inlineStruct;

    private Bucket addPrefix(String string) {
        return new Bucket(string + "." + this.name, this.ctype, this.inlineStruct);
    }

    public static Bucket buildEnum(String string, List<String> list) {
        return new Bucket(string, new CType("enum"), false);
    }

    Bucket(String string, String string2, boolean bl) {
        this(string, new CType(string2), bl);
    }

    private Bucket(String string, CType cType, boolean bl) {
        this.name = string;
        this.ctype = cType;
        this.inlineStruct = bl;
    }

    public String toString() {
        return "[" + this.ctype + "==" + this.name + "]";
    }

    public boolean inlineStruct() {
        return this.inlineStruct;
    }

    public boolean functionPointer() {
        if (this.ctype == null) {
            return false;
        }
        return this.ctype.functionPointer();
    }

    public static Map<String, Bucket> buildSome(Iterator<String> iterator) {
        String string = iterator.next();
        JUtils.LOG("DEF1=" + string);
        string = string.replaceAll("unsigned int", "int");
        string = string.replaceAll("unsigned long", "int");
        string = string.replaceAll("unsigned short", "short");
        string = string.replaceAll("unsigned char", "char");
        string = string.replaceAll("const ", "");
        string = string.replaceAll("struct ", "");
        string = string.replaceAll("\\[\\s*[+]1\\s*[+]1\\s*[+]1\\s*[+]1\\s*[+]1\\s*\\]", "[5]");
        if (string.equals("union")) {
            return Bucket.createStruct(iterator);
        }
        if (string.equals("struct")) {
            return Bucket.createStruct(iterator);
        }
        LinkedHashMap<String, Bucket> linkedHashMap = new LinkedHashMap<String, Bucket>();
        Pattern pattern = Pattern.compile("^(\\w+)\\s+(\\w+)$");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            String string2 = matcher.group(1);
            boolean bl = !CType.isPrimitive(string2);
            linkedHashMap.put(matcher.group(2), new Bucket(matcher.group(2), string2, bl));
            return linkedHashMap;
        }
        pattern = Pattern.compile("^(\\w+)\\s+(\\w+),\\s*(\\w+)$");
        matcher = pattern.matcher(string);
        if (matcher.find()) {
            String string3 = matcher.group(1);
            boolean bl = !CType.isPrimitive(string3);
            linkedHashMap.put(matcher.group(2), new Bucket(matcher.group(2), string3, bl));
            linkedHashMap.put(matcher.group(3), new Bucket(matcher.group(3), string3, bl));
            return linkedHashMap;
        }
        pattern = Pattern.compile("^(\\w+)\\s+(\\w+),\\s*(\\w+),\\s*(\\w+)$");
        matcher = pattern.matcher(string);
        if (matcher.find()) {
            String string4 = matcher.group(1);
            boolean bl = !CType.isPrimitive(string4);
            linkedHashMap.put(matcher.group(2), new Bucket(matcher.group(2), string4, bl));
            linkedHashMap.put(matcher.group(3), new Bucket(matcher.group(3), string4, bl));
            linkedHashMap.put(matcher.group(4), new Bucket(matcher.group(4), string4, bl));
            return linkedHashMap;
        }
        pattern = Pattern.compile("^(\\w+)\\s+(\\w+),\\s*(\\w+),\\s*(\\w+),\\s*(\\w+)$");
        matcher = pattern.matcher(string);
        if (matcher.find()) {
            String string5 = matcher.group(1);
            boolean bl = !CType.isPrimitive(string5);
            linkedHashMap.put(matcher.group(2), new Bucket(matcher.group(2), string5, bl));
            linkedHashMap.put(matcher.group(3), new Bucket(matcher.group(3), string5, bl));
            linkedHashMap.put(matcher.group(4), new Bucket(matcher.group(4), string5, bl));
            linkedHashMap.put(matcher.group(5), new Bucket(matcher.group(5), string5, bl));
            return linkedHashMap;
        }
        pattern = Pattern.compile("^(\\w+)\\s+(\\w+),\\s*(\\w+),\\s*(\\w+),\\s*(\\w+),\\s*(\\w+)$");
        matcher = pattern.matcher(string);
        if (matcher.find()) {
            String string6 = matcher.group(1);
            boolean bl = !CType.isPrimitive(string6);
            linkedHashMap.put(matcher.group(2), new Bucket(matcher.group(2), string6, bl));
            linkedHashMap.put(matcher.group(3), new Bucket(matcher.group(3), string6, bl));
            linkedHashMap.put(matcher.group(4), new Bucket(matcher.group(4), string6, bl));
            linkedHashMap.put(matcher.group(5), new Bucket(matcher.group(5), string6, bl));
            linkedHashMap.put(matcher.group(6), new Bucket(matcher.group(6), string6, bl));
            return linkedHashMap;
        }
        pattern = Pattern.compile("^.*(\\(\\*(\\w+)\\)).*$");
        matcher = pattern.matcher(string);
        if (matcher.find()) {
            linkedHashMap.put(matcher.group(1), new Bucket(matcher.group(2), string, false));
            return linkedHashMap;
        }
        pattern = Pattern.compile("^(void)\\s+\\*(\\w+)$");
        matcher = pattern.matcher(string);
        if (matcher.find()) {
            linkedHashMap.put(matcher.group(2), new Bucket(matcher.group(2), "void*", false));
            return linkedHashMap;
        }
        pattern = Pattern.compile("^(char)\\s+\\*(\\w+)$");
        matcher = pattern.matcher(string);
        if (matcher.find()) {
            linkedHashMap.put(matcher.group(2), new Bucket(matcher.group(2), "CString", false));
            return linkedHashMap;
        }
        pattern = Pattern.compile("^(int)\\s+\\*(\\w+)$");
        matcher = pattern.matcher(string);
        if (matcher.find()) {
            linkedHashMap.put(matcher.group(2), new Bucket(matcher.group(2), "int*", false));
            return linkedHashMap;
        }
        pattern = Pattern.compile("^(char)\\s+\\*\\*(\\w+)$");
        matcher = pattern.matcher(string);
        if (matcher.find()) {
            linkedHashMap.put(matcher.group(2), new Bucket(matcher.group(2), "CString[]", false));
            return linkedHashMap;
        }
        pattern = Pattern.compile("^(void)(\\s+\\*|\\*\\s+)(\\w+)$");
        matcher = pattern.matcher(string);
        if (matcher.find()) {
            linkedHashMap.put(matcher.group(3), new Bucket(matcher.group(3), "void*", false));
            return linkedHashMap;
        }
        pattern = Pattern.compile("^(\\w+)(\\s+\\*|\\*\\s+)(\\w+)$");
        matcher = pattern.matcher(string);
        if (matcher.find()) {
            String string7 = matcher.group(1);
            linkedHashMap.put(matcher.group(3), new Bucket(matcher.group(3), string7, false));
            return linkedHashMap;
        }
        pattern = Pattern.compile("^(\\w+)\\s+\\*(\\w+),\\s*\\*(\\w+)$");
        matcher = pattern.matcher(string);
        if (matcher.find()) {
            String string8 = matcher.group(1);
            linkedHashMap.put(matcher.group(2), new Bucket(matcher.group(2), string8, false));
            linkedHashMap.put(matcher.group(3), new Bucket(matcher.group(3), string8, false));
            return linkedHashMap;
        }
        pattern = Pattern.compile("^(\\w+)\\s+\\*(\\w+),\\s*\\*(\\w+),\\s*\\*(\\w+)$");
        matcher = pattern.matcher(string);
        if (matcher.find()) {
            String string9 = matcher.group(1);
            linkedHashMap.put(matcher.group(2), new Bucket(matcher.group(2), string9, false));
            linkedHashMap.put(matcher.group(3), new Bucket(matcher.group(3), string9, false));
            linkedHashMap.put(matcher.group(4), new Bucket(matcher.group(4), string9, false));
            return linkedHashMap;
        }
        pattern = Pattern.compile("^(\\w+)\\s+\\*(\\w+),\\s*\\*(\\w+),\\s*\\*(\\w+),\\s*\\*(\\w+)$");
        matcher = pattern.matcher(string);
        if (matcher.find()) {
            String string10 = matcher.group(1);
            linkedHashMap.put(matcher.group(2), new Bucket(matcher.group(2), string10, false));
            linkedHashMap.put(matcher.group(3), new Bucket(matcher.group(3), string10, false));
            linkedHashMap.put(matcher.group(4), new Bucket(matcher.group(4), string10, false));
            linkedHashMap.put(matcher.group(5), new Bucket(matcher.group(5), string10, false));
            return linkedHashMap;
        }
        pattern = Pattern.compile("^(unsigned|int)\\s+(\\w+):([-sizeof ntunsged()0-9*]+)$");
        matcher = pattern.matcher(string);
        if (matcher.find()) {
            linkedHashMap.put(matcher.group(2), new Bucket(matcher.group(2), "int", false));
            return linkedHashMap;
        }
        pattern = Pattern.compile("^(\\w+)\\s+(\\w+)\\[\\d+\\]$");
        matcher = pattern.matcher(string);
        if (matcher.find()) {
            linkedHashMap.put(matcher.group(1), new Bucket(matcher.group(2), string, true));
            return linkedHashMap;
        }
        pattern = Pattern.compile("^(\\w+)\\s+\\*(\\w+)\\[\\d+\\]$");
        matcher = pattern.matcher(string);
        if (matcher.find()) {
            Bucket bucket = new Bucket(matcher.group(2), string, false);
            JUtils.LOG("size=" + bucket.getArrayLength());
            linkedHashMap.put(matcher.group(1), bucket);
            return linkedHashMap;
        }
        pattern = Pattern.compile("^(\\w+)\\s+\\*\\*(\\w+)$");
        matcher = pattern.matcher(string);
        if (matcher.find()) {
            String string11 = matcher.group(1) + "*";
            linkedHashMap.put(matcher.group(2), new Bucket(matcher.group(2), string11, false));
            return linkedHashMap;
        }
        pattern = Pattern.compile("^(\\w+)\\s+\\*\\*(\\w+),\\s*\\*\\*(\\w+),\\s*\\*\\*(\\w+),\\s*\\*\\*(\\w+)$");
        matcher = pattern.matcher(string);
        if (matcher.find()) {
            String string12 = matcher.group(1) + "*";
            linkedHashMap.put(matcher.group(2), new Bucket(matcher.group(2), string12, false));
            linkedHashMap.put(matcher.group(3), new Bucket(matcher.group(3), string12, false));
            linkedHashMap.put(matcher.group(4), new Bucket(matcher.group(4), string12, false));
            linkedHashMap.put(matcher.group(5), new Bucket(matcher.group(5), string12, false));
            return linkedHashMap;
        }
        pattern = Pattern.compile("^(\\w+)\\s+\\*(\\w+),\\s*\\*\\*(\\w+)$");
        matcher = pattern.matcher(string);
        if (matcher.find()) {
            String string13 = matcher.group(1);
            linkedHashMap.put(matcher.group(2), new Bucket(matcher.group(2), string13, false));
            linkedHashMap.put(matcher.group(3), new Bucket(matcher.group(3), string13 + "*", false));
            return linkedHashMap;
        }
        pattern = Pattern.compile("^(\\w+)\\*\\*\\s+(\\w+)$");
        matcher = pattern.matcher(string);
        if (matcher.find()) {
            String string14 = matcher.group(1) + "*";
            linkedHashMap.put(matcher.group(2), new Bucket(matcher.group(2), string14, false));
            return linkedHashMap;
        }
        if (string.equals("double **dist, **spring, **sum_t, ***t")) {
            return linkedHashMap;
        }
        if (string.equals("double *pos, dist")) {
            linkedHashMap.put("pos", new Bucket("pos", "double*", false));
            linkedHashMap.put("dist", new Bucket("dist", "double", false));
            return linkedHashMap;
        }
        JUtils.LOG("def=" + string);
        throw new UnsupportedOperationException(string);
    }

    private static Map<String, Bucket> createStruct(Iterator<String> iterator) {
        String string = iterator.next();
        if (!string.equals("{")) {
            throw new UnsupportedOperationException("current=" + string);
        }
        LinkedHashMap<String, Bucket> linkedHashMap = new LinkedHashMap<String, Bucket>();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (true) {
            Object object;
            if ((string = iterator.next()).equals("union") || string.equals("struct")) {
                object = Bucket.createStruct(iterator);
                JUtils.LOG("internal=" + object);
                linkedHashMap.putAll((Map<String, Bucket>)object);
                continue;
            }
            if (string.endsWith("}")) {
                object = iterator.next();
                JUtils.LOG("name=" + (String)object);
                JUtils.LOG("inner=" + arrayList);
                Iterator<String> iterator2 = arrayList.iterator();
                while (iterator2.hasNext()) {
                    linkedHashMap.putAll(Bucket.buildSome(iterator2));
                }
                LinkedHashMap<String, Bucket> linkedHashMap2 = new LinkedHashMap<String, Bucket>();
                for (Map.Entry entry : linkedHashMap.entrySet()) {
                    String string2 = (String)entry.getKey();
                    Bucket bucket = ((Bucket)entry.getValue()).addPrefix((String)object);
                    JUtils.LOG("n=" + string2);
                    JUtils.LOG("bucket=" + bucket);
                    linkedHashMap2.put((String)object + "." + string2, bucket);
                }
                return linkedHashMap2;
            }
            arrayList.add(string);
        }
    }

    public int getArrayLength() {
        if (this.ctype == null) {
            return 0;
        }
        return this.ctype.getArrayLength();
    }
}

