/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.freemarker.core;

import java.io.StringReader;
import znaishaded.freemarker.core.BuiltInForString;
import znaishaded.freemarker.core.Environment;
import znaishaded.freemarker.core.Expression;
import znaishaded.freemarker.core.FMParser;
import znaishaded.freemarker.core.FMParserTokenManager;
import znaishaded.freemarker.core.NonNumericalException;
import znaishaded.freemarker.core.ParseException;
import znaishaded.freemarker.core.SimpleCharStream;
import znaishaded.freemarker.core.TokenMgrError;
import znaishaded.freemarker.core._DelayedGetMessage;
import znaishaded.freemarker.core._DelayedGetMessageWithoutStackTop;
import znaishaded.freemarker.core._DelayedJQuote;
import znaishaded.freemarker.core._MiscTemplateException;
import znaishaded.freemarker.template.Configuration;
import znaishaded.freemarker.template.SimpleNumber;
import znaishaded.freemarker.template.TemplateBooleanModel;
import znaishaded.freemarker.template.TemplateException;
import znaishaded.freemarker.template.TemplateModel;

class BuiltInsForStringsMisc {
    private BuiltInsForStringsMisc() {
    }

    static class numberBI
    extends BuiltInForString {
        numberBI() {
        }

        TemplateModel calculateResult(String s2, Environment env) throws TemplateException {
            try {
                return new SimpleNumber(env.getArithmeticEngine().toNumber(s2));
            }
            catch (NumberFormatException nfe) {
                throw NonNumericalException.newMalformedNumberException(this, s2, env);
            }
        }
    }

    static class evalBI
    extends BuiltInForString {
        evalBI() {
        }

        TemplateModel calculateResult(String s2, Environment env) throws TemplateException {
            int namingConvention;
            SimpleCharStream scs = new SimpleCharStream(new StringReader("(" + s2 + ")"), -1000000000, 1, s2.length() + 2);
            FMParserTokenManager token_source = new FMParserTokenManager(scs);
            Configuration cfg = env.getConfiguration();
            token_source.incompatibleImprovements = cfg.getIncompatibleImprovements().intValue();
            token_source.SwitchTo(2);
            token_source.initialNamingConvention = namingConvention = cfg.getNamingConvention();
            token_source.namingConvention = namingConvention;
            FMParser parser = new FMParser(token_source);
            parser.setTemplate(this.getTemplate());
            Expression exp = null;
            try {
                try {
                    exp = parser.Expression();
                }
                catch (TokenMgrError e) {
                    throw e.toParseException(this.getTemplate());
                }
            }
            catch (ParseException e) {
                throw new _MiscTemplateException((Expression)this, env, new Object[]{"Failed to \"?", this.key, "\" string with this error:\n\n", "---begin-message---\n", new _DelayedGetMessage(e), "\n---end-message---", "\n\nThe failing expression:"});
            }
            try {
                return exp.eval(env);
            }
            catch (TemplateException e) {
                throw new _MiscTemplateException((Expression)this, env, new Object[]{"Failed to \"?", this.key, "\" string with this error:\n\n", "---begin-message---\n", new _DelayedGetMessageWithoutStackTop(e), "\n---end-message---", "\n\nThe failing expression:"});
            }
        }
    }

    static class booleanBI
    extends BuiltInForString {
        booleanBI() {
        }

        TemplateModel calculateResult(String s2, Environment env) throws TemplateException {
            boolean b;
            if (s2.equals("true")) {
                b = true;
            } else if (s2.equals("false")) {
                b = false;
            } else if (s2.equals(env.getTrueStringValue())) {
                b = true;
            } else if (s2.equals(env.getFalseStringValue())) {
                b = false;
            } else {
                throw new _MiscTemplateException((Expression)this, env, new Object[]{"Can't convert this string to boolean: ", new _DelayedJQuote(s2)});
            }
            return b ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }
}

