/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.file.impl;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import znaishaded.io.vertx.core.AsyncResult;
import znaishaded.io.vertx.core.Handler;
import znaishaded.io.vertx.core.buffer.Buffer;
import znaishaded.io.vertx.core.file.AsyncFile;
import znaishaded.io.vertx.core.file.CopyOptions;
import znaishaded.io.vertx.core.file.FileProps;
import znaishaded.io.vertx.core.file.FileSystem;
import znaishaded.io.vertx.core.file.FileSystemException;
import znaishaded.io.vertx.core.file.FileSystemProps;
import znaishaded.io.vertx.core.file.OpenOptions;
import znaishaded.io.vertx.core.file.impl.AsyncFileImpl;
import znaishaded.io.vertx.core.file.impl.FilePropsImpl;
import znaishaded.io.vertx.core.file.impl.FileSystemPropsImpl;
import znaishaded.io.vertx.core.impl.Action;
import znaishaded.io.vertx.core.impl.ContextImpl;
import znaishaded.io.vertx.core.impl.VertxInternal;

public class FileSystemImpl
implements FileSystem {
    private static final CopyOptions DEFAULT_OPTIONS = new CopyOptions();
    protected final VertxInternal vertx;

    public FileSystemImpl(VertxInternal vertx) {
        this.vertx = vertx;
    }

    @Override
    public FileSystem copy(String from, String to, Handler<AsyncResult<Void>> handler) {
        return this.copy(from, to, DEFAULT_OPTIONS, handler);
    }

    @Override
    public FileSystem copy(String from, String to, CopyOptions options, Handler<AsyncResult<Void>> handler) {
        this.copyInternal(from, to, options, handler).run();
        return this;
    }

    @Override
    public FileSystem copyBlocking(String from, String to) {
        this.copyInternal(from, to, DEFAULT_OPTIONS, null).perform();
        return this;
    }

    @Override
    public FileSystem copyRecursive(String from, String to, boolean recursive, Handler<AsyncResult<Void>> handler) {
        this.copyRecursiveInternal(from, to, recursive, handler).run();
        return this;
    }

    @Override
    public FileSystem copyRecursiveBlocking(String from, String to, boolean recursive) {
        this.copyRecursiveInternal(from, to, recursive, null).perform();
        return this;
    }

    @Override
    public FileSystem move(String from, String to, Handler<AsyncResult<Void>> handler) {
        return this.move(from, to, DEFAULT_OPTIONS, handler);
    }

    @Override
    public FileSystem move(String from, String to, CopyOptions options, Handler<AsyncResult<Void>> handler) {
        this.moveInternal(from, to, options, handler).run();
        return this;
    }

    @Override
    public FileSystem moveBlocking(String from, String to) {
        this.moveInternal(from, to, DEFAULT_OPTIONS, null).perform();
        return this;
    }

    @Override
    public FileSystem truncate(String path2, long len, Handler<AsyncResult<Void>> handler) {
        this.truncateInternal(path2, len, handler).run();
        return this;
    }

    @Override
    public FileSystem truncateBlocking(String path2, long len) {
        this.truncateInternal(path2, len, null).perform();
        return this;
    }

    @Override
    public FileSystem chmod(String path2, String perms, Handler<AsyncResult<Void>> handler) {
        this.chmodInternal(path2, perms, handler).run();
        return this;
    }

    @Override
    public FileSystem chmodBlocking(String path2, String perms) {
        this.chmodInternal(path2, perms, null).perform();
        return this;
    }

    @Override
    public FileSystem chmodRecursive(String path2, String perms, String dirPerms, Handler<AsyncResult<Void>> handler) {
        this.chmodInternal(path2, perms, dirPerms, handler).run();
        return this;
    }

    @Override
    public FileSystem chmodRecursiveBlocking(String path2, String perms, String dirPerms) {
        this.chmodInternal(path2, perms, dirPerms, null).perform();
        return this;
    }

    @Override
    public FileSystem chown(String path2, String user, String group, Handler<AsyncResult<Void>> handler) {
        this.chownInternal(path2, user, group, handler).run();
        return this;
    }

    @Override
    public FileSystem chownBlocking(String path2, String user, String group) {
        this.chownInternal(path2, user, group, null).perform();
        return this;
    }

    @Override
    public FileSystem props(String path2, Handler<AsyncResult<FileProps>> handler) {
        this.propsInternal(path2, handler).run();
        return this;
    }

    @Override
    public FileProps propsBlocking(String path2) {
        return (FileProps)this.propsInternal(path2, null).perform();
    }

    @Override
    public FileSystem lprops(String path2, Handler<AsyncResult<FileProps>> handler) {
        this.lpropsInternal(path2, handler).run();
        return this;
    }

    @Override
    public FileProps lpropsBlocking(String path2) {
        return (FileProps)this.lpropsInternal(path2, null).perform();
    }

    @Override
    public FileSystem link(String link, String existing, Handler<AsyncResult<Void>> handler) {
        this.linkInternal(link, existing, handler).run();
        return this;
    }

    @Override
    public FileSystem linkBlocking(String link, String existing) {
        this.linkInternal(link, existing, null).perform();
        return this;
    }

    @Override
    public FileSystem symlink(String link, String existing, Handler<AsyncResult<Void>> handler) {
        this.symlinkInternal(link, existing, handler).run();
        return this;
    }

    @Override
    public FileSystem symlinkBlocking(String link, String existing) {
        this.symlinkInternal(link, existing, null).perform();
        return this;
    }

    @Override
    public FileSystem unlink(String link, Handler<AsyncResult<Void>> handler) {
        this.unlinkInternal(link, handler).run();
        return this;
    }

    @Override
    public FileSystem unlinkBlocking(String link) {
        this.unlinkInternal(link, null).perform();
        return this;
    }

    @Override
    public FileSystem readSymlink(String link, Handler<AsyncResult<String>> handler) {
        this.readSymlinkInternal(link, handler).run();
        return this;
    }

    @Override
    public String readSymlinkBlocking(String link) {
        return (String)this.readSymlinkInternal(link, null).perform();
    }

    @Override
    public FileSystem delete(String path2, Handler<AsyncResult<Void>> handler) {
        this.deleteInternal(path2, handler).run();
        return this;
    }

    @Override
    public FileSystem deleteBlocking(String path2) {
        this.deleteInternal(path2, null).perform();
        return this;
    }

    @Override
    public FileSystem deleteRecursive(String path2, boolean recursive, Handler<AsyncResult<Void>> handler) {
        this.deleteInternal(path2, recursive, handler).run();
        return this;
    }

    @Override
    public FileSystem deleteRecursiveBlocking(String path2, boolean recursive) {
        this.deleteInternal(path2, recursive, null).perform();
        return this;
    }

    @Override
    public FileSystem mkdir(String path2, Handler<AsyncResult<Void>> handler) {
        this.mkdirInternal(path2, handler).run();
        return this;
    }

    @Override
    public FileSystem mkdirBlocking(String path2) {
        this.mkdirInternal(path2, null).perform();
        return this;
    }

    @Override
    public FileSystem mkdirs(String path2, Handler<AsyncResult<Void>> handler) {
        this.mkdirInternal(path2, true, handler).run();
        return this;
    }

    @Override
    public FileSystem mkdirsBlocking(String path2) {
        this.mkdirInternal(path2, true, null).perform();
        return this;
    }

    @Override
    public FileSystem mkdir(String path2, String perms, Handler<AsyncResult<Void>> handler) {
        this.mkdirInternal(path2, perms, handler).run();
        return this;
    }

    @Override
    public FileSystem mkdirBlocking(String path2, String perms) {
        this.mkdirInternal(path2, perms, null).perform();
        return this;
    }

    @Override
    public FileSystem mkdirs(String path2, String perms, Handler<AsyncResult<Void>> handler) {
        this.mkdirInternal(path2, perms, true, handler).run();
        return this;
    }

    @Override
    public FileSystem mkdirsBlocking(String path2, String perms) {
        this.mkdirInternal(path2, perms, true, null).perform();
        return this;
    }

    @Override
    public FileSystem readDir(String path2, Handler<AsyncResult<List<String>>> handler) {
        this.readDirInternal(path2, handler).run();
        return this;
    }

    @Override
    public List<String> readDirBlocking(String path2) {
        return (List)this.readDirInternal(path2, null).perform();
    }

    @Override
    public FileSystem readDir(String path2, String filter, Handler<AsyncResult<List<String>>> handler) {
        this.readDirInternal(path2, filter, handler).run();
        return this;
    }

    @Override
    public List<String> readDirBlocking(String path2, String filter) {
        return (List)this.readDirInternal(path2, filter, null).perform();
    }

    @Override
    public FileSystem readFile(String path2, Handler<AsyncResult<Buffer>> handler) {
        this.readFileInternal(path2, handler).run();
        return this;
    }

    @Override
    public Buffer readFileBlocking(String path2) {
        return (Buffer)this.readFileInternal(path2, null).perform();
    }

    @Override
    public FileSystem writeFile(String path2, Buffer data, Handler<AsyncResult<Void>> handler) {
        this.writeFileInternal(path2, data, handler).run();
        return this;
    }

    @Override
    public FileSystem writeFileBlocking(String path2, Buffer data) {
        this.writeFileInternal(path2, data, null).perform();
        return this;
    }

    @Override
    public FileSystem open(String path2, OpenOptions options, Handler<AsyncResult<AsyncFile>> handler) {
        this.openInternal(path2, options, handler).run();
        return this;
    }

    @Override
    public AsyncFile openBlocking(String path2, OpenOptions options) {
        return (AsyncFile)this.openInternal(path2, options, null).perform();
    }

    @Override
    public FileSystem createFile(String path2, Handler<AsyncResult<Void>> handler) {
        this.createFileInternal(path2, handler).run();
        return this;
    }

    @Override
    public FileSystem createFileBlocking(String path2) {
        this.createFileInternal(path2, null).perform();
        return this;
    }

    @Override
    public FileSystem createFile(String path2, String perms, Handler<AsyncResult<Void>> handler) {
        this.createFileInternal(path2, perms, handler).run();
        return this;
    }

    @Override
    public FileSystem createFileBlocking(String path2, String perms) {
        this.createFileInternal(path2, perms, null).perform();
        return this;
    }

    @Override
    public FileSystem exists(String path2, Handler<AsyncResult<Boolean>> handler) {
        this.existsInternal(path2, handler).run();
        return this;
    }

    @Override
    public boolean existsBlocking(String path2) {
        return (Boolean)this.existsInternal(path2, null).perform();
    }

    @Override
    public FileSystem fsProps(String path2, Handler<AsyncResult<FileSystemProps>> handler) {
        this.fsPropsInternal(path2, handler).run();
        return this;
    }

    @Override
    public FileSystemProps fsPropsBlocking(String path2) {
        return (FileSystemProps)this.fsPropsInternal(path2, null).perform();
    }

    private BlockingAction<Void> copyInternal(final String from, final String to, CopyOptions options, Handler<AsyncResult<Void>> handler) {
        Objects.requireNonNull(from);
        Objects.requireNonNull(to);
        Objects.requireNonNull(options);
        Set<CopyOption> copyOptionSet = FileSystemImpl.toCopyOptionSet(options);
        final CopyOption[] copyOptions = copyOptionSet.toArray(new CopyOption[copyOptionSet.size()]);
        return new BlockingAction<Void>(handler){

            @Override
            public Void perform() {
                try {
                    Path source = FileSystemImpl.this.vertx.resolveFile(from).toPath();
                    Path target = FileSystemImpl.this.vertx.resolveFile(to).toPath();
                    Files.copy(source, target, copyOptions);
                }
                catch (IOException e) {
                    throw new FileSystemException(e);
                }
                return null;
            }
        };
    }

    private BlockingAction<Void> copyRecursiveInternal(final String from, final String to, final boolean recursive, Handler<AsyncResult<Void>> handler) {
        Objects.requireNonNull(from);
        Objects.requireNonNull(to);
        return new BlockingAction<Void>(handler){

            @Override
            public Void perform() {
                try {
                    final Path source = FileSystemImpl.this.vertx.resolveFile(from).toPath();
                    final Path target = FileSystemImpl.this.vertx.resolveFile(to).toPath();
                    if (recursive) {
                        Files.walkFileTree(source, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                            @Override
                            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                                block2: {
                                    Path targetDir = target.resolve(source.relativize(dir));
                                    try {
                                        Files.copy(dir, targetDir, new CopyOption[0]);
                                    }
                                    catch (FileAlreadyExistsException e) {
                                        if (Files.isDirectory(targetDir, new LinkOption[0])) break block2;
                                        throw e;
                                    }
                                }
                                return FileVisitResult.CONTINUE;
                            }

                            @Override
                            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                                Files.copy(file, target.resolve(source.relativize(file)), new CopyOption[0]);
                                return FileVisitResult.CONTINUE;
                            }
                        });
                    } else {
                        Files.copy(source, target, new CopyOption[0]);
                    }
                }
                catch (IOException e) {
                    throw new FileSystemException(e);
                }
                return null;
            }
        };
    }

    private BlockingAction<Void> moveInternal(final String from, final String to, CopyOptions options, Handler<AsyncResult<Void>> handler) {
        Objects.requireNonNull(from);
        Objects.requireNonNull(to);
        Objects.requireNonNull(options);
        Set<CopyOption> copyOptionSet = FileSystemImpl.toCopyOptionSet(options);
        final CopyOption[] copyOptions = copyOptionSet.toArray(new CopyOption[copyOptionSet.size()]);
        return new BlockingAction<Void>(handler){

            @Override
            public Void perform() {
                try {
                    Path source = FileSystemImpl.this.vertx.resolveFile(from).toPath();
                    Path target = FileSystemImpl.this.vertx.resolveFile(to).toPath();
                    Files.move(source, target, copyOptions);
                }
                catch (IOException e) {
                    throw new FileSystemException(e);
                }
                return null;
            }
        };
    }

    private BlockingAction<Void> truncateInternal(final String p, final long len, Handler<AsyncResult<Void>> handler) {
        Objects.requireNonNull(p);
        return new BlockingAction<Void>(handler){

            @Override
            public Void perform() {
                RandomAccessFile raf = null;
                try {
                    String path2 = FileSystemImpl.this.vertx.resolveFile(p).getAbsolutePath();
                    if (len < 0L) {
                        throw new FileSystemException("Cannot truncate file to size < 0");
                    }
                    if (!Files.exists(Paths.get(path2, new String[0]), new LinkOption[0])) {
                        throw new FileSystemException("Cannot truncate file " + path2 + ". Does not exist");
                    }
                    try {
                        raf = new RandomAccessFile(path2, "rw");
                        raf.setLength(len);
                    }
                    finally {
                        if (raf != null) {
                            raf.close();
                        }
                    }
                }
                catch (IOException e) {
                    throw new FileSystemException(e);
                }
                return null;
            }
        };
    }

    private BlockingAction<Void> chmodInternal(String path2, String perms, Handler<AsyncResult<Void>> handler) {
        return this.chmodInternal(path2, perms, null, handler);
    }

    protected BlockingAction<Void> chmodInternal(final String path2, String perms, String dirPerms, Handler<AsyncResult<Void>> handler) {
        Objects.requireNonNull(path2);
        final Set<PosixFilePermission> permissions = PosixFilePermissions.fromString(perms);
        final Set<PosixFilePermission> dirPermissions = dirPerms == null ? null : PosixFilePermissions.fromString(dirPerms);
        return new BlockingAction<Void>(handler){

            @Override
            public Void perform() {
                try {
                    Path target = FileSystemImpl.this.vertx.resolveFile(path2).toPath();
                    if (dirPermissions != null) {
                        Files.walkFileTree(target, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                            @Override
                            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                                Files.setPosixFilePermissions(dir, dirPermissions);
                                return FileVisitResult.CONTINUE;
                            }

                            @Override
                            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                                Files.setPosixFilePermissions(file, permissions);
                                return FileVisitResult.CONTINUE;
                            }
                        });
                    } else {
                        Files.setPosixFilePermissions(target, permissions);
                    }
                }
                catch (SecurityException e) {
                    throw new FileSystemException("Accessed denied for chmod on " + path2);
                }
                catch (IOException e) {
                    throw new FileSystemException(e);
                }
                return null;
            }
        };
    }

    protected BlockingAction<Void> chownInternal(final String path2, final String user, final String group, Handler<AsyncResult<Void>> handler) {
        Objects.requireNonNull(path2);
        return new BlockingAction<Void>(handler){

            @Override
            public Void perform() {
                try {
                    GroupPrincipal groupPrincipal;
                    Path target = FileSystemImpl.this.vertx.resolveFile(path2).toPath();
                    UserPrincipalLookupService service = target.getFileSystem().getUserPrincipalLookupService();
                    UserPrincipal userPrincipal = user == null ? null : service.lookupPrincipalByName(user);
                    GroupPrincipal groupPrincipal2 = groupPrincipal = group == null ? null : service.lookupPrincipalByGroupName(group);
                    if (groupPrincipal != null) {
                        PosixFileAttributeView view = Files.getFileAttributeView(target, PosixFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
                        if (view == null) {
                            throw new FileSystemException("Change group of file not supported");
                        }
                        view.setGroup(groupPrincipal);
                    }
                    if (userPrincipal != null) {
                        Files.setOwner(target, userPrincipal);
                    }
                }
                catch (SecurityException e) {
                    throw new FileSystemException("Accessed denied for chown on " + path2);
                }
                catch (IOException e) {
                    throw new FileSystemException(e);
                }
                return null;
            }
        };
    }

    private BlockingAction<FileProps> propsInternal(String path2, Handler<AsyncResult<FileProps>> handler) {
        return this.props(path2, true, handler);
    }

    private BlockingAction<FileProps> lpropsInternal(String path2, Handler<AsyncResult<FileProps>> handler) {
        return this.props(path2, false, handler);
    }

    private BlockingAction<FileProps> props(final String path2, final boolean followLinks, Handler<AsyncResult<FileProps>> handler) {
        Objects.requireNonNull(path2);
        return new BlockingAction<FileProps>(handler){

            @Override
            public FileProps perform() {
                try {
                    Path target = FileSystemImpl.this.vertx.resolveFile(path2).toPath();
                    BasicFileAttributes attrs = followLinks ? Files.readAttributes(target, BasicFileAttributes.class, new LinkOption[0]) : Files.readAttributes(target, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                    return new FilePropsImpl(attrs);
                }
                catch (IOException e) {
                    throw new FileSystemException(e);
                }
            }
        };
    }

    private BlockingAction<Void> linkInternal(String link, String existing, Handler<AsyncResult<Void>> handler) {
        return this.link(link, existing, false, handler);
    }

    private BlockingAction<Void> symlinkInternal(String link, String existing, Handler<AsyncResult<Void>> handler) {
        return this.link(link, existing, true, handler);
    }

    private BlockingAction<Void> link(final String link, final String existing, final boolean symbolic, Handler<AsyncResult<Void>> handler) {
        Objects.requireNonNull(link);
        Objects.requireNonNull(existing);
        return new BlockingAction<Void>(handler){

            @Override
            public Void perform() {
                try {
                    Path source = FileSystemImpl.this.vertx.resolveFile(link).toPath();
                    Path target = FileSystemImpl.this.vertx.resolveFile(existing).toPath();
                    if (symbolic) {
                        Files.createSymbolicLink(source, target, new FileAttribute[0]);
                    } else {
                        Files.createLink(source, target);
                    }
                }
                catch (IOException e) {
                    throw new FileSystemException(e);
                }
                return null;
            }
        };
    }

    private BlockingAction<Void> unlinkInternal(String link, Handler<AsyncResult<Void>> handler) {
        return this.deleteInternal(link, handler);
    }

    private BlockingAction<String> readSymlinkInternal(final String link, Handler<AsyncResult<String>> handler) {
        Objects.requireNonNull(link);
        return new BlockingAction<String>(handler){

            @Override
            public String perform() {
                try {
                    Path source = FileSystemImpl.this.vertx.resolveFile(link).toPath();
                    return Files.readSymbolicLink(source).toString();
                }
                catch (IOException e) {
                    throw new FileSystemException(e);
                }
            }
        };
    }

    private BlockingAction<Void> deleteInternal(String path2, Handler<AsyncResult<Void>> handler) {
        return this.deleteInternal(path2, false, handler);
    }

    private BlockingAction<Void> deleteInternal(final String path2, final boolean recursive, Handler<AsyncResult<Void>> handler) {
        Objects.requireNonNull(path2);
        return new BlockingAction<Void>(handler){

            @Override
            public Void perform() {
                try {
                    Path source = FileSystemImpl.this.vertx.resolveFile(path2).toPath();
                    if (recursive) {
                        Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                            @Override
                            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                                Files.delete(file);
                                return FileVisitResult.CONTINUE;
                            }

                            @Override
                            public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                                if (e == null) {
                                    Files.delete(dir);
                                    return FileVisitResult.CONTINUE;
                                }
                                throw e;
                            }
                        });
                    } else {
                        Files.delete(source);
                    }
                }
                catch (IOException e) {
                    throw new FileSystemException(e);
                }
                return null;
            }
        };
    }

    private BlockingAction<Void> mkdirInternal(String path2, Handler<AsyncResult<Void>> handler) {
        return this.mkdirInternal(path2, null, false, handler);
    }

    private BlockingAction<Void> mkdirInternal(String path2, boolean createParents, Handler<AsyncResult<Void>> handler) {
        return this.mkdirInternal(path2, null, createParents, handler);
    }

    private BlockingAction<Void> mkdirInternal(String path2, String perms, Handler<AsyncResult<Void>> handler) {
        return this.mkdirInternal(path2, perms, false, handler);
    }

    protected BlockingAction<Void> mkdirInternal(final String path2, String perms, final boolean createParents, Handler<AsyncResult<Void>> handler) {
        Objects.requireNonNull(path2);
        final FileAttribute<Set<PosixFilePermission>> attrs = perms == null ? null : PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString(perms));
        return new BlockingAction<Void>(handler){

            @Override
            public Void perform() {
                try {
                    Path source = FileSystemImpl.this.vertx.resolveFile(path2).toPath();
                    if (createParents) {
                        if (attrs != null) {
                            Files.createDirectories(source, attrs);
                        } else {
                            Files.createDirectories(source, new FileAttribute[0]);
                        }
                    } else if (attrs != null) {
                        Files.createDirectory(source, attrs);
                    } else {
                        Files.createDirectory(source, new FileAttribute[0]);
                    }
                }
                catch (IOException e) {
                    throw new FileSystemException(e);
                }
                return null;
            }
        };
    }

    private BlockingAction<List<String>> readDirInternal(String path2, Handler<AsyncResult<List<String>>> handler) {
        return this.readDirInternal(path2, null, handler);
    }

    private BlockingAction<List<String>> readDirInternal(final String p, final String filter, Handler<AsyncResult<List<String>>> handler) {
        Objects.requireNonNull(p);
        return new BlockingAction<List<String>>(handler){

            @Override
            public List<String> perform() {
                try {
                    File file = FileSystemImpl.this.vertx.resolveFile(p);
                    if (!file.exists()) {
                        throw new FileSystemException("Cannot read directory " + file + ". Does not exist");
                    }
                    if (!file.isDirectory()) {
                        throw new FileSystemException("Cannot read directory " + file + ". It's not a directory");
                    }
                    FilenameFilter fnFilter = filter != null ? new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return Pattern.matches(filter, name);
                        }
                    } : null;
                    File[] files = fnFilter == null ? file.listFiles() : file.listFiles(fnFilter);
                    ArrayList<String> ret = new ArrayList<String>(files.length);
                    for (File f : files) {
                        ret.add(f.getCanonicalPath());
                    }
                    return ret;
                }
                catch (IOException e) {
                    throw new FileSystemException(e);
                }
            }
        };
    }

    private BlockingAction<Buffer> readFileInternal(final String path2, Handler<AsyncResult<Buffer>> handler) {
        Objects.requireNonNull(path2);
        return new BlockingAction<Buffer>(handler){

            @Override
            public Buffer perform() {
                try {
                    Path target = FileSystemImpl.this.vertx.resolveFile(path2).toPath();
                    byte[] bytes = Files.readAllBytes(target);
                    Buffer buff = Buffer.buffer(bytes);
                    return buff;
                }
                catch (IOException e) {
                    throw new FileSystemException(e);
                }
            }
        };
    }

    private BlockingAction<Void> writeFileInternal(final String path2, final Buffer data, Handler<AsyncResult<Void>> handler) {
        Objects.requireNonNull(path2);
        Objects.requireNonNull(data);
        return new BlockingAction<Void>(handler){

            @Override
            public Void perform() {
                try {
                    Path target = FileSystemImpl.this.vertx.resolveFile(path2).toPath();
                    Files.write(target, data.getBytes(), new OpenOption[0]);
                    return null;
                }
                catch (IOException e) {
                    throw new FileSystemException(e);
                }
            }
        };
    }

    private BlockingAction<AsyncFile> openInternal(final String p, final OpenOptions options, Handler<AsyncResult<AsyncFile>> handler) {
        Objects.requireNonNull(p);
        Objects.requireNonNull(options);
        return new BlockingAction<AsyncFile>(handler){

            @Override
            public AsyncFile perform() {
                String path2 = FileSystemImpl.this.vertx.resolveFile(p).getAbsolutePath();
                return FileSystemImpl.this.doOpen(path2, options, this.context);
            }
        };
    }

    protected AsyncFile doOpen(String path2, OpenOptions options, ContextImpl context) {
        return new AsyncFileImpl(this.vertx, path2, options, context);
    }

    private BlockingAction<Void> createFileInternal(String path2, Handler<AsyncResult<Void>> handler) {
        return this.createFileInternal(path2, null, handler);
    }

    protected BlockingAction<Void> createFileInternal(final String p, String perms, Handler<AsyncResult<Void>> handler) {
        Objects.requireNonNull(p);
        final FileAttribute<Set<PosixFilePermission>> attrs = perms == null ? null : PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString(perms));
        return new BlockingAction<Void>(handler){

            @Override
            public Void perform() {
                try {
                    Path target = FileSystemImpl.this.vertx.resolveFile(p).toPath();
                    if (attrs != null) {
                        Files.createFile(target, attrs);
                    } else {
                        Files.createFile(target, new FileAttribute[0]);
                    }
                }
                catch (IOException e) {
                    throw new FileSystemException(e);
                }
                return null;
            }
        };
    }

    private BlockingAction<Boolean> existsInternal(final String path2, Handler<AsyncResult<Boolean>> handler) {
        Objects.requireNonNull(path2);
        return new BlockingAction<Boolean>(handler){
            File file;
            {
                super(handler);
                this.file = FileSystemImpl.this.vertx.resolveFile(path2);
            }

            @Override
            public Boolean perform() {
                return this.file.exists();
            }
        };
    }

    private BlockingAction<FileSystemProps> fsPropsInternal(final String path2, Handler<AsyncResult<FileSystemProps>> handler) {
        Objects.requireNonNull(path2);
        return new BlockingAction<FileSystemProps>(handler){

            @Override
            public FileSystemProps perform() {
                try {
                    Path target = FileSystemImpl.this.vertx.resolveFile(path2).toPath();
                    FileStore fs = Files.getFileStore(target);
                    return new FileSystemPropsImpl(fs.getTotalSpace(), fs.getUnallocatedSpace(), fs.getUsableSpace());
                }
                catch (IOException e) {
                    throw new FileSystemException(e);
                }
            }
        };
    }

    static Set<CopyOption> toCopyOptionSet(CopyOptions copyOptions) {
        HashSet<CopyOption> copyOptionSet = new HashSet<CopyOption>();
        if (copyOptions.isReplaceExisting()) {
            copyOptionSet.add(StandardCopyOption.REPLACE_EXISTING);
        }
        if (copyOptions.isCopyAttributes()) {
            copyOptionSet.add(StandardCopyOption.COPY_ATTRIBUTES);
        }
        if (copyOptions.isAtomicMove()) {
            copyOptionSet.add(StandardCopyOption.ATOMIC_MOVE);
        }
        if (copyOptions.isNofollowLinks()) {
            copyOptionSet.add(LinkOption.NOFOLLOW_LINKS);
        }
        return copyOptionSet;
    }

    protected abstract class BlockingAction<T>
    implements Action<T> {
        private final Handler<AsyncResult<T>> handler;
        protected final ContextImpl context;

        public BlockingAction(Handler<AsyncResult<T>> handler) {
            this.handler = handler;
            this.context = FileSystemImpl.this.vertx.getOrCreateContext();
        }

        public void run() {
            this.context.executeBlocking(this, this.handler);
        }
    }
}

