/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.shareddata.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import znaishaded.io.vertx.core.AsyncResult;
import znaishaded.io.vertx.core.Context;
import znaishaded.io.vertx.core.Future;
import znaishaded.io.vertx.core.Handler;
import znaishaded.io.vertx.core.shareddata.Lock;

public class LocalAsyncLocks {
    private final ConcurrentMap<String, List<LockWaiter>> waitersMap = new ConcurrentHashMap<String, List<LockWaiter>>();

    public void acquire(Context context, String name, long timeout, Handler<AsyncResult<Lock>> handler) {
        LockWaiter lockWaiter = new LockWaiter(context, name, timeout, handler);
        List waiters = this.waitersMap.compute(name, (s2, list) -> {
            ArrayList<LockWaiter> result;
            if (list != null) {
                result = new ArrayList(list.size() + 1);
                result.addAll((Collection<LockWaiter>)list);
            } else {
                result = new ArrayList<LockWaiter>(1);
            }
            result.add(lockWaiter);
            return result;
        });
        if (waiters.size() == 1) {
            ((LockWaiter)waiters.get(0)).acquireLock();
        }
    }

    private void nextWaiter(String lockName) {
        List waiters = this.waitersMap.compute(lockName, (s2, list) -> list == null || list.size() == 1 ? null : new ArrayList(list.subList(1, list.size())));
        if (waiters != null) {
            ((LockWaiter)waiters.get(0)).acquireLock();
        }
    }

    private class AsyncLock
    implements Lock {
        final String lockName;
        final AtomicBoolean invoked = new AtomicBoolean();

        AsyncLock(String lockName) {
            this.lockName = lockName;
        }

        @Override
        public void release() {
            if (this.invoked.compareAndSet(false, true)) {
                LocalAsyncLocks.this.nextWaiter(this.lockName);
            }
        }
    }

    private class LockWaiter {
        final Context context;
        final String lockName;
        final Handler<AsyncResult<Lock>> handler;
        final AtomicReference<Status> status;
        final Long timerId;

        LockWaiter(Context context, String lockName, long timeout, Handler<AsyncResult<Lock>> handler) {
            this.context = context;
            this.lockName = lockName;
            this.handler = handler;
            this.status = new AtomicReference<Status>(Status.WAITING);
            this.timerId = timeout != Long.MAX_VALUE ? Long.valueOf(context.owner().setTimer(timeout, tid -> this.timeout())) : null;
        }

        boolean isWaiting() {
            return this.status.get() == Status.WAITING;
        }

        void timeout() {
            if (this.status.compareAndSet(Status.WAITING, Status.TIMED_OUT)) {
                this.handler.handle(Future.failedFuture("Timed out waiting to get lock"));
            }
        }

        void acquireLock() {
            if (this.status.compareAndSet(Status.WAITING, Status.ACQUIRED)) {
                if (this.timerId != null) {
                    this.context.owner().cancelTimer(this.timerId);
                }
                this.context.runOnContext(v -> this.handler.handle(Future.succeededFuture(new AsyncLock(this.lockName))));
            } else {
                this.context.runOnContext(v -> LocalAsyncLocks.this.nextWaiter(this.lockName));
            }
        }
    }

    private static enum Status {
        WAITING,
        ACQUIRED,
        TIMED_OUT;

    }
}

