/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.ext.web.impl;

import java.net.MalformedURLException;
import java.net.URL;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.cert.X509Certificate;
import znaishaded.io.vertx.core.Handler;
import znaishaded.io.vertx.core.MultiMap;
import znaishaded.io.vertx.core.buffer.Buffer;
import znaishaded.io.vertx.core.http.HttpConnection;
import znaishaded.io.vertx.core.http.HttpFrame;
import znaishaded.io.vertx.core.http.HttpMethod;
import znaishaded.io.vertx.core.http.HttpServerFileUpload;
import znaishaded.io.vertx.core.http.HttpServerRequest;
import znaishaded.io.vertx.core.http.HttpServerResponse;
import znaishaded.io.vertx.core.http.HttpVersion;
import znaishaded.io.vertx.core.http.ServerWebSocket;
import znaishaded.io.vertx.core.net.NetSocket;
import znaishaded.io.vertx.core.net.SocketAddress;

class HttpServerRequestWrapper
implements HttpServerRequest {
    private final HttpServerRequest delegate;
    private HttpMethod method;
    private String path;
    private String uri;
    private String absoluteURI;

    HttpServerRequestWrapper(HttpServerRequest request) {
        this.delegate = request;
        this.method = request.method();
        this.path = request.path();
        this.uri = request.uri();
        this.absoluteURI = null;
    }

    @Override
    public HttpServerRequest exceptionHandler(Handler<Throwable> handler) {
        return this.delegate.exceptionHandler((Handler)handler);
    }

    @Override
    public HttpServerRequest handler(Handler<Buffer> handler) {
        return this.delegate.handler((Handler)handler);
    }

    @Override
    public HttpServerRequest pause() {
        return this.delegate.pause();
    }

    @Override
    public HttpServerRequest resume() {
        return this.delegate.resume();
    }

    @Override
    public HttpServerRequest endHandler(Handler<Void> handler) {
        return this.delegate.endHandler((Handler)handler);
    }

    @Override
    public HttpVersion version() {
        return this.delegate.version();
    }

    HttpServerRequest setMethod(HttpMethod method) {
        this.method = method;
        return this;
    }

    @Override
    public HttpMethod method() {
        return this.method;
    }

    @Override
    public String rawMethod() {
        return this.delegate.rawMethod();
    }

    @Override
    public String uri() {
        return this.uri;
    }

    void setPath(String path2) {
        this.path = path2;
        this.uri = path2;
        this.absoluteURI = null;
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public String query() {
        return this.delegate.query();
    }

    @Override
    public HttpServerResponse response() {
        return this.delegate.response();
    }

    @Override
    public MultiMap headers() {
        return this.delegate.headers();
    }

    @Override
    public String getHeader(String s2) {
        return this.delegate.getHeader(s2);
    }

    @Override
    public String getHeader(CharSequence charSequence) {
        return this.delegate.getHeader(charSequence);
    }

    @Override
    public MultiMap params() {
        return this.delegate.params();
    }

    @Override
    public String getParam(String s2) {
        return this.delegate.getParam(s2);
    }

    @Override
    public SocketAddress remoteAddress() {
        return this.delegate.remoteAddress();
    }

    @Override
    public SocketAddress localAddress() {
        return this.delegate.localAddress();
    }

    @Override
    public X509Certificate[] peerCertificateChain() throws SSLPeerUnverifiedException {
        return this.delegate.peerCertificateChain();
    }

    @Override
    public SSLSession sslSession() {
        return this.delegate.sslSession();
    }

    @Override
    public String absoluteURI() {
        if (this.absoluteURI == null) {
            try {
                URL url = new URL(this.delegate.absoluteURI());
                URL newUrl = new URL(url.getProtocol(), url.getHost(), url.getPort(), this.uri);
                this.absoluteURI = newUrl.toExternalForm();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return this.absoluteURI;
    }

    @Override
    public String scheme() {
        return this.delegate.scheme();
    }

    @Override
    public String host() {
        return this.delegate.host();
    }

    @Override
    public HttpServerRequest customFrameHandler(Handler<HttpFrame> handler) {
        this.delegate.customFrameHandler(handler);
        return this;
    }

    @Override
    public HttpConnection connection() {
        return this.delegate.connection();
    }

    @Override
    public HttpServerRequest bodyHandler(Handler<Buffer> handler) {
        return this.delegate.bodyHandler(handler);
    }

    @Override
    public NetSocket netSocket() {
        return this.delegate.netSocket();
    }

    @Override
    public HttpServerRequest setExpectMultipart(boolean b) {
        return this.delegate.setExpectMultipart(b);
    }

    @Override
    public boolean isExpectMultipart() {
        return this.delegate.isExpectMultipart();
    }

    @Override
    public HttpServerRequest uploadHandler(Handler<HttpServerFileUpload> handler) {
        return this.delegate.uploadHandler(handler);
    }

    @Override
    public MultiMap formAttributes() {
        return this.delegate.formAttributes();
    }

    @Override
    public String getFormAttribute(String s2) {
        return this.delegate.getFormAttribute(s2);
    }

    @Override
    public ServerWebSocket upgrade() {
        return this.delegate.upgrade();
    }

    @Override
    public boolean isEnded() {
        return this.delegate.isEnded();
    }

    @Override
    public boolean isSSL() {
        return this.delegate.isSSL();
    }
}

