/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.ext.web.templ.impl;

import java.util.Objects;
import znaishaded.io.vertx.ext.web.impl.ConcurrentLRUCache;
import znaishaded.io.vertx.ext.web.templ.TemplateEngine;

public abstract class CachingTemplateEngine<T>
implements TemplateEngine {
    public static final String DISABLE_TEMPL_CACHING_PROP_NAME = "znaishaded.io.vertx.ext.web.TemplateEngine.disableCache";
    private final boolean enableCache = !Boolean.getBoolean("znaishaded.io.vertx.ext.web.TemplateEngine.disableCache");
    protected final ConcurrentLRUCache<String, T> cache;
    protected String extension;

    protected CachingTemplateEngine(String ext, int maxCacheSize) {
        Objects.requireNonNull(ext);
        if (maxCacheSize < 1) {
            throw new IllegalArgumentException("maxCacheSize must be >= 1");
        }
        this.doSetExtension(ext);
        this.cache = new ConcurrentLRUCache(maxCacheSize);
    }

    @Override
    public boolean isCachingEnabled() {
        return this.enableCache;
    }

    protected String adjustLocation(String location) {
        if (!location.endsWith(this.extension)) {
            location = location + this.extension;
        }
        return location;
    }

    protected void doSetExtension(String ext) {
        this.extension = ext.charAt(0) == '.' ? ext : "." + ext;
    }
}

