/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml;

import java.util.concurrent.atomic.AtomicInteger;

public class ProgressBar {
    private static boolean enable;
    private static String last;
    private static final AtomicInteger total;
    private static final AtomicInteger done;

    private static synchronized void print(String string) {
        ProgressBar.clear();
        System.err.print(string);
        last = string;
    }

    public static synchronized void clear() {
        if (last != null) {
            int n;
            for (n = 0; n < last.length(); ++n) {
                System.err.print('\b');
            }
            for (n = 0; n < last.length(); ++n) {
                System.err.print(' ');
            }
            for (n = 0; n < last.length(); ++n) {
                System.err.print('\b');
            }
        }
        last = null;
    }

    public static void incTotal(int n) {
        total.addAndGet(n);
        ProgressBar.printBar(done.intValue(), total.intValue());
    }

    private static synchronized void printBar(int n, int n2) {
        if (!enable) {
            return;
        }
        if (n2 == 0) {
            return;
        }
        String string = "[" + ProgressBar.getBar(n, n2) + "] " + n + "/" + n2;
        ProgressBar.print(string);
    }

    private static String getBar(int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 30 * n / n2;
        for (int i = 0; i < 30; ++i) {
            stringBuilder.append(i < n3 ? (char)'#' : ' ');
        }
        return stringBuilder.toString();
    }

    public static void incDone(boolean bl) {
        done.incrementAndGet();
        ProgressBar.printBar(done.intValue(), total.intValue());
    }

    public static void setEnable(boolean bl) {
        enable = bl;
    }

    static {
        last = null;
        total = new AtomicInteger();
        done = new AtomicInteger();
    }
}

