/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.activitydiagram3;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ForkStyle;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.Instruction;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.InstructionList;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.WithNote;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileWithNoteOpale;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.color.Colors;
import znaishaded.net.sourceforge.plantuml.sequencediagram.NotePosition;
import znaishaded.net.sourceforge.plantuml.sequencediagram.NoteType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstructionFork
extends WithNote
implements Instruction {
    private final List<InstructionList> forks = new ArrayList<InstructionList>();
    private final Instruction parent;
    private final LinkRendering inlinkRendering;
    private final ISkinParam skinParam;
    private ForkStyle style = ForkStyle.FORK;
    private String label;
    boolean finished = false;

    public InstructionFork(Instruction instruction, LinkRendering linkRendering, ISkinParam iSkinParam) {
        this.parent = instruction;
        this.inlinkRendering = linkRendering;
        this.skinParam = iSkinParam;
        this.forks.add(new InstructionList());
        if (linkRendering == null) {
            throw new IllegalArgumentException();
        }
    }

    private InstructionList getLastList() {
        return this.forks.get(this.forks.size() - 1);
    }

    @Override
    public void add(Instruction instruction) {
        this.getLastList().add(instruction);
    }

    @Override
    public Ftile createFtile(FtileFactory ftileFactory) {
        ArrayList<Ftile> arrayList = new ArrayList<Ftile>();
        for (InstructionList instructionList : this.forks) {
            arrayList.add(instructionList.createFtile(ftileFactory));
        }
        Object object = ftileFactory.createParallel(this.getSwimlaneIn(), arrayList, this.style, this.label);
        if (this.getPositionedNotes().size() > 0) {
            object = FtileWithNoteOpale.create((Ftile)object, this.getPositionedNotes(), this.skinParam, false);
        }
        return object;
    }

    public Instruction getParent() {
        return this.parent;
    }

    public void forkAgain() {
        this.forks.add(new InstructionList());
    }

    @Override
    public final boolean kill() {
        return this.getLastList().kill();
    }

    @Override
    public LinkRendering getInLinkRendering() {
        return this.inlinkRendering;
    }

    @Override
    public boolean addNote(Display display, NotePosition notePosition, NoteType noteType, Colors colors, Swimlane swimlane) {
        if (this.finished) {
            return super.addNote(display, notePosition, noteType, colors, swimlane);
        }
        if (this.getLastList().getLast() == null) {
            return this.getLastList().addNote(display, notePosition, noteType, colors, swimlane);
        }
        return this.getLastList().addNote(display, notePosition, noteType, colors, swimlane);
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return InstructionList.getSwimlanes2(this.forks);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.forks.get(0).getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.forks.get(0).getSwimlaneOut();
    }

    public void manageOutRendering(LinkRendering linkRendering, boolean bl) {
        if (bl) {
            this.finished = true;
        }
        if (linkRendering == null) {
            return;
        }
        this.getLastList().setOutRendering(linkRendering);
    }

    public void setStyle(ForkStyle forkStyle, String string) {
        this.style = forkStyle;
        this.label = string;
    }
}

