/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.anim;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.anim.AffineTransformation;
import znaishaded.net.sourceforge.plantuml.ugraphic.MinMax;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Animation {
    private final List<AffineTransformation> all;

    private Animation(List<AffineTransformation> list) {
        if (list.size() == 0) {
            throw new IllegalArgumentException();
        }
        this.all = list;
    }

    public static Animation singleton(AffineTransformation affineTransformation) {
        if (affineTransformation == null) {
            return null;
        }
        return new Animation(Collections.singletonList(affineTransformation));
    }

    public static Animation create(List<String> list) {
        ArrayList<AffineTransformation> arrayList = new ArrayList<AffineTransformation>();
        for (String string : list) {
            AffineTransformation affineTransformation = AffineTransformation.create(string);
            if (affineTransformation == null) continue;
            arrayList.add(affineTransformation);
        }
        return new Animation(arrayList);
    }

    public Collection<AffineTransformation> getAll() {
        return Collections.unmodifiableCollection(this.all);
    }

    public void setDimension(Dimension2D dimension2D) {
        for (AffineTransformation affineTransformation : this.all) {
            affineTransformation.setDimension(dimension2D);
        }
    }

    public AffineTransformation getFirst() {
        return this.all.get(0);
    }

    public MinMax getMinMax(Dimension2D dimension2D) {
        MinMax minMax = MinMax.getEmpty(false);
        for (AffineTransformation affineTransformation : this.all) {
            MinMax minMax2 = affineTransformation.getMinMax(dimension2D);
            minMax = minMax.addMinMax(minMax2);
        }
        return minMax;
    }
}

