/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.command;

import znaishaded.net.sourceforge.plantuml.PSystemError;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.command.BlocLines;
import znaishaded.net.sourceforge.plantuml.command.Command;
import znaishaded.net.sourceforge.plantuml.command.CommandControl;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.core.Diagram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SingleLineCommand2<S extends Diagram>
implements Command<S> {
    private final RegexConcat pattern;

    public SingleLineCommand2(RegexConcat regexConcat) {
        if (regexConcat == null) {
            throw new IllegalArgumentException();
        }
        if (!regexConcat.getPattern().startsWith("^") || !regexConcat.getPattern().endsWith("$")) {
            throw new IllegalArgumentException("Bad pattern " + regexConcat.getPattern());
        }
        this.pattern = regexConcat;
    }

    @Override
    public String[] getDescription() {
        return new String[]{this.pattern.getPattern()};
    }

    @Override
    public final CommandControl isValid(BlocLines blocLines) {
        if (blocLines.size() != 1) {
            return CommandControl.NOT_OK;
        }
        blocLines = blocLines.removeInnerComments();
        if (this.isCommandForbidden()) {
            return CommandControl.NOT_OK;
        }
        String string = StringUtils.trin(blocLines.getFirst499());
        boolean bl = this.pattern.match(string);
        if (bl) {
            this.actionIfCommandValid();
        }
        return bl ? CommandControl.OK : CommandControl.NOT_OK;
    }

    protected boolean isCommandForbidden() {
        return false;
    }

    protected void actionIfCommandValid() {
    }

    @Override
    public final CommandExecutionResult execute(S s2, BlocLines blocLines) {
        if (blocLines.size() != 1) {
            throw new IllegalArgumentException();
        }
        String string = StringUtils.trin((blocLines = blocLines.removeInnerComments()).getFirst499());
        if (this.isForbidden(string)) {
            return CommandExecutionResult.error("Syntax error: " + string);
        }
        RegexResult regexResult = this.pattern.matcher(string);
        if (regexResult == null) {
            return CommandExecutionResult.error("Cannot parse line " + string);
        }
        if (s2 instanceof PSystemError) {
            return CommandExecutionResult.error("PSystemError cannot be cast");
        }
        return this.executeArg(s2, regexResult);
    }

    protected boolean isForbidden(CharSequence charSequence) {
        return false;
    }

    protected abstract CommandExecutionResult executeArg(S var1, RegexResult var2);
}

