/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.cucadiagram.dot;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import znaishaded.net.sourceforge.plantuml.cucadiagram.GroupRoot;
import znaishaded.net.sourceforge.plantuml.cucadiagram.GroupType;
import znaishaded.net.sourceforge.plantuml.cucadiagram.IGroup;
import znaishaded.net.sourceforge.plantuml.cucadiagram.LeafType;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.svek.GroupPngMakerState;
import znaishaded.net.sourceforge.plantuml.svek.IEntityImage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CucaDiagramSimplifierState {
    private final CucaDiagram diagram;
    private final StringBounder stringBounder;

    public CucaDiagramSimplifierState(CucaDiagram cucaDiagram, List<String> list, StringBounder stringBounder) throws IOException, InterruptedException {
        boolean bl;
        this.diagram = cucaDiagram;
        this.stringBounder = stringBounder;
        do {
            bl = false;
            Collection<IGroup> collection = this.getOrdered(cucaDiagram.getRootGroup());
            for (IGroup iGroup : collection) {
                if (!cucaDiagram.isAutarkic(iGroup)) continue;
                IEntityImage iEntityImage = this.computeImage(iGroup);
                iGroup.overrideImage(iEntityImage, iGroup.getGroupType() == GroupType.CONCURRENT_STATE ? LeafType.STATE_CONCURRENT : LeafType.STATE);
                bl = true;
            }
        } while (bl);
    }

    private Collection<IGroup> getOrdered(IGroup iGroup) {
        LinkedHashSet<IGroup> linkedHashSet = new LinkedHashSet<IGroup>();
        linkedHashSet.add(iGroup);
        int n = 1;
        do {
            n = linkedHashSet.size();
            this.addOneLevel(linkedHashSet);
        } while (n != linkedHashSet.size());
        ArrayList<IGroup> arrayList = new ArrayList<IGroup>();
        for (IGroup iGroup2 : linkedHashSet) {
            if (iGroup2 instanceof GroupRoot) continue;
            arrayList.add(0, iGroup2);
        }
        return arrayList;
    }

    private void addOneLevel(Collection<IGroup> collection) {
        for (IGroup iGroup : new ArrayList<IGroup>(collection)) {
            for (IGroup iGroup2 : this.reverse(iGroup.getChildren())) {
                collection.add(iGroup2);
            }
        }
    }

    private List<IGroup> reverse(Collection<IGroup> collection) {
        ArrayList<IGroup> arrayList = new ArrayList<IGroup>();
        for (IGroup iGroup : collection) {
            arrayList.add(0, iGroup);
        }
        return arrayList;
    }

    private IEntityImage computeImage(IGroup iGroup) throws IOException, InterruptedException {
        GroupPngMakerState groupPngMakerState = new GroupPngMakerState(this.diagram, iGroup, this.stringBounder);
        return groupPngMakerState.getImage();
    }
}

