/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.geom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeSet;
import znaishaded.net.sourceforge.plantuml.geom.InflateData;
import znaishaded.net.sourceforge.plantuml.geom.LineSegmentInt;
import znaishaded.net.sourceforge.plantuml.geom.Point2DInt;
import znaishaded.net.sourceforge.plantuml.geom.Point2DIntComparatorDistance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InflationTransform {
    private final List<InflateData> inflateX = new ArrayList<InflateData>();
    private final List<InflateData> inflateY = new ArrayList<InflateData>();

    public void addInflationX(int n, int n2) {
        InflationTransform.add(this.inflateX, n, n2);
    }

    public String toString() {
        return "inflateX = " + this.inflateX + " inflateY = " + this.inflateY;
    }

    public void addInflationY(int n, int n2) {
        InflationTransform.add(this.inflateY, n, n2);
    }

    private static void add(List<InflateData> list, int n, int n2) {
        ListIterator<InflateData> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            InflateData inflateData = listIterator.next();
            if (inflateData.getPos() != n) continue;
            listIterator.set(new InflateData(n, Math.max(n2, inflateData.getInflation())));
            return;
        }
        list.add(new InflateData(n, n2));
        Collections.sort(list);
    }

    Collection<Point2DInt> cutPoints(LineSegmentInt lineSegmentInt) {
        Point2DInt point2DInt;
        LineSegmentInt lineSegmentInt2;
        TreeSet<Point2DInt> treeSet = new TreeSet<Point2DInt>(new Point2DIntComparatorDistance(lineSegmentInt.getP1()));
        if (!lineSegmentInt.isHorizontal()) {
            for (InflateData inflateData : this.inflateX) {
                lineSegmentInt2 = new LineSegmentInt(inflateData.getPos(), lineSegmentInt.getMinY(), inflateData.getPos(), lineSegmentInt.getMaxY());
                point2DInt = lineSegmentInt.getSegIntersection(lineSegmentInt2);
                if (point2DInt == null) continue;
                treeSet.add(point2DInt);
            }
        }
        if (!lineSegmentInt.isVertical()) {
            for (InflateData inflateData : this.inflateY) {
                lineSegmentInt2 = new LineSegmentInt(lineSegmentInt.getMinX(), inflateData.getPos(), lineSegmentInt.getMaxX(), inflateData.getPos());
                point2DInt = lineSegmentInt.getSegIntersection(lineSegmentInt2);
                if (point2DInt == null) continue;
                treeSet.add(point2DInt);
            }
        }
        return treeSet;
    }

    Collection<LineSegmentInt> cutSegments(LineSegmentInt lineSegmentInt) {
        ArrayList<LineSegmentInt> arrayList = new ArrayList<LineSegmentInt>();
        Point2DInt point2DInt = lineSegmentInt.getP1();
        Collection<Point2DInt> collection = this.cutPoints(lineSegmentInt);
        for (Point2DInt point2DInt2 : collection) {
            if (point2DInt.equals(point2DInt2)) continue;
            arrayList.add(new LineSegmentInt(point2DInt, point2DInt2));
            point2DInt = point2DInt2;
        }
        if (!point2DInt.equals(lineSegmentInt.getP2())) {
            arrayList.add(new LineSegmentInt(point2DInt, lineSegmentInt.getP2()));
        }
        return arrayList;
    }

    Collection<LineSegmentInt> cutSegments(Collection<LineSegmentInt> collection) {
        ArrayList<LineSegmentInt> arrayList = new ArrayList<LineSegmentInt>();
        for (LineSegmentInt lineSegmentInt : collection) {
            arrayList.addAll(this.cutSegments(lineSegmentInt));
        }
        return arrayList;
    }

    private LineSegmentInt inflateSegment(LineSegmentInt lineSegmentInt) {
        if (this.isOnGrid(lineSegmentInt.getP1()) || this.isOnGrid(lineSegmentInt.getP2())) {
            return new LineSegmentInt(this.inflatePoint2DInt(lineSegmentInt.getP1()), this.inflatePoint2DInt(lineSegmentInt.getP2()));
        }
        for (InflateData inflateData : this.inflateX) {
            lineSegmentInt = lineSegmentInt.inflateXAlpha(inflateData);
        }
        for (InflateData inflateData : this.inflateY) {
            lineSegmentInt = lineSegmentInt.inflateYAlpha(inflateData);
        }
        return lineSegmentInt;
    }

    private boolean isOnGrid(Point2DInt point2DInt) {
        boolean bl = false;
        for (InflateData inflateData : this.inflateX) {
            if (point2DInt.getX() != (double)inflateData.getPos()) continue;
            bl = true;
        }
        if (!bl) {
            return false;
        }
        for (InflateData inflateData : this.inflateY) {
            if (point2DInt.getY() != (double)inflateData.getPos()) continue;
            return true;
        }
        return false;
    }

    public Point2DInt inflatePoint2DInt(Point2DInt point2DInt) {
        for (InflateData inflateData : this.inflateX) {
            point2DInt = point2DInt.inflateX(inflateData);
        }
        for (InflateData inflateData : this.inflateY) {
            point2DInt = point2DInt.inflateY(inflateData);
        }
        return point2DInt;
    }

    List<LineSegmentInt> inflateSegmentCollection(Collection<LineSegmentInt> collection) {
        ArrayList<LineSegmentInt> arrayList = new ArrayList<LineSegmentInt>();
        for (LineSegmentInt lineSegmentInt : collection) {
            arrayList.add(this.inflateSegment(lineSegmentInt));
        }
        return arrayList;
    }

    public List<LineSegmentInt> inflate(Collection<LineSegmentInt> collection) {
        ArrayList<LineSegmentInt> arrayList = new ArrayList<LineSegmentInt>();
        LineSegmentInt lineSegmentInt = null;
        Collection<LineSegmentInt> collection2 = this.cutSegments(collection);
        for (LineSegmentInt lineSegmentInt2 : this.inflateSegmentCollection(collection2)) {
            if (lineSegmentInt != null && !lineSegmentInt.getP2().equals(lineSegmentInt2.getP1())) {
                arrayList.add(new LineSegmentInt(lineSegmentInt.getP2(), lineSegmentInt2.getP1()));
            }
            arrayList.add(lineSegmentInt2);
            lineSegmentInt = lineSegmentInt2;
        }
        return arrayList;
    }
}

