/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.graphic.color;

import java.util.EnumMap;
import java.util.Map;
import java.util.StringTokenizer;
import znaishaded.net.sourceforge.plantuml.ColorParam;
import znaishaded.net.sourceforge.plantuml.FontParam;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.SkinParamColors;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.cucadiagram.LinkStyle;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Stereotype;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColor;
import znaishaded.net.sourceforge.plantuml.graphic.IHtmlColorSet;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorType;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;

public class Colors {
    private final Map<ColorType, HtmlColor> map = new EnumMap<ColorType, HtmlColor>(ColorType.class);
    private LinkStyle lineStyle = null;
    private Boolean shadowing = null;

    public String toString() {
        return this.map.toString() + " " + (Object)((Object)this.lineStyle);
    }

    public static Colors empty() {
        return new Colors();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    private Colors copy() {
        Colors colors = new Colors();
        colors.map.putAll(this.map);
        colors.lineStyle = this.lineStyle;
        return colors;
    }

    private Colors() {
    }

    public Colors(String string, IHtmlColorSet iHtmlColorSet, ColorType colorType) {
        string = StringUtils.goLowerCase(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "#;");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(58);
            if (n == -1) {
                if (string2.contains(".")) continue;
                this.map.put(colorType, iHtmlColorSet.getColorIfValid(string2));
                continue;
            }
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            if (string3.equalsIgnoreCase("shadowing")) {
                this.shadowing = string4.equalsIgnoreCase("true");
                continue;
            }
            ColorType colorType2 = ColorType.getType(string3);
            HtmlColor htmlColor = iHtmlColorSet.getColorIfValid(string4);
            this.map.put(colorType2, htmlColor);
        }
        if (string.contains("line.dashed")) {
            this.lineStyle = LinkStyle.DASHED;
        } else if (string.contains("line.dotted")) {
            this.lineStyle = LinkStyle.DOTTED;
        } else if (string.contains("line.bold")) {
            this.lineStyle = LinkStyle.BOLD;
        }
    }

    public HtmlColor getColor(ColorType colorType) {
        if (colorType == null) {
            throw new IllegalArgumentException();
        }
        return this.map.get((Object)colorType);
    }

    public HtmlColor getColor(ColorType colorType, ColorType colorType2) {
        HtmlColor htmlColor = this.getColor(colorType);
        if (htmlColor != null) {
            return htmlColor;
        }
        return this.getColor(colorType2);
    }

    public UStroke getSpecificLineStroke() {
        if (this.lineStyle == null) {
            return null;
        }
        return LinkStyle.getStroke(this.lineStyle);
    }

    public Colors add(ColorType colorType, HtmlColor htmlColor) {
        if (htmlColor == null) {
            return this;
        }
        Colors colors = this.copy();
        colors.map.put(colorType, htmlColor);
        return colors;
    }

    private Colors add(ColorType colorType, Colors colors) {
        Colors colors2 = this.copy();
        colors2.map.putAll(colors.map);
        if (colors.lineStyle != null) {
            colors2.lineStyle = colors.lineStyle;
        }
        return colors2;
    }

    public final LinkStyle getLineStyle() {
        return this.lineStyle;
    }

    public ISkinParam mute(ISkinParam iSkinParam) {
        return new SkinParamColors(iSkinParam, this);
    }

    public Colors addLegacyStroke(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        Colors colors = this.copy();
        colors.lineStyle = LinkStyle.valueOf(StringUtils.goUpperCase(string));
        return colors;
    }

    public static UGraphic applyStroke(UGraphic uGraphic, Colors colors) {
        if (colors == null) {
            return uGraphic;
        }
        if (colors.lineStyle == null) {
            return uGraphic;
        }
        return uGraphic.apply(LinkStyle.getStroke(colors.lineStyle));
    }

    public Colors applyStereotype(Stereotype stereotype, ISkinParam iSkinParam, ColorParam colorParam) {
        if (stereotype == null) {
            throw new IllegalArgumentException();
        }
        if (colorParam == null) {
            throw new IllegalArgumentException();
        }
        ColorType colorType = colorParam.getColorType();
        if (colorType == null) {
            throw new IllegalArgumentException();
        }
        if (this.getColor(colorType) != null) {
            return this;
        }
        Colors colors = iSkinParam.getColors(colorParam, stereotype);
        return this.add(colorType, colors);
    }

    private Colors applyFontParamStereotype(Stereotype stereotype, ISkinParam iSkinParam, FontParam fontParam) {
        if (stereotype == null) {
            throw new IllegalArgumentException();
        }
        if (fontParam == null) {
            return this;
        }
        ColorType colorType = ColorType.TEXT;
        if (this.getColor(colorType) != null) {
            return this;
        }
        HtmlColor htmlColor = iSkinParam.getFontHtmlColor(stereotype, fontParam);
        return this.add(colorType, htmlColor);
    }

    public Colors applyStereotypeForNote(Stereotype stereotype, ISkinParam iSkinParam, FontParam fontParam, ColorParam ... colorParamArray) {
        if (stereotype == null) {
            throw new IllegalArgumentException();
        }
        if (colorParamArray == null) {
            throw new IllegalArgumentException();
        }
        Colors colors = this;
        for (ColorParam colorParam : colorParamArray) {
            colors = colors.applyStereotype(stereotype, iSkinParam, colorParam);
        }
        colors = colors.applyFontParamStereotype(stereotype, iSkinParam, fontParam);
        colors.shadowing = iSkinParam.shadowingForNote(stereotype);
        return colors;
    }

    public Boolean getShadowing() {
        return this.shadowing;
    }
}

