/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.salt.element;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.ISkinSimple;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColorSet;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.salt.element.AbstractElement;
import znaishaded.net.sourceforge.plantuml.salt.element.ElementText;
import znaishaded.net.sourceforge.plantuml.salt.element.ElementTreeEntry;
import znaishaded.net.sourceforge.plantuml.salt.element.Grid2;
import znaishaded.net.sourceforge.plantuml.salt.element.ListWidth;
import znaishaded.net.sourceforge.plantuml.salt.element.Skeleton;
import znaishaded.net.sourceforge.plantuml.salt.element.TableStrategy;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChangeColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UFont;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;

public class ElementTree
extends AbstractElement {
    private final List<ElementTreeEntry> entries = new ArrayList<ElementTreeEntry>();
    private final UFont font;
    private final ISkinSimple spriteContainer;
    private final double margin = 10.0;
    private final TableStrategy strategy;

    public ElementTree(UFont uFont, ISkinSimple iSkinSimple, TableStrategy tableStrategy) {
        this.font = uFont;
        this.spriteContainer = iSkinSimple;
        this.strategy = tableStrategy;
    }

    public void addEntry(String string) {
        int n = 0;
        while (string.startsWith("+")) {
            ++n;
            string = string.substring(1);
        }
        ElementText elementText = new ElementText(Arrays.asList(StringUtils.trin(string)), this.font, this.spriteContainer);
        this.entries.add(new ElementTreeEntry(n, elementText));
    }

    public void addCellToEntry(String string) {
        int n = this.entries.size();
        if (n > 0) {
            ElementText elementText = new ElementText(Arrays.asList(StringUtils.trin(string)), this.font, this.spriteContainer);
            this.entries.get(n - 1).addCell(elementText);
        }
    }

    public Dimension2D getPreferredDimension(StringBounder stringBounder, double d, double d2) {
        double d3 = 0.0;
        double d4 = 0.0;
        for (ElementTreeEntry elementTreeEntry : this.entries) {
            Dimension2D dimension2D = elementTreeEntry.getPreferredDimensionFirstCell(stringBounder);
            d3 = Math.max(d3, dimension2D.getWidth());
            d4 += dimension2D.getHeight();
        }
        double d5 = this.getWidthOther(stringBounder).getTotalWidthWithMargin(10.0);
        if (d5 > 0.0) {
            d5 += 10.0;
        }
        return new Dimension2DDouble(d3 + d5 + 2.0, d4);
    }

    private ListWidth getWidthOther(StringBounder stringBounder) {
        ListWidth listWidth = new ListWidth();
        for (ElementTreeEntry elementTreeEntry : this.entries) {
            ListWidth listWidth2 = elementTreeEntry.getPreferredDimensionOtherCell(stringBounder);
            listWidth = listWidth.mergeMax(listWidth2);
        }
        return listWidth;
    }

    private double getWidth1(StringBounder stringBounder) {
        double d = 0.0;
        for (ElementTreeEntry elementTreeEntry : this.entries) {
            Dimension2D dimension2D = elementTreeEntry.getPreferredDimensionFirstCell(stringBounder);
            d = Math.max(d, dimension2D.getWidth());
        }
        return d;
    }

    public void drawU(UGraphic uGraphic, int n, Dimension2D dimension2D) {
        if (n != 0) {
            return;
        }
        StringBounder stringBounder = uGraphic.getStringBounder();
        double d = this.getWidth1(stringBounder);
        ListWidth listWidth = this.getWidthOther(stringBounder);
        Skeleton skeleton = new Skeleton();
        double d2 = 0.0;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        arrayList.add(d2);
        double d3 = 0.0;
        arrayList2.add(d3);
        arrayList2.add(d3 += d + 5.0);
        Object object = listWidth.iterator();
        while (object.hasNext()) {
            arrayList2.add(d3 += object.next() + 10.0);
        }
        for (ElementTreeEntry elementTreeEntry : this.entries) {
            elementTreeEntry.drawFirstCell(uGraphic, 0.0, d2);
            elementTreeEntry.drawSecondCell(uGraphic, d + 10.0, d2, listWidth, 10.0);
            double d4 = elementTreeEntry.getPreferredDimensionFirstCell(stringBounder).getHeight();
            skeleton.add(elementTreeEntry.getXDelta() - 7.0, d2 + d4 / 2.0 - 1.0);
            arrayList.add(d2 += d4);
        }
        uGraphic = uGraphic.apply(new UChangeColor(HtmlColorSet.getInstance().getColorIfValid("#888888")));
        skeleton.draw(uGraphic, 0.0, 0.0);
        if (this.strategy != TableStrategy.DRAW_NONE) {
            object = new Grid2(arrayList, arrayList2, this.strategy);
            ((Grid2)object).drawU(uGraphic);
        }
    }
}

