/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.salt.element;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.salt.element.Element;
import znaishaded.net.sourceforge.plantuml.salt.element.ListWidth;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class ElementTreeEntry {
    private final Element firstElement;
    private final int level;
    private final List<Element> otherElements = new ArrayList<Element>();

    public ElementTreeEntry(int n, Element element) {
        this.firstElement = element;
        this.level = n;
    }

    public void addCell(Element element) {
        this.otherElements.add(element);
    }

    public Dimension2D getPreferredDimensionFirstCell(StringBounder stringBounder) {
        return Dimension2DDouble.delta(this.firstElement.getPreferredDimension(stringBounder, 0.0, 0.0), this.getXDelta(), 0.0);
    }

    public ListWidth getPreferredDimensionOtherCell(StringBounder stringBounder) {
        ListWidth listWidth = new ListWidth();
        for (Element element : this.otherElements) {
            listWidth.add(element.getPreferredDimension(stringBounder, 0.0, 0.0).getWidth());
        }
        return listWidth;
    }

    public double getXDelta() {
        return this.level * 10;
    }

    public void drawFirstCell(UGraphic uGraphic, double d, double d2) {
        this.firstElement.drawU(uGraphic.apply(new UTranslate(d + this.getXDelta(), d2)), 0, null);
    }

    public void drawSecondCell(UGraphic uGraphic, double d, double d2, ListWidth listWidth, double d3) {
        Iterator<Double> iterator = listWidth.iterator();
        for (Element element : this.otherElements) {
            element.drawU(uGraphic.apply(new UTranslate(d, d2)), 0, null);
            d += iterator.next() + d3;
        }
    }
}

