/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.stats;

import java.io.OutputStream;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import znaishaded.net.sourceforge.plantuml.stats.HumanDuration;
import znaishaded.net.sourceforge.plantuml.stats.api.Stats;
import znaishaded.net.sourceforge.plantuml.stats.api.StatsColumn;
import znaishaded.net.sourceforge.plantuml.stats.api.StatsLine;
import znaishaded.net.sourceforge.plantuml.stats.api.StatsTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlConverter {
    private final DateFormat formatter = DateFormat.getDateTimeInstance(3, 2);
    private final Stats stats;

    public XmlConverter(Stats stats) {
        this.stats = stats;
    }

    private Document getDocument() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        document.setXmlStandalone(true);
        Element element = document.createElement("plantuml".toUpperCase());
        document.appendChild(element);
        this.addNode(element, document, this.stats.getLastSessions());
        this.addNode(element, document, this.stats.getCurrentSessionByDiagramType());
        this.addNode(element, document, this.stats.getCurrentSessionByFormat());
        this.addNode(element, document, this.stats.getAllByDiagramType());
        this.addNode(element, document, this.stats.getAllByFormat());
        return document;
    }

    private void addNode(Element element, Document document, StatsTable statsTable) {
        Element element2 = document.createElement(this.toXmlName(statsTable.getName()).toUpperCase());
        for (StatsLine statsLine : statsTable.getLines()) {
            Element element3 = document.createElement("line".toUpperCase());
            for (StatsColumn statsColumn : statsTable.getColumnHeaders()) {
                Element element4 = document.createElement(statsColumn.name());
                element4.setTextContent(this.toText(statsLine.getValue(statsColumn)));
                element3.appendChild(element4);
            }
            element2.appendChild(element3);
        }
        element.appendChild(element2);
    }

    private String toXmlName(String string) {
        return string.replaceAll("\\W+", "_");
    }

    private String toText(Object object) {
        if (object instanceof Date) {
            return "" + ((Date)object).getTime();
        }
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    private Transformer getTransformer() throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("standalone", "yes");
        return transformer;
    }

    public void createXml(OutputStream outputStream) throws TransformerException, ParserConfigurationException {
        DOMSource dOMSource = new DOMSource(this.getDocument());
        StreamResult streamResult = new StreamResult(outputStream);
        this.getTransformer().transform(dOMSource, streamResult);
    }

    public String toHtml() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append("<style type=\"text/css\">");
        stringBuilder.append("body { font-family: arial, helvetica, sans-serif; font-size: 12px; font-weight: normal; color: black; background: white;}");
        stringBuilder.append("th,td { font-size: 12px;}");
        stringBuilder.append("table { border-collapse: collapse; border-style: none;}");
        stringBuilder.append("</style>");
        stringBuilder.append("<h2>Statistics</h2>");
        this.printTableHtml(stringBuilder, this.stats.getLastSessions());
        stringBuilder.append("<h2>Current session statistics</h2>");
        this.printTableHtml(stringBuilder, this.stats.getCurrentSessionByDiagramType());
        stringBuilder.append("<p>");
        this.printTableHtml(stringBuilder, this.stats.getCurrentSessionByFormat());
        stringBuilder.append("<h2>General statistics since ever</h2>");
        this.printTableHtml(stringBuilder, this.stats.getAllByDiagramType());
        stringBuilder.append("<p>");
        this.printTableHtml(stringBuilder, this.stats.getAllByFormat());
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    private void printTableHtml(StringBuilder stringBuilder, StatsTable statsTable) {
        Collection<StatsColumn> collection = statsTable.getColumnHeaders();
        stringBuilder.append("<table border=1 cellspacing=0 cellpadding=2>");
        stringBuilder.append(this.getHtmlHeader(collection));
        List<StatsLine> list = statsTable.getLines();
        for (int i = 0; i < list.size(); ++i) {
            StatsLine statsLine = list.get(i);
            boolean bl = i == list.size() - 1;
            stringBuilder.append(this.getCreoleLine(collection, statsLine, bl));
        }
        stringBuilder.append("</table>");
    }

    private String getCreoleLine(Collection<StatsColumn> collection, StatsLine statsLine, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append("<tr bgcolor=#f0f0f0>");
        } else {
            stringBuilder.append("<tr bgcolor=#fcfcfc>");
        }
        for (StatsColumn statsColumn : collection) {
            Object object = statsLine.getValue(statsColumn);
            if (object instanceof Long || object instanceof HumanDuration) {
                stringBuilder.append("<td align=right>");
            } else {
                stringBuilder.append("<td>");
            }
            if (bl) {
                stringBuilder.append("<b>");
            }
            if (object instanceof Long) {
                stringBuilder.append(String.format("%,d", object));
            } else if (object instanceof Date) {
                stringBuilder.append(this.formatter.format(object));
            } else if (object == null || object.toString().length() == 0) {
                stringBuilder.append(" ");
            } else {
                stringBuilder.append(object.toString());
            }
            if (bl) {
                stringBuilder.append("</b>");
            }
            stringBuilder.append("</td>");
        }
        stringBuilder.append("</tr>");
        return stringBuilder.toString();
    }

    private String getHtmlHeader(Collection<StatsColumn> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<tr bgcolor=#e0e0e0>");
        for (StatsColumn statsColumn : collection) {
            stringBuilder.append("<td><b>");
            stringBuilder.append(statsColumn.getTitle().replace("\\n", "<br>"));
            stringBuilder.append("</b></td>");
        }
        stringBuilder.append("</tr>");
        return stringBuilder.toString();
    }
}

