/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.ugraphic;

import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import znaishaded.net.sourceforge.plantuml.ugraphic.UShape;

public class UImage
implements UShape {
    private final BufferedImage image;

    public UImage(BufferedImage bufferedImage) {
        this.image = bufferedImage;
    }

    public UImage(BufferedImage bufferedImage, double d) {
        if (d == 1.0) {
            this.image = bufferedImage;
            return;
        }
        int n = (int)Math.round((double)bufferedImage.getWidth() * d);
        int n2 = (int)Math.round((double)bufferedImage.getHeight() * d);
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, bufferedImage.getType());
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.scale(d, d);
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 2);
        this.image = affineTransformOp.filter(bufferedImage, bufferedImage2);
    }

    public UImage scale(double d) {
        return new UImage(this.image, d);
    }

    public final BufferedImage getImage() {
        return this.image;
    }

    public double getWidth() {
        return this.image.getWidth() - 1;
    }

    public double getHeight() {
        return this.image.getHeight() - 1;
    }
}

