/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.version;

import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import znaishaded.net.sourceforge.plantuml.AbstractPSystem;
import znaishaded.net.sourceforge.plantuml.FileFormatOption;
import znaishaded.net.sourceforge.plantuml.FileSystem;
import znaishaded.net.sourceforge.plantuml.Log;
import znaishaded.net.sourceforge.plantuml.OptionFlags;
import znaishaded.net.sourceforge.plantuml.OptionPrint;
import znaishaded.net.sourceforge.plantuml.Run;
import znaishaded.net.sourceforge.plantuml.core.DiagramDescription;
import znaishaded.net.sourceforge.plantuml.core.ImageData;
import znaishaded.net.sourceforge.plantuml.cucadiagram.dot.GraphvizUtils;
import znaishaded.net.sourceforge.plantuml.graphic.GraphicPosition;
import znaishaded.net.sourceforge.plantuml.graphic.GraphicStrings;
import znaishaded.net.sourceforge.plantuml.preproc.PreprocessorInclude;
import znaishaded.net.sourceforge.plantuml.svek.TextBlockBackcolored;
import znaishaded.net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import znaishaded.net.sourceforge.plantuml.ugraphic.ImageBuilder;
import znaishaded.net.sourceforge.plantuml.version.License;
import znaishaded.net.sourceforge.plantuml.version.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PSystemVersion
extends AbstractPSystem {
    private final List<String> strings = new ArrayList<String>();
    private BufferedImage image;
    private static BufferedImage transparentIcon;

    PSystemVersion(boolean bl, List<String> list) {
        this.strings.addAll(list);
        if (bl) {
            this.image = PSystemVersion.getPlantumlImage();
        }
    }

    public static BufferedImage getPlantumlImage() {
        try {
            InputStream inputStream = PSystemVersion.class.getResourceAsStream("logo.png");
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            inputStream.close();
            return bufferedImage;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return new BufferedImage(10, 10, 2);
        }
    }

    public static BufferedImage getCharlieImage() {
        try {
            InputStream inputStream = PSystemVersion.class.getResourceAsStream("charlie.png");
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            inputStream.close();
            return bufferedImage;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return new BufferedImage(10, 10, 2);
        }
    }

    public static BufferedImage getTime() {
        try {
            InputStream inputStream = PSystemVersion.class.getResourceAsStream("time00.png");
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            inputStream.close();
            return bufferedImage;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return new BufferedImage(10, 10, 2);
        }
    }

    public static BufferedImage getPlantumlSmallIcon() {
        try {
            InputStream inputStream = PSystemVersion.class.getResourceAsStream("favicon.png");
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            inputStream.close();
            return bufferedImage;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return new BufferedImage(10, 10, 2);
        }
    }

    public static BufferedImage getPlantumlSmallIcon2() {
        if (transparentIcon != null) {
            return transparentIcon;
        }
        BufferedImage bufferedImage = PSystemVersion.getPlantumlSmallIcon();
        if (bufferedImage == null) {
            return new BufferedImage(10, 10, 2);
        }
        transparentIcon = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 3);
        for (int i = 0; i < bufferedImage.getWidth(); ++i) {
            for (int j = 0; j < bufferedImage.getHeight(); ++j) {
                int n = bufferedImage.getRGB(i, j);
                if (n == bufferedImage.getRGB(0, 0)) continue;
                transparentIcon.setRGB(i, j, n);
            }
        }
        return transparentIcon;
    }

    @Override
    protected final ImageData exportDiagramNow(OutputStream outputStream, int n, FileFormatOption fileFormatOption, long l) throws IOException {
        TextBlockBackcolored textBlockBackcolored = GraphicStrings.createBlackOnWhite(this.strings, this.image, GraphicPosition.BACKGROUND_CORNER_BOTTOM_RIGHT);
        ImageBuilder imageBuilder = new ImageBuilder(new ColorMapperIdentity(), 1.0, textBlockBackcolored.getBackcolor(), this.getMetadata(), null, 0.0, 0.0, null, false);
        imageBuilder.setUDrawable(textBlockBackcolored);
        return imageBuilder.writeImageTOBEMOVED(fileFormatOption, l, outputStream);
    }

    public static PSystemVersion createShowVersion() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("<b>PlantUML version " + Version.versionString() + "</b> (" + Version.compileTimeString() + ")");
        arrayList.add("(" + (Object)((Object)License.getCurrent()) + " source distribution)");
        arrayList.add("Loaded from " + Version.getJarPath());
        if (OptionFlags.getInstance().isWord()) {
            arrayList.add("Word Mode");
            arrayList.add("Command Line: " + Run.getCommandLine());
            arrayList.add("Current Dir: " + FileSystem.getInstance().getCurrentDir().getAbsolutePath());
            arrayList.add("plantuml.include.path: " + PreprocessorInclude.getenv("plantuml.include.path"));
        }
        arrayList.add(" ");
        arrayList.addAll(GraphvizUtils.getTestDotStrings(true));
        arrayList.add(" ");
        for (String string : OptionPrint.interestingProperties()) {
            arrayList.add(string);
        }
        for (String string : OptionPrint.interestingValues()) {
            arrayList.add(string);
        }
        return new PSystemVersion(true, arrayList);
    }

    public static PSystemVersion createShowAuthors() {
        List<String> list = PSystemVersion.getAuthorsStrings(true);
        return new PSystemVersion(true, list);
    }

    public static List<String> getAuthorsStrings(boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        PSystemVersion.add(arrayList, "<b>PlantUML version " + Version.versionString() + "</b> (" + Version.compileTimeString() + ")", bl);
        PSystemVersion.add(arrayList, "(" + (Object)((Object)License.getCurrent()) + " source distribution)", bl);
        PSystemVersion.add(arrayList, " ", bl);
        PSystemVersion.add(arrayList, "<u>Original idea</u>: Arnaud Roques", bl);
        PSystemVersion.add(arrayList, "<u>Word Macro</u>: Alain Bertucat & Matthieu Sabatier", bl);
        PSystemVersion.add(arrayList, "<u>Word Add-in</u>: Adriaan van den Brand", bl);
        PSystemVersion.add(arrayList, "<u>J2V8 & viz.js integration</u>: Andreas Studer", bl);
        PSystemVersion.add(arrayList, "<u>Official Eclipse Plugin</u>: Hallvard Tr\u00e6tteberg", bl);
        PSystemVersion.add(arrayList, "<u>Original Eclipse Plugin</u>: Claude Durif & Anne Pecoil", bl);
        PSystemVersion.add(arrayList, "<u>Servlet & XWiki</u>: Maxime Sinclair", bl);
        PSystemVersion.add(arrayList, "<u>Site design</u>: Raphael Cotisson", bl);
        PSystemVersion.add(arrayList, "<u>Logo</u>: Benjamin Croizet", bl);
        PSystemVersion.add(arrayList, " ", bl);
        PSystemVersion.add(arrayList, "http://plantuml.com", bl);
        PSystemVersion.add(arrayList, " ", bl);
        return arrayList;
    }

    private static void add(List<String> list, String string, boolean bl) {
        if (!bl) {
            string = string.replaceAll("\\</?\\w+\\>", "");
        }
        list.add(string);
    }

    public static PSystemVersion createCheckVersions(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("<b>PlantUML version " + Version.versionString() + "</b> (" + Version.compileTimeString() + ")");
        int n = PSystemVersion.extractDownloadableVersion(string, string2);
        int n2 = 7;
        if (n == -1) {
            arrayList.add("<b><color:red>Error");
            arrayList.add("<color:red>Cannot connect to http://plantuml.com/");
            arrayList.add("Maybe you should set your proxy ?");
            arrayList.add("@startuml");
            arrayList.add("checkversion(proxy=myproxy.com,port=8080)");
            arrayList.add("@enduml");
            n2 = 9;
        } else if (n == 0) {
            arrayList.add("<b><color:red>Error</b>");
            arrayList.add("Cannot retrieve last version from http://plantuml.com/");
        } else {
            arrayList.add("<b>Last available version for download</b> : " + n);
            arrayList.add(" ");
            if (Version.version() >= n) {
                arrayList.add("<b><color:green>Your version is up to date.");
            } else {
                arrayList.add("<b><color:red>A newer version is available for download.");
            }
        }
        while (arrayList.size() < n2) {
            arrayList.add(" ");
        }
        return new PSystemVersion(true, arrayList);
    }

    public static int extractDownloadableVersion(String string, String string2) {
        if (string != null && string2 != null) {
            System.setProperty("http.proxyHost", string);
            System.setProperty("http.proxyPort", string2);
        }
        try {
            URL uRL = new URL("http://plantuml.com/download");
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setUseCaches(false);
            httpURLConnection.connect();
            if (httpURLConnection.getResponseCode() == 200) {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
                int n = PSystemVersion.extractVersion(bufferedReader);
                bufferedReader.close();
                httpURLConnection.disconnect();
                return n;
            }
        }
        catch (IOException iOException) {
            Log.error(iOException.toString());
        }
        return -1;
    }

    private static int extractVersion(BufferedReader bufferedReader) throws IOException {
        String string;
        Pattern pattern = Pattern.compile(".*\\.([1-9]\\d?)\\.(20\\d\\d)\\.([1-9]?\\d)\\..*");
        while ((string = bufferedReader.readLine()) != null) {
            Matcher matcher = pattern.matcher(string);
            if (!matcher.matches()) continue;
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            String string4 = matcher.group(3);
            return Integer.parseInt(string2) * 1000000 + Integer.parseInt(string3) * 100 + Integer.parseInt(string4);
        }
        return 0;
    }

    public static PSystemVersion createTestDot() throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(GraphvizUtils.getTestDotStrings(true));
        return new PSystemVersion(false, arrayList);
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Version)");
    }

    public List<String> getLines() {
        return Collections.unmodifiableList(this.strings);
    }
}

