/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.cpp.parser;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.testingisdocumenting.znai.utils.StringUtils;

public class CodePart {
    private boolean isComment;
    private StringBuilder data;

    public CodePart(boolean isComment, String data) {
        this.isComment = isComment;
        this.data = new StringBuilder();
        this.add(data);
    }

    public boolean isComment() {
        return this.isComment;
    }

    public boolean isEmpty() {
        return this.data.toString().trim().isEmpty();
    }

    public void add(String part) {
        this.data.append(this.isComment ? this.removeCommentChars(part) : part);
    }

    private String removeCommentChars(String part) {
        return Arrays.stream(part.split("\n")).map(this::removeCommentCharsFromLine).collect(Collectors.joining("\n"));
    }

    private String removeCommentCharsFromLine(String line) {
        String trimmed = line.trim();
        return trimmed.replaceFirst("^//*", "").replaceFirst("^\\*", "").replaceFirst("^//*", "");
    }

    public String getData() {
        return this.isComment ? this.data.toString().trim() : StringUtils.stripIndentation(this.data.toString());
    }

    public String toString() {
        return "CodePart{isComment=" + this.isComment() + ", data=" + this.getData() + '}';
    }
}

