/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.diagrams.graphviz.meta;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.testingisdocumenting.znai.diagrams.graphviz.meta.GraphvizNodeShape;
import org.testingisdocumenting.znai.diagrams.graphviz.meta.GraphvizShapeConfig;
import org.testingisdocumenting.znai.utils.RegexpUtils;

public class GraphvizDiagramWithMeta {
    private static final Pattern NODE_PATTERN = Pattern.compile("(\\S+)\\s*\\[.*?label\\s*=\\s*\"(.*?\\[[^]]*]\\s*)\".*?]\\s*;");
    private static final Pattern LABEL_PATTERN = Pattern.compile("\\[(.*?)]");
    private final String preprocessed;
    private final String[] contentLines;
    private final Map<String, List<String>> stylesById;
    private GraphvizShapeConfig metaConfig;

    public static GraphvizDiagramWithMeta create(GraphvizShapeConfig metaConfig, String diagramContent) {
        return new GraphvizDiagramWithMeta(metaConfig, diagramContent);
    }

    public String getPreprocessed() {
        return this.preprocessed;
    }

    public Map<String, List<String>> getStylesById() {
        return this.stylesById;
    }

    private GraphvizDiagramWithMeta(GraphvizShapeConfig metaConfig, String originalGv) {
        this.metaConfig = metaConfig;
        this.stylesById = new LinkedHashMap<String, List<String>>();
        this.contentLines = originalGv.split("\n");
        this.preprocessed = this.preprocess();
    }

    private String preprocess() {
        return Arrays.stream(this.contentLines).map(l -> RegexpUtils.replaceAll(l, NODE_PATTERN, this::replaceAndExtractMeta)).collect(Collectors.joining("\n"));
    }

    private String replaceAndExtractMeta(Matcher m3) {
        String id = m3.group(1);
        String label = m3.group(2);
        List<String> styles = this.extractStyles(label);
        this.stylesById.put(id, styles);
        String additionalProps = this.additionalProps(styles);
        if (!additionalProps.isEmpty()) {
            additionalProps = "," + additionalProps;
        }
        return id + " [label=\"" + this.removeMeta(label) + "\"" + additionalProps + "];";
    }

    private String removeMeta(String label) {
        return RegexpUtils.replaceAll(label, LABEL_PATTERN, m3 -> "").trim();
    }

    private String additionalProps(List<String> styles) {
        return styles.stream().map(this.metaConfig::nodeShape).filter(Optional::isPresent).map(Optional::get).map(GraphvizNodeShape::asAttrs).findFirst().orElse("");
    }

    private List<String> extractStyles(String label) {
        Matcher matcher = LABEL_PATTERN.matcher(label);
        return matcher.find() ? Arrays.asList(matcher.group(1).split(" ")) : Collections.emptyList();
    }
}

