/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.api;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ApiParameter {
    private final String name;
    private final String type;
    private final List<Map<String, Object>> description;
    private final List<ApiParameter> children;

    public ApiParameter(String name, String type, List<Map<String, Object>> description) {
        this.name = name;
        this.type = type;
        this.description = description;
        this.children = new ArrayList<ApiParameter>();
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public List<Map<String, Object>> getDescription() {
        return this.description;
    }

    public List<ApiParameter> getChildren() {
        return this.children;
    }

    public ApiParameter add(String name, String type, List<Map<String, Object>> description) {
        ApiParameter apiParameter = new ApiParameter(name, type, description);
        this.children.add(apiParameter);
        return apiParameter;
    }

    ApiParameter find(String name) {
        return this.children.stream().filter(p -> p.name.equals(name)).findFirst().orElseThrow(() -> new RuntimeException("no children found with name: '" + name + "' in '" + this.name + "'"));
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("name", this.name);
        result.put("type", this.type);
        result.put("description", this.description);
        if (!this.children.isEmpty()) {
            result.put("children", this.children.stream().map(ApiParameter::toMap).collect(Collectors.toList()));
        }
        return result;
    }
}

