/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.markup;

import java.nio.file.Path;
import java.util.List;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.parser.MarkupParser;
import org.testingisdocumenting.znai.parser.MarkupParserResult;
import org.testingisdocumenting.znai.parser.ParserHandler;
import org.testingisdocumenting.znai.resources.ResourcesResolver;
import org.testingisdocumenting.znai.search.SearchScore;
import org.testingisdocumenting.znai.search.SearchText;

public class MarkdownIncludePlugin
implements IncludePlugin {
    private static final String FIRST_AVAILABLE_PARAM = "firstAvailable";
    private static final String USAGE_MESSAGE = "use either <firstAvailable> or free form param to specify file to include";
    private MarkupParserResult parserResult;
    private Path markdownPathUsed;

    @Override
    public String id() {
        return "markdown";
    }

    @Override
    public IncludePlugin create() {
        return new MarkdownIncludePlugin();
    }

    @Override
    public PluginResult process(ComponentsRegistry componentsRegistry, ParserHandler parserHandler, Path markupPath, PluginParams pluginParams) {
        ResourcesResolver resourcesResolver = componentsRegistry.resourceResolver();
        MarkupParser parser = componentsRegistry.defaultParser();
        this.markdownPathUsed = this.selectMarkdown(componentsRegistry.resourceResolver(), pluginParams);
        this.parserResult = parser.parse(markupPath, resourcesResolver.textContent(this.markdownPathUsed));
        return PluginResult.docElements(this.parserResult.getDocElement().getContent().stream());
    }

    private Path selectMarkdown(ResourcesResolver resourcesResolver, PluginParams pluginParams) {
        if (pluginParams.getOpts().has(FIRST_AVAILABLE_PARAM) && !pluginParams.getFreeParam().isEmpty()) {
            throw new IllegalArgumentException("use either <firstAvailable> or free form param to specify file to include, but not both");
        }
        List optionalPaths = pluginParams.getOpts().getList(FIRST_AVAILABLE_PARAM);
        if (pluginParams.getFreeParam().isEmpty() && optionalPaths.isEmpty()) {
            throw new IllegalArgumentException("use either <firstAvailable> or free form param to specify file to include, but none was specified");
        }
        return optionalPaths.stream().filter(p -> resourcesResolver.canResolve(p.toString())).findFirst().map(p -> resourcesResolver.fullPath(p.toString())).orElseGet(() -> resourcesResolver.fullPath(pluginParams.getFreeParam()));
    }

    @Override
    public Stream<AuxiliaryFile> auxiliaryFiles(ComponentsRegistry componentsRegistry) {
        return Stream.concat(Stream.of(AuxiliaryFile.builtTime(this.markdownPathUsed)), this.parserResult.getAuxiliaryFiles().stream());
    }

    @Override
    public SearchText textForSearch() {
        return SearchScore.STANDARD.text(this.parserResult.getAllText());
    }
}

