/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.markup;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.parser.MarkupParser;
import org.testingisdocumenting.znai.parser.MarkupParserResult;
import org.testingisdocumenting.znai.parser.ParserHandler;
import org.testingisdocumenting.znai.parser.docelement.DocElement;
import org.testingisdocumenting.znai.search.SearchScore;
import org.testingisdocumenting.znai.search.SearchText;
import org.testingisdocumenting.znai.utils.FileUtils;

public class MarkdownsIncludePlugin
implements IncludePlugin {
    private List<Path> markdowns;
    private List<MarkupParserResult> parserResults;

    @Override
    public String id() {
        return "markdowns";
    }

    @Override
    public IncludePlugin create() {
        return new MarkdownsIncludePlugin();
    }

    @Override
    public PluginResult process(ComponentsRegistry componentsRegistry, ParserHandler parserHandler, Path markupPath, PluginParams pluginParams) {
        Path dir = componentsRegistry.resourceResolver().fullPath(pluginParams.getFreeParam());
        MarkupParser parser = componentsRegistry.defaultParser();
        this.markdowns = this.markdowns(dir).collect(Collectors.toList());
        this.parserResults = this.markdowns.stream().map(p -> parser.parse(markupPath, FileUtils.fileTextContent(p))).collect(Collectors.toList());
        Stream<DocElement> elements = this.parserResults.stream().flatMap(r -> r.getDocElement().getContent().stream());
        return PluginResult.docElements(elements);
    }

    private Stream<Path> markdowns(Path dir) {
        try {
            return Files.list(dir).filter(f -> f.toString().endsWith(".md")).sorted(Comparator.comparing(Path::toString).reversed());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Stream<AuxiliaryFile> auxiliaryFiles(ComponentsRegistry componentsRegistry) {
        return this.markdowns.stream().map(AuxiliaryFile::builtTime);
    }

    @Override
    public SearchText textForSearch() {
        String textFromMarkupResults = this.parserResults.stream().map(MarkupParserResult::getAllText).collect(Collectors.joining(" "));
        return SearchScore.STANDARD.text(textFromMarkupResults);
    }
}

