/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.templates;

import java.nio.file.Path;
import java.util.Collections;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.ColonDelimitedKeyValues;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.fence.FencePlugin;
import org.testingisdocumenting.znai.parser.MarkupParser;
import org.testingisdocumenting.znai.parser.MarkupParserResult;
import org.testingisdocumenting.znai.resources.ResourcesResolver;
import org.testingisdocumenting.znai.search.SearchScore;
import org.testingisdocumenting.znai.search.SearchText;
import org.testingisdocumenting.znai.template.TextTemplate;

public class TemplateFencePlugin
implements FencePlugin {
    private Path fullPath;
    private MarkupParserResult parserResult;

    @Override
    public String id() {
        return "template";
    }

    @Override
    public FencePlugin create() {
        return new TemplateFencePlugin();
    }

    @Override
    public PluginResult process(ComponentsRegistry componentsRegistry, Path markupPath, PluginParams pluginParams, String content) {
        ResourcesResolver resourcesResolver = componentsRegistry.resourceResolver();
        MarkupParser parser = componentsRegistry.defaultParser();
        this.fullPath = resourcesResolver.fullPath(pluginParams.getFreeParam());
        this.parserResult = parser.parse(markupPath, this.processTemplate(resourcesResolver.textContent(this.fullPath), new ColonDelimitedKeyValues(content)));
        return PluginResult.docElements(this.parserResult.getDocElement().getContent().stream());
    }

    private String processTemplate(String template, ColonDelimitedKeyValues keyValues) {
        return new TextTemplate(this.fullPath.getFileName().toString(), template).process(Collections.unmodifiableMap(keyValues.toMap()));
    }

    @Override
    public Stream<AuxiliaryFile> auxiliaryFiles(ComponentsRegistry componentsRegistry) {
        return Stream.concat(this.parserResult.getAuxiliaryFiles().stream(), Stream.of(AuxiliaryFile.builtTime(this.fullPath)));
    }

    @Override
    public SearchText textForSearch() {
        return SearchScore.STANDARD.text(this.parserResult.getAllText());
    }
}

