/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.java.parser;

import java.util.List;
import org.testingisdocumenting.znai.utils.StringUtils;
import znaishaded.com.github.javaparser.Position;
import znaishaded.com.github.javaparser.Range;
import znaishaded.com.github.javaparser.ast.body.BodyDeclaration;

public class JavaCodeUtils {
    public static String removeSemicolonAtEnd(String code) {
        return code.endsWith(";") ? code.substring(0, code.length() - 1) : code;
    }

    public static String removeReturn(String code) {
        return code.replace("return", "      ");
    }

    static String extractCode(List<String> lines, BodyDeclaration declaration) {
        Range range = declaration.getRange().orElseGet(() -> new Range(new Position(0, 0), new Position(0, 0)));
        int startLine = range.begin.line - 1;
        int endLine = range.end.line - 1;
        return String.join((CharSequence)"\n", lines.subList(startLine, endLine + 1));
    }

    static String extractSignature(String code) {
        int i = code.indexOf(123);
        return StringUtils.stripIndentation(i == -1 ? code : code.substring(0, i)).trim();
    }
}

