/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.parser.table;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.parser.table.Column;
import org.testingisdocumenting.znai.parser.table.Row;

public class MarkupTableData {
    private List<Column> header;
    private List<Row> data;

    public MarkupTableData() {
        this.header = new ArrayList<Column>();
        this.data = new ArrayList<Row>();
    }

    MarkupTableData(List<Column> header, List<Row> data) {
        this.header = header;
        this.data = data;
    }

    public Stream<String> columnNamesStream() {
        return this.header.stream().map(Column::getTitle);
    }

    public Stream<Object> allValuesStream() {
        return this.data.stream().flatMap(row -> row.getData().stream());
    }

    public <E> Stream<E> mapRows(Function<Row, E> converter) {
        return this.data.stream().map(converter);
    }

    public void forEachRow(Consumer<Row> consumer) {
        this.data.forEach(consumer);
    }

    public String allText() {
        ArrayList textParts = new ArrayList();
        this.columnNamesStream().forEach(textParts::add);
        this.allValuesStream().filter(Objects::nonNull).forEach(v -> textParts.add(v.toString()));
        return String.join((CharSequence)" ", textParts);
    }

    public MarkupTableData withColumnsInOrder(List<String> columnNames) {
        List<Integer> newIdxOrder = this.findColumnIdxes(columnNames);
        List<Column> newHeader = newIdxOrder.stream().map(this.header::get).collect(Collectors.toList());
        List<Row> newRows = this.data.stream().map(r -> r.onlyWithIdxs(newIdxOrder)).collect(Collectors.toList());
        return new MarkupTableData(newHeader, newRows);
    }

    private List<Integer> findColumnIdxes(List<String> columnNames) {
        return columnNames.stream().map(this::findColumnIdx).collect(Collectors.toList());
    }

    private Integer findColumnIdx(String columnName) {
        for (int idx = 0; idx < this.header.size(); ++idx) {
            if (!this.header.get(idx).getTitle().toLowerCase().equals(columnName.toLowerCase())) continue;
            return idx;
        }
        throw new RuntimeException("cannot find column: " + columnName);
    }

    public void addColumn(String name) {
        this.header.add(new Column(name));
    }

    public void addColumn(String name, String align) {
        this.header.add(new Column(name, align));
    }

    public void addRow(Map<String, ?> rowData) {
        Row row = new Row();
        this.header.forEach(c -> row.add(rowData.get(c.getTitle())));
        this.addRow(row);
    }

    public void addRow(Row row) {
        this.data.add(row);
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("columns", this.header.stream().map(Column::toMap).collect(Collectors.toList()));
        result.put("data", this.data.stream().map(Row::getData).collect(Collectors.toList()));
        return result;
    }
}

