/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.search;

import java.util.ArrayList;
import java.util.List;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.fence.FencePlugin;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.parser.NoOpParserHandler;
import org.testingisdocumenting.znai.parser.table.MarkupTableData;
import org.testingisdocumenting.znai.reference.DocReferences;
import org.testingisdocumenting.znai.search.PageSearchEntry;
import org.testingisdocumenting.znai.search.SearchScore;
import org.testingisdocumenting.znai.search.SearchText;

public class SearchCrawlerParserHandler
extends NoOpParserHandler {
    private List<PageSearchEntry> searchEntries = new ArrayList<PageSearchEntry>();
    private String pageSectionTitle = "";
    private List<String> currentTextParts = new ArrayList<String>();

    public List<PageSearchEntry> getSearchEntries() {
        return this.searchEntries;
    }

    @Override
    public void onSectionStart(String title) {
        this.pageSectionTitle = title;
    }

    @Override
    public void onSectionEnd() {
        this.flushTextParts();
    }

    @Override
    public void onTable(MarkupTableData tableData) {
        this.addSeparated(tableData.allText());
    }

    @Override
    public void onSimpleText(String value) {
        this.add(value);
    }

    @Override
    public void onInlinedCode(String inlinedCode, DocReferences docReferences) {
        this.addSeparated(inlinedCode);
    }

    @Override
    public void onLinkStart(String url) {
        this.addSeparated(url);
    }

    @Override
    public void onImage(String title, String destination, String alt) {
        this.addSeparated(title);
        this.addSeparated(destination);
        this.addSeparated(alt);
    }

    @Override
    public void onSnippet(PluginParams pluginParams, String lang, String lineNumber, String snippet) {
        this.addSeparated(lang);
        this.addSeparated(snippet);
    }

    @Override
    public void onIncludePlugin(IncludePlugin includePlugin, PluginResult pluginResult) {
        SearchText searchText = includePlugin.textForSearch();
        if (searchText != null) {
            this.addSeparated(searchText.getText());
        }
    }

    @Override
    public void onFencePlugin(FencePlugin fencePlugin, PluginResult pluginResult) {
        SearchText searchText = fencePlugin.textForSearch();
        if (searchText != null) {
            this.addSeparated(searchText.getText());
        }
    }

    @Override
    public void onSoftLineBreak() {
        this.add(" ");
    }

    @Override
    public void onHardLineBreak() {
        this.add(" ");
    }

    @Override
    public void onParsingEnd() {
        this.flushTextParts();
    }

    private void add(String part) {
        this.currentTextParts.add(part);
    }

    private void addSeparated(String part) {
        this.currentTextParts.add(' ' + part + ' ');
    }

    private void flushTextParts() {
        if (this.currentTextParts.isEmpty()) {
            return;
        }
        SearchText searchText = SearchScore.STANDARD.text(String.join((CharSequence)"", this.currentTextParts).replaceAll("\\s+", " ").trim());
        this.searchEntries.add(new PageSearchEntry(this.pageSectionTitle, searchText));
        this.currentTextParts.clear();
    }
}

