/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.jayway.jsonpath.internal.function;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import znaishaded.com.jayway.jsonpath.InvalidPathException;
import znaishaded.com.jayway.jsonpath.internal.function.PathFunction;
import znaishaded.com.jayway.jsonpath.internal.function.json.Append;
import znaishaded.com.jayway.jsonpath.internal.function.numeric.Average;
import znaishaded.com.jayway.jsonpath.internal.function.numeric.Max;
import znaishaded.com.jayway.jsonpath.internal.function.numeric.Min;
import znaishaded.com.jayway.jsonpath.internal.function.numeric.StandardDeviation;
import znaishaded.com.jayway.jsonpath.internal.function.numeric.Sum;
import znaishaded.com.jayway.jsonpath.internal.function.text.Concatenate;
import znaishaded.com.jayway.jsonpath.internal.function.text.Length;

public class PathFunctionFactory {
    public static final Map<String, Class> FUNCTIONS;

    public static PathFunction newFunction(String name) throws InvalidPathException {
        Class functionClazz = FUNCTIONS.get(name);
        if (functionClazz == null) {
            throw new InvalidPathException("Function with name: " + name + " does not exist.");
        }
        try {
            return (PathFunction)functionClazz.newInstance();
        }
        catch (Exception e) {
            throw new InvalidPathException("Function of name: " + name + " cannot be created", e);
        }
    }

    static {
        HashMap<String, Class> map = new HashMap<String, Class>();
        map.put("avg", Average.class);
        map.put("stddev", StandardDeviation.class);
        map.put("sum", Sum.class);
        map.put("min", Min.class);
        map.put("max", Max.class);
        map.put("concat", Concatenate.class);
        map.put("length", Length.class);
        map.put("size", Length.class);
        map.put("append", Append.class);
        FUNCTIONS = Collections.unmodifiableMap(map);
    }
}

