/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.freemarker.core;

import znaishaded.freemarker.core.AddConcatExpression;
import znaishaded.freemarker.core.ArithmeticExpression;
import znaishaded.freemarker.core.AssignmentInstruction;
import znaishaded.freemarker.core.BugException;
import znaishaded.freemarker.core.Environment;
import znaishaded.freemarker.core.EvalUtil;
import znaishaded.freemarker.core.Expression;
import znaishaded.freemarker.core.InvalidReferenceException;
import znaishaded.freemarker.core.NonNamespaceException;
import znaishaded.freemarker.core.NonNumericalException;
import znaishaded.freemarker.core.ParameterRole;
import znaishaded.freemarker.core.TemplateElement;
import znaishaded.freemarker.core._CoreStringUtils;
import znaishaded.freemarker.template.TemplateException;
import znaishaded.freemarker.template.TemplateModel;
import znaishaded.freemarker.template.TemplateNumberModel;
import znaishaded.freemarker.template.TemplateScalarModel;

final class Assignment
extends TemplateElement {
    private static final int OPERATOR_TYPE_EQUALS = 65536;
    private static final int OPERATOR_TYPE_PLUS_EQUALS = 65537;
    private static final int OPERATOR_TYPE_PLUS_PLUS = 65538;
    private static final int OPERATOR_TYPE_MINUS_MINUS = 65539;
    private final int scope;
    private final String variableName;
    private final int operatorType;
    private final Expression valueExp;
    private Expression namespaceExp;
    static final int NAMESPACE = 1;
    static final int LOCAL = 2;
    static final int GLOBAL = 3;
    private static final Number ONE = new Integer(1);

    Assignment(String variableName, int operator, Expression valueExp, int scope) {
        this.scope = scope;
        this.variableName = variableName;
        if (operator == 97) {
            this.operatorType = 65536;
        } else {
            switch (operator) {
                case 105: {
                    this.operatorType = 65538;
                    break;
                }
                case 106: {
                    this.operatorType = 65539;
                    break;
                }
                case 100: {
                    this.operatorType = 65537;
                    break;
                }
                case 101: {
                    this.operatorType = 0;
                    break;
                }
                case 102: {
                    this.operatorType = 1;
                    break;
                }
                case 103: {
                    this.operatorType = 2;
                    break;
                }
                case 104: {
                    this.operatorType = 3;
                    break;
                }
                default: {
                    throw new BugException();
                }
            }
        }
        this.valueExp = valueExp;
    }

    void setNamespaceExp(Expression namespaceExp) {
        if (this.scope != 1 && namespaceExp != null) {
            throw new BugException();
        }
        this.namespaceExp = namespaceExp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void accept(Environment env) throws TemplateException {
        TemplateModel value;
        Environment.Namespace namespace;
        block23: {
            block22: {
                if (this.namespaceExp != null) break block22;
                switch (this.scope) {
                    case 2: {
                        namespace = null;
                        break block23;
                    }
                    case 3: {
                        namespace = env.getGlobalNamespace();
                        break block23;
                    }
                    case 1: {
                        namespace = env.getCurrentNamespace();
                        break block23;
                    }
                    default: {
                        throw new BugException("Unexpected scope type: " + this.scope);
                    }
                }
            }
            TemplateModel namespaceTM = this.namespaceExp.eval(env);
            try {
                namespace = (Environment.Namespace)namespaceTM;
            }
            catch (ClassCastException e) {
                throw new NonNamespaceException(this.namespaceExp, namespaceTM, env);
            }
            if (namespace == null) {
                throw InvalidReferenceException.getInstance(this.namespaceExp, env);
            }
        }
        if (this.operatorType == 65536) {
            value = this.valueExp.eval(env);
            if (value == null) {
                if (!env.isClassicCompatible()) throw InvalidReferenceException.getInstance(this.valueExp, env);
                value = TemplateScalarModel.EMPTY_STRING;
            }
        } else {
            TemplateModel lhoValue = namespace == null ? env.getLocalVariable(this.variableName) : namespace.get(this.variableName);
            if (this.operatorType == 65537) {
                if (lhoValue == null) {
                    if (!env.isClassicCompatible()) throw InvalidReferenceException.getInstance(this.variableName, this.getOperatorTypeAsString(), env);
                    lhoValue = TemplateScalarModel.EMPTY_STRING;
                }
                if ((value = this.valueExp.eval(env)) == null) {
                    if (!env.isClassicCompatible()) throw InvalidReferenceException.getInstance(this.valueExp, env);
                    value = TemplateScalarModel.EMPTY_STRING;
                }
                value = AddConcatExpression._eval(env, this.namespaceExp, null, lhoValue, this.valueExp, value);
            } else {
                if (!(lhoValue instanceof TemplateNumberModel)) {
                    if (lhoValue != null) throw new NonNumericalException(this.variableName, lhoValue, null, env);
                    throw InvalidReferenceException.getInstance(this.variableName, this.getOperatorTypeAsString(), env);
                }
                Number lhoNumber = EvalUtil.modelToNumber((TemplateNumberModel)lhoValue, null);
                if (this.operatorType == 65538) {
                    value = AddConcatExpression._evalOnNumbers(env, this.getParentElement(), lhoNumber, ONE);
                } else if (this.operatorType == 65539) {
                    value = ArithmeticExpression._eval(env, this.getParentElement(), lhoNumber, 0, ONE);
                } else {
                    Number rhoNumber = this.valueExp.evalToNumber(env);
                    value = ArithmeticExpression._eval(env, this, lhoNumber, this.operatorType, rhoNumber);
                }
            }
        }
        if (namespace == null) {
            env.setLocalVariable(this.variableName, value);
            return;
        } else {
            namespace.put(this.variableName, value);
        }
    }

    protected String dump(boolean canonical) {
        String dn;
        StringBuffer buf = new StringBuffer();
        String string = dn = this.getParentElement() instanceof AssignmentInstruction ? null : this.getNodeTypeSymbol();
        if (dn != null) {
            if (canonical) {
                buf.append("<");
            }
            buf.append(dn);
            buf.append(' ');
        }
        buf.append(_CoreStringUtils.toFTLTopLevelTragetIdentifier(this.variableName));
        if (this.valueExp != null) {
            buf.append(' ');
        }
        buf.append(this.getOperatorTypeAsString());
        if (this.valueExp != null) {
            buf.append(' ');
            buf.append(this.valueExp.getCanonicalForm());
        }
        if (dn != null) {
            if (this.namespaceExp != null) {
                buf.append(" in ");
                buf.append(this.namespaceExp.getCanonicalForm());
            }
            if (canonical) {
                buf.append(">");
            }
        }
        String result = buf.toString();
        return result;
    }

    String getNodeTypeSymbol() {
        return Assignment.getDirectiveName(this.scope);
    }

    static String getDirectiveName(int scope) {
        if (scope == 2) {
            return "#local";
        }
        if (scope == 3) {
            return "#global";
        }
        if (scope == 1) {
            return "#assign";
        }
        return "#{unknown_assignment_type}";
    }

    int getParameterCount() {
        return 5;
    }

    Object getParameterValue(int idx) {
        switch (idx) {
            case 0: {
                return this.variableName;
            }
            case 1: {
                return this.getOperatorTypeAsString();
            }
            case 2: {
                return this.valueExp;
            }
            case 3: {
                return new Integer(this.scope);
            }
            case 4: {
                return this.namespaceExp;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    ParameterRole getParameterRole(int idx) {
        switch (idx) {
            case 0: {
                return ParameterRole.ASSIGNMENT_TARGET;
            }
            case 1: {
                return ParameterRole.ASSIGNMENT_OPERATOR;
            }
            case 2: {
                return ParameterRole.ASSIGNMENT_SOURCE;
            }
            case 3: {
                return ParameterRole.VARIABLE_SCOPE;
            }
            case 4: {
                return ParameterRole.NAMESPACE;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    boolean isNestedBlockRepeater() {
        return false;
    }

    private String getOperatorTypeAsString() {
        if (this.operatorType == 65536) {
            return "=";
        }
        if (this.operatorType == 65537) {
            return "+=";
        }
        if (this.operatorType == 65538) {
            return "++";
        }
        if (this.operatorType == 65539) {
            return "--";
        }
        return ArithmeticExpression.getOperatorSymbol(this.operatorType) + "=";
    }
}

