/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.freemarker.core;

import java.io.IOException;
import znaishaded.freemarker.core.Environment;
import znaishaded.freemarker.core.Expression;
import znaishaded.freemarker.core.ParameterRole;
import znaishaded.freemarker.core.TemplateElement;
import znaishaded.freemarker.template.TemplateException;

final class Case
extends TemplateElement {
    final int TYPE_CASE = 0;
    final int TYPE_DEFAULT = 1;
    Expression condition;

    Case(Expression matchingValue, TemplateElement nestedBlock) {
        this.condition = matchingValue;
        this.setNestedBlock(nestedBlock);
    }

    void accept(Environment env) throws TemplateException, IOException {
        if (this.getNestedBlock() != null) {
            env.visitByHiddingParent(this.getNestedBlock());
        }
    }

    protected String dump(boolean canonical) {
        StringBuffer sb = new StringBuffer();
        if (canonical) {
            sb.append('<');
        }
        sb.append(this.getNodeTypeSymbol());
        if (this.condition != null) {
            sb.append(' ');
            sb.append(this.condition.getCanonicalForm());
        }
        if (canonical) {
            sb.append('>');
            if (this.getNestedBlock() != null) {
                sb.append(this.getNestedBlock().getCanonicalForm());
            }
        }
        return sb.toString();
    }

    String getNodeTypeSymbol() {
        return this.condition != null ? "#case" : "#default";
    }

    int getParameterCount() {
        return 2;
    }

    Object getParameterValue(int idx) {
        switch (idx) {
            case 0: {
                return this.condition;
            }
            case 1: {
                return new Integer(this.condition != null ? 0 : 1);
            }
        }
        throw new IndexOutOfBoundsException();
    }

    ParameterRole getParameterRole(int idx) {
        switch (idx) {
            case 0: {
                return ParameterRole.CONDITION;
            }
            case 1: {
                return ParameterRole.AST_NODE_SUBTYPE;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    boolean isNestedBlockRepeater() {
        return false;
    }
}

