/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.freemarker.core;

import java.io.IOException;
import znaishaded.freemarker.core.BugException;
import znaishaded.freemarker.core.Environment;
import znaishaded.freemarker.core.MixedContent;
import znaishaded.freemarker.core.ParameterRole;
import znaishaded.freemarker.core.ParseException;
import znaishaded.freemarker.core.TemplateElement;
import znaishaded.freemarker.core.TemplatePostProcessor;
import znaishaded.freemarker.core.TemplatePostProcessorException;
import znaishaded.freemarker.template.Template;
import znaishaded.freemarker.template.TemplateException;

class ThreadInterruptionSupportTemplatePostProcessor
extends TemplatePostProcessor {
    ThreadInterruptionSupportTemplatePostProcessor() {
    }

    public void postProcess(Template t) throws TemplatePostProcessorException {
        TemplateElement te = t.getRootTreeNode();
        this.addInterruptionChecks(te);
    }

    private void addInterruptionChecks(TemplateElement te) throws TemplatePostProcessorException {
        if (te == null) {
            return;
        }
        TemplateElement nestedBlock = te.getNestedBlock();
        if (nestedBlock != null) {
            this.addInterruptionChecks(nestedBlock);
        }
        int regulatedChildrenCount = te.getRegulatedChildCount();
        for (int i = 0; i < regulatedChildrenCount; ++i) {
            this.addInterruptionChecks(te.getRegulatedChild(i));
        }
        if (te.isNestedBlockRepeater()) {
            if (regulatedChildrenCount != 0) {
                throw new BugException();
            }
            try {
                ThreadInterruptionCheck interruptedChk = new ThreadInterruptionCheck(te);
                if (nestedBlock == null) {
                    te.setNestedBlock(interruptedChk);
                } else {
                    MixedContent nestedMixedC;
                    if (nestedBlock instanceof MixedContent) {
                        nestedMixedC = (MixedContent)nestedBlock;
                    } else {
                        nestedMixedC = new MixedContent();
                        nestedMixedC.setLocation(te.getTemplate(), 0, 0, 0, 0);
                        nestedMixedC.addElement(nestedBlock);
                        te.setNestedBlock(nestedMixedC);
                    }
                    nestedMixedC.addElement(0, interruptedChk);
                }
            }
            catch (ParseException e) {
                throw new TemplatePostProcessorException("Unexpected error; see cause", e);
            }
        }
    }

    static class TemplateProcessingThreadInterruptedException
    extends RuntimeException {
        TemplateProcessingThreadInterruptedException() {
            super("Template processing thread \"interrupted\" flag was set.");
        }
    }

    static class ThreadInterruptionCheck
    extends TemplateElement {
        private ThreadInterruptionCheck(TemplateElement te) throws ParseException {
            this.setLocation(te.getTemplate(), te.beginColumn, te.beginLine, te.beginColumn, te.beginLine);
        }

        void accept(Environment env) throws TemplateException, IOException {
            if (Thread.currentThread().isInterrupted()) {
                throw new TemplateProcessingThreadInterruptedException();
            }
        }

        protected String dump(boolean canonical) {
            return canonical ? "" : "<#--" + this.getNodeTypeSymbol() + "--#>";
        }

        String getNodeTypeSymbol() {
            return "##threadInterruptionCheck";
        }

        int getParameterCount() {
            return 0;
        }

        Object getParameterValue(int idx) {
            throw new IndexOutOfBoundsException();
        }

        ParameterRole getParameterRole(int idx) {
            throw new IndexOutOfBoundsException();
        }

        boolean isNestedBlockRepeater() {
            return false;
        }
    }
}

