/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.freemarker.ext.dom;

import java.util.List;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import znaishaded.freemarker.core.Environment;
import znaishaded.freemarker.ext.dom.NodeListModel;
import znaishaded.freemarker.ext.dom.XPathSupport;
import znaishaded.freemarker.template.SimpleNumber;
import znaishaded.freemarker.template.SimpleScalar;
import znaishaded.freemarker.template.TemplateBooleanModel;
import znaishaded.freemarker.template.TemplateModel;
import znaishaded.freemarker.template.TemplateModelException;
import znaishaded.org.apache.xml.utils.PrefixResolver;
import znaishaded.org.apache.xpath.XPath;
import znaishaded.org.apache.xpath.XPathContext;
import znaishaded.org.apache.xpath.objects.XBoolean;
import znaishaded.org.apache.xpath.objects.XNodeSet;
import znaishaded.org.apache.xpath.objects.XNull;
import znaishaded.org.apache.xpath.objects.XNumber;
import znaishaded.org.apache.xpath.objects.XObject;
import znaishaded.org.apache.xpath.objects.XString;

class XalanXPathSupport
implements XPathSupport {
    private XPathContext xpathContext = new XPathContext();
    private static final String ERRMSG_EMPTY_NODE_SET = "Cannot perform an XPath query against an empty node set.";
    private static PrefixResolver customPrefixResolver = new PrefixResolver(){

        public String getNamespaceForPrefix(String prefix, Node node) {
            return this.getNamespaceForPrefix(prefix);
        }

        public String getNamespaceForPrefix(String prefix) {
            if (prefix.equals("D")) {
                return Environment.getCurrentEnvironment().getDefaultNS();
            }
            return Environment.getCurrentEnvironment().getNamespaceForPrefix(prefix);
        }

        public String getBaseIdentifier() {
            return null;
        }

        public boolean handlesNullPrefixes() {
            return false;
        }
    };

    XalanXPathSupport() {
    }

    public synchronized TemplateModel executeQuery(Object context, String xpathQuery) throws TemplateModelException {
        if (!(context instanceof Node)) {
            if (context != null) {
                if (XalanXPathSupport.isNodeList(context)) {
                    int cnt = ((List)context).size();
                    if (cnt != 0) {
                        throw new TemplateModelException("Cannot perform an XPath query against a node set of " + cnt + " nodes. Expecting a single node.");
                    }
                    throw new TemplateModelException(ERRMSG_EMPTY_NODE_SET);
                }
                throw new TemplateModelException("Cannot perform an XPath query against a " + context.getClass().getName() + ". Expecting a single org.w3c.dom.Node.");
            }
            throw new TemplateModelException(ERRMSG_EMPTY_NODE_SET);
        }
        Node node = (Node)context;
        try {
            XPath xpath = new XPath(xpathQuery, null, customPrefixResolver, 0, null);
            int ctxtNode = this.xpathContext.getDTMHandleFromNode(node);
            XObject xresult = xpath.execute(this.xpathContext, ctxtNode, customPrefixResolver);
            if (xresult instanceof XNodeSet) {
                Node n;
                NodeListModel result = new NodeListModel(node);
                result.xpathSupport = this;
                NodeIterator nodeIterator = xresult.nodeset();
                do {
                    if ((n = nodeIterator.nextNode()) == null) continue;
                    result.add(n);
                } while (n != null);
                return result.size() == 1 ? result.get(0) : result;
            }
            if (xresult instanceof XBoolean) {
                return ((XBoolean)xresult).bool() ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
            }
            if (xresult instanceof XNull) {
                return null;
            }
            if (xresult instanceof XString) {
                return new SimpleScalar(xresult.toString());
            }
            if (xresult instanceof XNumber) {
                return new SimpleNumber(new Double(((XNumber)xresult).num()));
            }
            throw new TemplateModelException("Cannot deal with type: " + xresult.getClass().getName());
        }
        catch (TransformerException te) {
            throw new TemplateModelException(te);
        }
    }

    private static boolean isNodeList(Object context) {
        if (context instanceof List) {
            List ls = (List)context;
            int ln = ls.size();
            for (int i = 0; i < ln; ++i) {
                if (ls.get(i) instanceof Node) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

