/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.http.impl;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import znaishaded.io.vertx.core.AsyncResult;
import znaishaded.io.vertx.core.Closeable;
import znaishaded.io.vertx.core.Context;
import znaishaded.io.vertx.core.Future;
import znaishaded.io.vertx.core.Handler;
import znaishaded.io.vertx.core.MultiMap;
import znaishaded.io.vertx.core.VertxException;
import znaishaded.io.vertx.core.http.HttpClient;
import znaishaded.io.vertx.core.http.HttpClientOptions;
import znaishaded.io.vertx.core.http.HttpClientRequest;
import znaishaded.io.vertx.core.http.HttpClientResponse;
import znaishaded.io.vertx.core.http.HttpHeaders;
import znaishaded.io.vertx.core.http.HttpMethod;
import znaishaded.io.vertx.core.http.HttpVersion;
import znaishaded.io.vertx.core.http.RequestOptions;
import znaishaded.io.vertx.core.http.WebSocket;
import znaishaded.io.vertx.core.http.WebsocketVersion;
import znaishaded.io.vertx.core.http.impl.ConnectionManager;
import znaishaded.io.vertx.core.http.impl.Http1xClientConnection;
import znaishaded.io.vertx.core.http.impl.HttpClientConnection;
import znaishaded.io.vertx.core.http.impl.HttpClientRequestImpl;
import znaishaded.io.vertx.core.http.impl.HttpUtils;
import znaishaded.io.vertx.core.impl.ContextImpl;
import znaishaded.io.vertx.core.impl.VertxInternal;
import znaishaded.io.vertx.core.logging.Logger;
import znaishaded.io.vertx.core.logging.LoggerFactory;
import znaishaded.io.vertx.core.net.ProxyOptions;
import znaishaded.io.vertx.core.net.ProxyType;
import znaishaded.io.vertx.core.net.impl.SSLHelper;
import znaishaded.io.vertx.core.spi.metrics.HttpClientMetrics;
import znaishaded.io.vertx.core.spi.metrics.Metrics;
import znaishaded.io.vertx.core.spi.metrics.MetricsProvider;
import znaishaded.io.vertx.core.streams.ReadStream;

public class HttpClientImpl
implements HttpClient,
MetricsProvider {
    private final Function<HttpClientResponse, Future<HttpClientRequest>> DEFAULT_HANDLER = resp -> {
        try {
            int statusCode = resp.statusCode();
            String location = resp.getHeader(HttpHeaders.LOCATION);
            if (location != null && (statusCode == 301 || statusCode == 302 || statusCode == 303 || statusCode == 307)) {
                boolean ssl;
                HttpMethod m3 = resp.request().method();
                if (statusCode == 303) {
                    m3 = HttpMethod.GET;
                } else if (m3 != HttpMethod.GET && m3 != HttpMethod.HEAD) {
                    return null;
                }
                URI uri = HttpUtils.resolveURIReference(resp.request().absoluteURI(), location);
                int port2 = uri.getPort();
                String protocol = uri.getScheme();
                char chend = protocol.charAt(protocol.length() - 1);
                if (chend == 'p') {
                    ssl = false;
                    if (port2 == -1) {
                        port2 = 80;
                    }
                } else if (chend == 's') {
                    ssl = true;
                    if (port2 == -1) {
                        port2 = 443;
                    }
                } else {
                    return null;
                }
                String requestURI = uri.getPath();
                String query = uri.getQuery();
                if (query != null) {
                    requestURI = requestURI + "?" + query;
                }
                return Future.succeededFuture(this.createRequest(m3, uri.getHost(), port2, ssl, requestURI, null));
            }
            return null;
        }
        catch (Exception e) {
            return Future.failedFuture(e);
        }
    };
    private static final Logger log = LoggerFactory.getLogger(HttpClientImpl.class);
    private final VertxInternal vertx;
    private final HttpClientOptions options;
    private final ContextImpl creatingContext;
    private final ConnectionManager websocketCM;
    private final ConnectionManager httpCM;
    private final Closeable closeHook;
    private final ProxyType proxyType;
    private final SSLHelper sslHelper;
    private final HttpClientMetrics metrics;
    private final boolean keepAlive;
    private final boolean pipelining;
    private volatile boolean closed;
    private volatile Function<HttpClientResponse, Future<HttpClientRequest>> redirectHandler = this.DEFAULT_HANDLER;

    public HttpClientImpl(VertxInternal vertx, HttpClientOptions options) {
        this.vertx = vertx;
        this.metrics = vertx.metricsSPI() != null ? vertx.metricsSPI().createMetrics(this, options) : null;
        this.options = new HttpClientOptions(options);
        List<HttpVersion> alpnVersions = options.getAlpnVersions();
        if (alpnVersions == null || alpnVersions.isEmpty()) {
            switch (options.getProtocolVersion()) {
                case HTTP_2: {
                    alpnVersions = Arrays.asList(HttpVersion.HTTP_2, HttpVersion.HTTP_1_1);
                    break;
                }
                default: {
                    alpnVersions = Collections.singletonList(options.getProtocolVersion());
                }
            }
        }
        this.keepAlive = options.isKeepAlive();
        this.pipelining = options.isPipelining();
        this.sslHelper = new SSLHelper(options, options.getKeyCertOptions(), options.getTrustOptions()).setApplicationProtocols(alpnVersions);
        this.sslHelper.validate(vertx);
        this.creatingContext = vertx.getContext();
        this.closeHook = completionHandler -> {
            this.close();
            completionHandler.handle(Future.succeededFuture());
        };
        if (this.creatingContext != null) {
            if (this.creatingContext.isMultiThreadedWorkerContext()) {
                throw new IllegalStateException("Cannot use HttpClient in a multi-threaded worker verticle");
            }
            if (options.getProtocolVersion() == HttpVersion.HTTP_2 && Context.isOnWorkerThread()) {
                throw new IllegalStateException("Cannot use HttpClient with HTTP_2 in a worker");
            }
            this.creatingContext.addCloseHook(this.closeHook);
        }
        if (!this.keepAlive && this.pipelining) {
            throw new IllegalStateException("Cannot have pipelining with no keep alive");
        }
        long maxWeight = options.getMaxPoolSize() * options.getHttp2MaxPoolSize();
        this.websocketCM = new ConnectionManager(this, this.metrics, HttpVersion.HTTP_1_1, maxWeight, options.getMaxWaitQueueSize());
        this.httpCM = new ConnectionManager(this, this.metrics, options.getProtocolVersion(), maxWeight, options.getMaxWaitQueueSize());
        this.proxyType = options.getProxyOptions() != null ? options.getProxyOptions().getType() : null;
        this.httpCM.start();
        this.websocketCM.start();
    }

    HttpClientMetrics metrics() {
        return this.metrics;
    }

    @Override
    public HttpClient websocket(RequestOptions options, Handler<WebSocket> wsConnect) {
        return this.websocket(options, (MultiMap)null, wsConnect);
    }

    @Override
    public HttpClient websocket(int port2, String host, String requestURI, Handler<WebSocket> wsConnect) {
        this.websocketStream(port2, host, requestURI, null, null).handler(wsConnect);
        return this;
    }

    @Override
    public HttpClient websocket(RequestOptions options, Handler<WebSocket> wsConnect, Handler<Throwable> failureHandler) {
        return this.websocket(options, null, wsConnect, failureHandler);
    }

    @Override
    public HttpClient websocket(int port2, String host, String requestURI, Handler<WebSocket> wsConnect, Handler<Throwable> failureHandler) {
        this.websocketStream(port2, host, requestURI, null, null).subscribe(wsConnect, failureHandler);
        return this;
    }

    @Override
    public HttpClient websocket(String host, String requestURI, Handler<WebSocket> wsConnect) {
        return this.websocket(this.options.getDefaultPort(), host, requestURI, wsConnect);
    }

    @Override
    public HttpClient websocket(String host, String requestURI, Handler<WebSocket> wsConnect, Handler<Throwable> failureHandler) {
        return this.websocket(this.options.getDefaultPort(), host, requestURI, wsConnect, failureHandler);
    }

    @Override
    public HttpClient websocket(RequestOptions options, MultiMap headers, Handler<WebSocket> wsConnect) {
        return this.websocket(options, headers, (WebsocketVersion)null, wsConnect);
    }

    @Override
    public HttpClient websocket(int port2, String host, String requestURI, MultiMap headers, Handler<WebSocket> wsConnect) {
        this.websocketStream(port2, host, requestURI, headers, null).handler(wsConnect);
        return this;
    }

    @Override
    public HttpClient websocket(RequestOptions options, MultiMap headers, Handler<WebSocket> wsConnect, Handler<Throwable> failureHandler) {
        return this.websocket(options, headers, null, wsConnect, failureHandler);
    }

    @Override
    public HttpClient websocket(int port2, String host, String requestURI, MultiMap headers, Handler<WebSocket> wsConnect, Handler<Throwable> failureHandler) {
        this.websocketStream(port2, host, requestURI, headers, null).subscribe(wsConnect, failureHandler);
        return this;
    }

    @Override
    public HttpClient websocket(String host, String requestURI, MultiMap headers, Handler<WebSocket> wsConnect) {
        return this.websocket(this.options.getDefaultPort(), host, requestURI, headers, wsConnect);
    }

    @Override
    public HttpClient websocket(String host, String requestURI, MultiMap headers, Handler<WebSocket> wsConnect, Handler<Throwable> failureHandler) {
        return this.websocket(this.options.getDefaultPort(), host, requestURI, headers, wsConnect, failureHandler);
    }

    @Override
    public HttpClient websocket(RequestOptions options, MultiMap headers, WebsocketVersion version, Handler<WebSocket> wsConnect) {
        return this.websocket(options, headers, version, (String)null, wsConnect);
    }

    @Override
    public HttpClient websocket(int port2, String host, String requestURI, MultiMap headers, WebsocketVersion version, Handler<WebSocket> wsConnect) {
        this.websocketStream(port2, host, requestURI, headers, version, null).handler(wsConnect);
        return this;
    }

    @Override
    public HttpClient websocket(RequestOptions options, MultiMap headers, WebsocketVersion version, Handler<WebSocket> wsConnect, Handler<Throwable> failureHandler) {
        return this.websocket(options, headers, version, null, wsConnect, failureHandler);
    }

    @Override
    public HttpClient websocket(int port2, String host, String requestURI, MultiMap headers, WebsocketVersion version, Handler<WebSocket> wsConnect, Handler<Throwable> failureHandler) {
        this.websocketStream(port2, host, requestURI, headers, version, null).subscribe(wsConnect, failureHandler);
        return this;
    }

    @Override
    public HttpClient websocket(String host, String requestURI, MultiMap headers, WebsocketVersion version, Handler<WebSocket> wsConnect) {
        return this.websocket(this.options.getDefaultPort(), host, requestURI, headers, version, wsConnect);
    }

    @Override
    public HttpClient websocket(String host, String requestURI, MultiMap headers, WebsocketVersion version, Handler<WebSocket> wsConnect, Handler<Throwable> failureHandler) {
        return this.websocket(this.options.getDefaultPort(), host, requestURI, headers, version, wsConnect, failureHandler);
    }

    @Override
    public HttpClient websocket(RequestOptions options, MultiMap headers, WebsocketVersion version, String subProtocols, Handler<WebSocket> wsConnect) {
        this.websocketStream(options, headers, version, subProtocols).handler(wsConnect);
        return this;
    }

    @Override
    public HttpClient websocket(int port2, String host, String requestURI, MultiMap headers, WebsocketVersion version, String subProtocols, Handler<WebSocket> wsConnect) {
        this.websocketStream(port2, host, requestURI, headers, version, subProtocols).handler(wsConnect);
        return this;
    }

    @Override
    public HttpClient websocketAbs(String url, MultiMap headers, WebsocketVersion version, String subProtocols, Handler<WebSocket> wsConnect, Handler<Throwable> failureHandler) {
        this.websocketStreamAbs(url, headers, version, subProtocols).subscribe(wsConnect, failureHandler);
        return this;
    }

    @Override
    public HttpClient websocket(RequestOptions options, MultiMap headers, WebsocketVersion version, String subProtocols, Handler<WebSocket> wsConnect, Handler<Throwable> failureHandler) {
        this.websocketStream(options, headers, version, subProtocols).subscribe(wsConnect, failureHandler);
        return this;
    }

    @Override
    public HttpClient websocket(int port2, String host, String requestURI, MultiMap headers, WebsocketVersion version, String subProtocols, Handler<WebSocket> wsConnect, Handler<Throwable> failureHandler) {
        this.websocketStream(port2, host, requestURI, headers, version, subProtocols).subscribe(wsConnect, failureHandler);
        return this;
    }

    @Override
    public HttpClient websocket(String host, String requestURI, MultiMap headers, WebsocketVersion version, String subProtocols, Handler<WebSocket> wsConnect) {
        return this.websocket(this.options.getDefaultPort(), host, requestURI, headers, version, subProtocols, wsConnect);
    }

    @Override
    public HttpClient websocket(String host, String requestURI, MultiMap headers, WebsocketVersion version, String subProtocols, Handler<WebSocket> wsConnect, Handler<Throwable> failureHandler) {
        return this.websocket(this.options.getDefaultPort(), host, requestURI, headers, version, subProtocols, wsConnect, failureHandler);
    }

    @Override
    public HttpClient websocket(String requestURI, Handler<WebSocket> wsConnect) {
        return this.websocket(this.options.getDefaultPort(), this.options.getDefaultHost(), requestURI, wsConnect);
    }

    @Override
    public HttpClient websocket(String requestURI, Handler<WebSocket> wsConnect, Handler<Throwable> failureHandler) {
        return this.websocket(this.options.getDefaultPort(), this.options.getDefaultHost(), requestURI, wsConnect, failureHandler);
    }

    @Override
    public HttpClient websocket(String requestURI, MultiMap headers, Handler<WebSocket> wsConnect) {
        return this.websocket(this.options.getDefaultPort(), this.options.getDefaultHost(), requestURI, headers, wsConnect);
    }

    @Override
    public HttpClient websocket(String requestURI, MultiMap headers, Handler<WebSocket> wsConnect, Handler<Throwable> failureHandler) {
        return this.websocket(this.options.getDefaultPort(), this.options.getDefaultHost(), requestURI, headers, wsConnect, failureHandler);
    }

    @Override
    public HttpClient websocket(String requestURI, MultiMap headers, WebsocketVersion version, Handler<WebSocket> wsConnect) {
        return this.websocket(this.options.getDefaultPort(), this.options.getDefaultHost(), requestURI, headers, version, wsConnect);
    }

    @Override
    public HttpClient websocket(String requestURI, MultiMap headers, WebsocketVersion version, Handler<WebSocket> wsConnect, Handler<Throwable> failureHandler) {
        return this.websocket(this.options.getDefaultPort(), this.options.getDefaultHost(), requestURI, headers, version, wsConnect, failureHandler);
    }

    @Override
    public HttpClient websocket(String requestURI, MultiMap headers, WebsocketVersion version, String subProtocols, Handler<WebSocket> wsConnect) {
        return this.websocket(this.options.getDefaultPort(), this.options.getDefaultHost(), requestURI, headers, version, subProtocols, wsConnect);
    }

    @Override
    public HttpClient websocket(String requestURI, MultiMap headers, WebsocketVersion version, String subProtocols, Handler<WebSocket> wsConnect, Handler<Throwable> failureHandler) {
        return this.websocket(this.options.getDefaultPort(), this.options.getDefaultHost(), requestURI, headers, version, subProtocols, wsConnect, failureHandler);
    }

    public WebSocketStream websocketStream(RequestOptions options) {
        return this.websocketStream(options, null);
    }

    public WebSocketStream websocketStream(int port2, String host, String requestURI) {
        return this.websocketStream(port2, host, requestURI, null, null);
    }

    public WebSocketStream websocketStream(String host, String requestURI) {
        return this.websocketStream(this.options.getDefaultPort(), host, requestURI);
    }

    public WebSocketStream websocketStream(RequestOptions options, MultiMap headers) {
        return this.websocketStream(options, headers, null);
    }

    public WebSocketStream websocketStream(int port2, String host, String requestURI, MultiMap headers) {
        return this.websocketStream(port2, host, requestURI, headers, null);
    }

    public WebSocketStream websocketStream(String host, String requestURI, MultiMap headers) {
        return this.websocketStream(this.options.getDefaultPort(), host, requestURI, headers);
    }

    public WebSocketStream websocketStream(RequestOptions options, MultiMap headers, WebsocketVersion version) {
        return this.websocketStream(options, headers, version, null);
    }

    public WebSocketStream websocketStream(int port2, String host, String requestURI, MultiMap headers, WebsocketVersion version) {
        return this.websocketStream(port2, host, requestURI, headers, version, null);
    }

    public WebSocketStream websocketStream(String host, String requestURI, MultiMap headers, WebsocketVersion version) {
        return this.websocketStream(this.options.getDefaultPort(), host, requestURI, headers, version);
    }

    public WebSocketStream websocketStreamAbs(String url, MultiMap headers, WebsocketVersion version, String subProtocols) {
        URI uri;
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        String scheme = uri.getScheme();
        if (!"ws".equals(scheme) && !"wss".equals(scheme)) {
            throw new IllegalArgumentException("Scheme: " + scheme);
        }
        boolean ssl = scheme.length() == 3;
        int port2 = uri.getPort();
        if (port2 == -1) {
            port2 = ssl ? 443 : 80;
        }
        StringBuilder relativeUri = new StringBuilder();
        if (uri.getRawPath() != null) {
            relativeUri.append(uri.getRawPath());
        }
        if (uri.getRawQuery() != null) {
            relativeUri.append('?').append(uri.getRawQuery());
        }
        if (uri.getRawFragment() != null) {
            relativeUri.append('#').append(uri.getRawFragment());
        }
        RequestOptions options = new RequestOptions().setHost(uri.getHost()).setPort(port2).setSsl(ssl).setURI(relativeUri.toString());
        return this.websocketStream(options, headers, version, subProtocols);
    }

    public WebSocketStream websocketStream(RequestOptions options, MultiMap headers, WebsocketVersion version, String subProtocols) {
        return new WebSocketStream(options.getPort(), options.getHost(), options.getURI(), headers, version, subProtocols, options.isSsl());
    }

    public WebSocketStream websocketStream(int port2, String host, String requestURI, MultiMap headers, WebsocketVersion version, String subProtocols) {
        return new WebSocketStream(port2, host, requestURI, headers, version, subProtocols, null);
    }

    public WebSocketStream websocketStream(String host, String requestURI, MultiMap headers, WebsocketVersion version, String subProtocols) {
        return this.websocketStream(this.options.getDefaultPort(), host, requestURI, headers, version, subProtocols);
    }

    public WebSocketStream websocketStream(String requestURI) {
        return this.websocketStream(this.options.getDefaultPort(), this.options.getDefaultHost(), requestURI);
    }

    public WebSocketStream websocketStream(String requestURI, MultiMap headers) {
        return this.websocketStream(this.options.getDefaultPort(), this.options.getDefaultHost(), requestURI, headers);
    }

    public WebSocketStream websocketStream(String requestURI, MultiMap headers, WebsocketVersion version) {
        return this.websocketStream(this.options.getDefaultPort(), this.options.getDefaultHost(), requestURI, headers, version);
    }

    public WebSocketStream websocketStream(String requestURI, MultiMap headers, WebsocketVersion version, String subProtocols) {
        return this.websocketStream(this.options.getDefaultPort(), this.options.getDefaultHost(), requestURI, headers, version, subProtocols);
    }

    @Override
    public HttpClientRequest requestAbs(HttpMethod method, String absoluteURI, Handler<HttpClientResponse> responseHandler) {
        Objects.requireNonNull(responseHandler, "no null responseHandler accepted");
        return this.requestAbs(method, absoluteURI).handler((Handler)responseHandler);
    }

    @Override
    public HttpClientRequest get(RequestOptions options) {
        return this.request(HttpMethod.GET, options);
    }

    @Override
    public HttpClientRequest request(HttpMethod method, int port2, String host, String requestURI, Handler<HttpClientResponse> responseHandler) {
        Objects.requireNonNull(responseHandler, "no null responseHandler accepted");
        return this.request(method, port2, host, requestURI).handler((Handler)responseHandler);
    }

    @Override
    public HttpClientRequest request(HttpMethod method, String host, String requestURI, Handler<HttpClientResponse> responseHandler) {
        return this.request(method, this.options.getDefaultPort(), host, requestURI, responseHandler);
    }

    @Override
    public HttpClientRequest request(HttpMethod method, String requestURI) {
        return this.request(method, this.options.getDefaultPort(), this.options.getDefaultHost(), requestURI);
    }

    @Override
    public HttpClientRequest request(HttpMethod method, String requestURI, Handler<HttpClientResponse> responseHandler) {
        return this.request(method, this.options.getDefaultPort(), this.options.getDefaultHost(), requestURI, responseHandler);
    }

    @Override
    public HttpClientRequest requestAbs(HttpMethod method, String absoluteURI) {
        URL url = this.parseUrl(absoluteURI);
        Boolean ssl = false;
        int port2 = url.getPort();
        String relativeUri = url.getPath().isEmpty() ? "/" + url.getFile() : url.getFile();
        String protocol = url.getProtocol();
        if ("ftp".equals(protocol)) {
            if (port2 == -1) {
                port2 = 21;
            }
        } else {
            char chend = protocol.charAt(protocol.length() - 1);
            if (chend == 'p') {
                if (port2 == -1) {
                    port2 = 80;
                }
            } else if (chend == 's') {
                ssl = true;
                if (port2 == -1) {
                    port2 = 443;
                }
            }
        }
        return this.createRequest(method, protocol, url.getHost(), port2, ssl, relativeUri, null);
    }

    @Override
    public HttpClientRequest request(HttpMethod method, int port2, String host, String requestURI) {
        return this.createRequest(method, host, port2, null, requestURI, null);
    }

    @Override
    public HttpClientRequest request(HttpMethod method, RequestOptions options, Handler<HttpClientResponse> responseHandler) {
        return this.request(method, options).handler((Handler)responseHandler);
    }

    @Override
    public HttpClientRequest request(HttpMethod method, RequestOptions options) {
        return this.createRequest(method, options.getHost(), options.getPort(), options.isSsl(), options.getURI(), null);
    }

    @Override
    public HttpClientRequest request(HttpMethod method, String host, String requestURI) {
        return this.request(method, this.options.getDefaultPort(), host, requestURI);
    }

    @Override
    public HttpClientRequest get(int port2, String host, String requestURI) {
        return this.request(HttpMethod.GET, port2, host, requestURI);
    }

    @Override
    public HttpClientRequest get(String host, String requestURI) {
        return this.get(this.options.getDefaultPort(), host, requestURI);
    }

    @Override
    public HttpClientRequest get(RequestOptions options, Handler<HttpClientResponse> responseHandler) {
        return this.request(HttpMethod.GET, options, responseHandler);
    }

    @Override
    public HttpClientRequest get(int port2, String host, String requestURI, Handler<HttpClientResponse> responseHandler) {
        return this.request(HttpMethod.GET, port2, host, requestURI, responseHandler);
    }

    @Override
    public HttpClientRequest get(String host, String requestURI, Handler<HttpClientResponse> responseHandler) {
        return this.get(this.options.getDefaultPort(), host, requestURI, responseHandler);
    }

    @Override
    public HttpClientRequest get(String requestURI) {
        return this.request(HttpMethod.GET, requestURI);
    }

    @Override
    public HttpClientRequest get(String requestURI, Handler<HttpClientResponse> responseHandler) {
        return this.request(HttpMethod.GET, requestURI, responseHandler);
    }

    @Override
    public HttpClientRequest getAbs(String absoluteURI) {
        return this.requestAbs(HttpMethod.GET, absoluteURI);
    }

    @Override
    public HttpClientRequest getAbs(String absoluteURI, Handler<HttpClientResponse> responseHandler) {
        return this.requestAbs(HttpMethod.GET, absoluteURI, responseHandler);
    }

    @Override
    public HttpClient getNow(RequestOptions options, Handler<HttpClientResponse> responseHandler) {
        return this.requestNow(HttpMethod.GET, options, responseHandler);
    }

    @Override
    public HttpClient getNow(int port2, String host, String requestURI, Handler<HttpClientResponse> responseHandler) {
        this.get(port2, host, requestURI, responseHandler).end();
        return this;
    }

    @Override
    public HttpClient getNow(String host, String requestURI, Handler<HttpClientResponse> responseHandler) {
        return this.getNow(this.options.getDefaultPort(), host, requestURI, responseHandler);
    }

    @Override
    public HttpClient getNow(String requestURI, Handler<HttpClientResponse> responseHandler) {
        this.get(requestURI, responseHandler).end();
        return this;
    }

    @Override
    public HttpClientRequest post(RequestOptions options) {
        return this.request(HttpMethod.POST, options);
    }

    @Override
    public HttpClientRequest post(int port2, String host, String requestURI) {
        return this.request(HttpMethod.POST, port2, host, requestURI);
    }

    @Override
    public HttpClientRequest post(String host, String requestURI) {
        return this.post(this.options.getDefaultPort(), host, requestURI);
    }

    @Override
    public HttpClientRequest post(RequestOptions options, Handler<HttpClientResponse> responseHandler) {
        return this.request(HttpMethod.POST, options, responseHandler);
    }

    @Override
    public HttpClientRequest post(int port2, String host, String requestURI, Handler<HttpClientResponse> responseHandler) {
        return this.request(HttpMethod.POST, port2, host, requestURI, responseHandler);
    }

    @Override
    public HttpClientRequest post(String host, String requestURI, Handler<HttpClientResponse> responseHandler) {
        return this.post(this.options.getDefaultPort(), host, requestURI, responseHandler);
    }

    @Override
    public HttpClientRequest post(String requestURI) {
        return this.request(HttpMethod.POST, requestURI);
    }

    @Override
    public HttpClientRequest post(String requestURI, Handler<HttpClientResponse> responseHandler) {
        return this.request(HttpMethod.POST, requestURI, responseHandler);
    }

    @Override
    public HttpClientRequest postAbs(String absoluteURI) {
        return this.requestAbs(HttpMethod.POST, absoluteURI);
    }

    @Override
    public HttpClientRequest postAbs(String absoluteURI, Handler<HttpClientResponse> responseHandler) {
        return this.requestAbs(HttpMethod.POST, absoluteURI, responseHandler);
    }

    @Override
    public HttpClientRequest head(RequestOptions options) {
        return this.request(HttpMethod.HEAD, options);
    }

    @Override
    public HttpClientRequest head(int port2, String host, String requestURI) {
        return this.request(HttpMethod.HEAD, port2, host, requestURI);
    }

    @Override
    public HttpClientRequest head(String host, String requestURI) {
        return this.head(this.options.getDefaultPort(), host, requestURI);
    }

    @Override
    public HttpClientRequest head(RequestOptions options, Handler<HttpClientResponse> responseHandler) {
        return this.request(HttpMethod.HEAD, options, responseHandler);
    }

    @Override
    public HttpClientRequest head(int port2, String host, String requestURI, Handler<HttpClientResponse> responseHandler) {
        return this.request(HttpMethod.HEAD, port2, host, requestURI, responseHandler);
    }

    @Override
    public HttpClientRequest head(String host, String requestURI, Handler<HttpClientResponse> responseHandler) {
        return this.head(this.options.getDefaultPort(), host, requestURI, responseHandler);
    }

    @Override
    public HttpClientRequest head(String requestURI) {
        return this.request(HttpMethod.HEAD, requestURI);
    }

    @Override
    public HttpClientRequest head(String requestURI, Handler<HttpClientResponse> responseHandler) {
        return this.request(HttpMethod.HEAD, requestURI, responseHandler);
    }

    @Override
    public HttpClientRequest headAbs(String absoluteURI) {
        return this.requestAbs(HttpMethod.HEAD, absoluteURI);
    }

    @Override
    public HttpClientRequest headAbs(String absoluteURI, Handler<HttpClientResponse> responseHandler) {
        return this.requestAbs(HttpMethod.HEAD, absoluteURI, responseHandler);
    }

    @Override
    public HttpClient headNow(RequestOptions options, Handler<HttpClientResponse> responseHandler) {
        return this.requestNow(HttpMethod.HEAD, options, responseHandler);
    }

    @Override
    public HttpClient headNow(int port2, String host, String requestURI, Handler<HttpClientResponse> responseHandler) {
        this.head(port2, host, requestURI, responseHandler).end();
        return this;
    }

    @Override
    public HttpClient headNow(String host, String requestURI, Handler<HttpClientResponse> responseHandler) {
        return this.headNow(this.options.getDefaultPort(), host, requestURI, responseHandler);
    }

    @Override
    public HttpClient headNow(String requestURI, Handler<HttpClientResponse> responseHandler) {
        this.head(requestURI, responseHandler).end();
        return this;
    }

    @Override
    public HttpClientRequest options(RequestOptions options) {
        return this.request(HttpMethod.OPTIONS, options);
    }

    @Override
    public HttpClientRequest options(int port2, String host, String requestURI) {
        return this.request(HttpMethod.OPTIONS, port2, host, requestURI);
    }

    @Override
    public HttpClientRequest options(String host, String requestURI) {
        return this.options(this.options.getDefaultPort(), host, requestURI);
    }

    @Override
    public HttpClientRequest options(RequestOptions options, Handler<HttpClientResponse> responseHandler) {
        return this.request(HttpMethod.OPTIONS, options, responseHandler);
    }

    @Override
    public HttpClientRequest options(int port2, String host, String requestURI, Handler<HttpClientResponse> responseHandler) {
        return this.request(HttpMethod.OPTIONS, port2, host, requestURI, responseHandler);
    }

    @Override
    public HttpClientRequest options(String host, String requestURI, Handler<HttpClientResponse> responseHandler) {
        return this.options(this.options.getDefaultPort(), host, requestURI, responseHandler);
    }

    @Override
    public HttpClientRequest options(String requestURI) {
        return this.request(HttpMethod.OPTIONS, requestURI);
    }

    @Override
    public HttpClientRequest options(String requestURI, Handler<HttpClientResponse> responseHandler) {
        return this.request(HttpMethod.OPTIONS, requestURI, responseHandler);
    }

    @Override
    public HttpClientRequest optionsAbs(String absoluteURI) {
        return this.requestAbs(HttpMethod.OPTIONS, absoluteURI);
    }

    @Override
    public HttpClientRequest optionsAbs(String absoluteURI, Handler<HttpClientResponse> responseHandler) {
        return this.requestAbs(HttpMethod.OPTIONS, absoluteURI, responseHandler);
    }

    @Override
    public HttpClient optionsNow(RequestOptions options, Handler<HttpClientResponse> responseHandler) {
        return this.requestNow(HttpMethod.OPTIONS, options, responseHandler);
    }

    @Override
    public HttpClient optionsNow(int port2, String host, String requestURI, Handler<HttpClientResponse> responseHandler) {
        this.options(port2, host, requestURI, responseHandler).end();
        return this;
    }

    @Override
    public HttpClient optionsNow(String host, String requestURI, Handler<HttpClientResponse> responseHandler) {
        return this.optionsNow(this.options.getDefaultPort(), host, requestURI, responseHandler);
    }

    @Override
    public HttpClient optionsNow(String requestURI, Handler<HttpClientResponse> responseHandler) {
        this.options(requestURI, responseHandler).end();
        return this;
    }

    @Override
    public HttpClientRequest put(RequestOptions options) {
        return this.request(HttpMethod.PUT, options);
    }

    @Override
    public HttpClientRequest put(int port2, String host, String requestURI) {
        return this.request(HttpMethod.PUT, port2, host, requestURI);
    }

    @Override
    public HttpClientRequest put(String host, String requestURI) {
        return this.put(this.options.getDefaultPort(), host, requestURI);
    }

    @Override
    public HttpClientRequest put(RequestOptions options, Handler<HttpClientResponse> responseHandler) {
        return this.request(HttpMethod.PUT, options, responseHandler);
    }

    @Override
    public HttpClientRequest put(int port2, String host, String requestURI, Handler<HttpClientResponse> responseHandler) {
        return this.request(HttpMethod.PUT, port2, host, requestURI, responseHandler);
    }

    @Override
    public HttpClientRequest put(String host, String requestURI, Handler<HttpClientResponse> responseHandler) {
        return this.put(this.options.getDefaultPort(), host, requestURI, responseHandler);
    }

    @Override
    public HttpClientRequest put(String requestURI) {
        return this.request(HttpMethod.PUT, requestURI);
    }

    @Override
    public HttpClientRequest put(String requestURI, Handler<HttpClientResponse> responseHandler) {
        return this.request(HttpMethod.PUT, requestURI, responseHandler);
    }

    @Override
    public HttpClientRequest putAbs(String absoluteURI) {
        return this.requestAbs(HttpMethod.PUT, absoluteURI);
    }

    @Override
    public HttpClientRequest putAbs(String absoluteURI, Handler<HttpClientResponse> responseHandler) {
        return this.requestAbs(HttpMethod.PUT, absoluteURI, responseHandler);
    }

    @Override
    public HttpClientRequest delete(RequestOptions options) {
        return this.request(HttpMethod.DELETE, options);
    }

    @Override
    public HttpClientRequest delete(int port2, String host, String requestURI) {
        return this.request(HttpMethod.DELETE, port2, host, requestURI);
    }

    @Override
    public HttpClientRequest delete(String host, String requestURI) {
        return this.delete(this.options.getDefaultPort(), host, requestURI);
    }

    @Override
    public HttpClientRequest delete(RequestOptions options, Handler<HttpClientResponse> responseHandler) {
        return this.request(HttpMethod.DELETE, options, responseHandler);
    }

    @Override
    public HttpClientRequest delete(int port2, String host, String requestURI, Handler<HttpClientResponse> responseHandler) {
        return this.request(HttpMethod.DELETE, port2, host, requestURI, responseHandler);
    }

    @Override
    public HttpClientRequest delete(String host, String requestURI, Handler<HttpClientResponse> responseHandler) {
        return this.delete(this.options.getDefaultPort(), host, requestURI, responseHandler);
    }

    @Override
    public HttpClientRequest delete(String requestURI) {
        return this.request(HttpMethod.DELETE, requestURI);
    }

    @Override
    public HttpClientRequest delete(String requestURI, Handler<HttpClientResponse> responseHandler) {
        return this.request(HttpMethod.DELETE, requestURI, responseHandler);
    }

    @Override
    public HttpClientRequest deleteAbs(String absoluteURI) {
        return this.requestAbs(HttpMethod.DELETE, absoluteURI);
    }

    @Override
    public HttpClientRequest deleteAbs(String absoluteURI, Handler<HttpClientResponse> responseHandler) {
        return this.requestAbs(HttpMethod.DELETE, absoluteURI, responseHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        HttpClientImpl httpClientImpl = this;
        synchronized (httpClientImpl) {
            this.checkClosed();
            this.closed = true;
        }
        if (this.creatingContext != null) {
            this.creatingContext.removeCloseHook(this.closeHook);
        }
        this.websocketCM.close();
        this.httpCM.close();
        if (this.metrics != null) {
            this.metrics.close();
        }
    }

    @Override
    public boolean isMetricsEnabled() {
        return this.getMetrics() != null;
    }

    @Override
    public Metrics getMetrics() {
        return this.metrics;
    }

    @Override
    public HttpClient redirectHandler(Function<HttpClientResponse, Future<HttpClientRequest>> handler) {
        if (handler == null) {
            handler = this.DEFAULT_HANDLER;
        }
        this.redirectHandler = handler;
        return this;
    }

    @Override
    public Function<HttpClientResponse, Future<HttpClientRequest>> redirectHandler() {
        return this.redirectHandler;
    }

    public HttpClientOptions getOptions() {
        return this.options;
    }

    private void getConnectionForWebsocket(boolean ssl, int port2, String host, Handler<Http1xClientConnection> handler, Handler<Throwable> connectionExceptionHandler) {
        ContextImpl ctx = this.vertx.getOrCreateContext();
        this.websocketCM.getConnection(host, ssl, port2, host, ar -> {
            if (ar.succeeded()) {
                HttpClientConnection conn = (HttpClientConnection)ar.result();
                conn.getContext().executeFromIO(() -> handler.handle((Http1xClientConnection)conn));
            } else {
                ctx.executeFromIO(() -> connectionExceptionHandler.handle(ar.cause()));
            }
        });
    }

    void getConnectionForRequest(String peerHost, boolean ssl, int port2, String host, Handler<AsyncResult<HttpClientConnection>> handler) {
        this.httpCM.getConnection(peerHost, ssl, port2, host, handler);
    }

    public VertxInternal getVertx() {
        return this.vertx;
    }

    SSLHelper getSslHelper() {
        return this.sslHelper;
    }

    private URL parseUrl(String surl) {
        try {
            return new URL(surl);
        }
        catch (MalformedURLException e) {
            throw new VertxException("Invalid url: " + surl, e);
        }
    }

    private HttpClient requestNow(HttpMethod method, RequestOptions options, Handler<HttpClientResponse> responseHandler) {
        this.createRequest(method, options.getHost(), options.getPort(), options.isSsl(), options.getURI(), null).handler((Handler)responseHandler).end();
        return this;
    }

    private HttpClientRequest createRequest(HttpMethod method, String host, int port2, Boolean ssl, String relativeURI, MultiMap headers) {
        return this.createRequest(method, ssl == null || ssl == false ? "http" : "https", host, port2, ssl, relativeURI, headers);
    }

    private HttpClientRequest createRequest(HttpMethod method, String protocol, String host, int port2, Boolean ssl, String relativeURI, MultiMap headers) {
        HttpClientRequestImpl req;
        boolean useProxy;
        boolean useSSL;
        Objects.requireNonNull(method, "no null method accepted");
        Objects.requireNonNull(protocol, "no null protocol accepted");
        Objects.requireNonNull(host, "no null host accepted");
        Objects.requireNonNull(relativeURI, "no null relativeURI accepted");
        boolean useAlpn = this.options.isUseAlpn();
        boolean bl = useSSL = ssl != null ? ssl.booleanValue() : this.options.isSsl();
        if (!useAlpn && useSSL && this.options.getProtocolVersion() == HttpVersion.HTTP_2) {
            throw new IllegalArgumentException("Must enable ALPN when using H2");
        }
        this.checkClosed();
        boolean bl2 = useProxy = !useSSL && this.proxyType == ProxyType.HTTP;
        if (useProxy) {
            int defaultPort = protocol.equals("ftp") ? 21 : 80;
            String addPort = port2 != -1 && port2 != defaultPort ? ":" + port2 : "";
            relativeURI = protocol + "://" + host + addPort + relativeURI;
            ProxyOptions proxyOptions = this.options.getProxyOptions();
            if (proxyOptions.getUsername() != null && proxyOptions.getPassword() != null) {
                if (headers == null) {
                    headers = MultiMap.caseInsensitiveMultiMap();
                }
                headers.add("Proxy-Authorization", "Basic " + Base64.getEncoder().encodeToString((proxyOptions.getUsername() + ":" + proxyOptions.getPassword()).getBytes()));
            }
            req = new HttpClientRequestImpl(this, useSSL, method, proxyOptions.getHost(), proxyOptions.getPort(), relativeURI, this.vertx);
            req.setHost(host + addPort);
        } else {
            req = new HttpClientRequestImpl(this, useSSL, method, host, port2, relativeURI, this.vertx);
        }
        if (headers != null) {
            req.headers().setAll(headers);
        }
        return req;
    }

    private synchronized void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("Client is closed");
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    private class WebSocketStream
    implements ReadStream<WebSocket> {
        final int port;
        final String host;
        final String requestURI;
        final MultiMap headers;
        final WebsocketVersion version;
        final String subProtocols;
        private Handler<WebSocket> handler;
        private Handler<Throwable> exceptionHandler;
        private Handler<Void> endHandler;
        private Boolean ssl;

        WebSocketStream(int port2, String host, String requestURI, MultiMap headers, WebsocketVersion version, String subProtocols, Boolean ssl) {
            this.port = port2;
            this.host = host;
            this.requestURI = requestURI;
            this.headers = headers;
            this.version = version;
            this.subProtocols = subProtocols;
            this.ssl = ssl;
        }

        void subscribe(Handler<WebSocket> completionHandler, Handler<Throwable> failureHandler) {
            Future fut = Future.future();
            fut.setHandler(ar -> {
                if (ar.succeeded()) {
                    completionHandler.handle((WebSocket)ar.result());
                } else {
                    failureHandler.handle(ar.cause());
                }
            });
            this.exceptionHandler(fut::tryFail);
            this.handler(fut::tryComplete);
        }

        @Override
        public synchronized ReadStream<WebSocket> exceptionHandler(Handler<Throwable> handler) {
            this.exceptionHandler = handler;
            return this;
        }

        @Override
        public synchronized ReadStream<WebSocket> handler(Handler<WebSocket> handler) {
            if (this.handler == null && handler != null) {
                Handler<WebSocket> wsConnect;
                this.handler = handler;
                HttpClientImpl.this.checkClosed();
                ContextImpl context = HttpClientImpl.this.vertx.getOrCreateContext();
                Handler<Throwable> connectionExceptionHandler = this.exceptionHandler == null ? log::error : this.exceptionHandler;
                if (this.endHandler != null) {
                    Handler<Void> endCallback = this.endHandler;
                    wsConnect = ws -> {
                        handler.handle((WebSocket)ws);
                        endCallback.handle(null);
                    };
                } else {
                    wsConnect = handler;
                }
                HttpClientImpl.this.getConnectionForWebsocket(this.ssl != null ? this.ssl.booleanValue() : HttpClientImpl.this.options.isSsl(), this.port, this.host, conn -> {
                    conn.exceptionHandler((Handler)connectionExceptionHandler);
                    conn.toWebSocket(this.requestURI, this.headers, this.version, this.subProtocols, HttpClientImpl.this.options.getMaxWebsocketFrameSize(), wsConnect);
                }, connectionExceptionHandler);
            }
            return this;
        }

        @Override
        public synchronized ReadStream<WebSocket> endHandler(Handler<Void> endHandler) {
            this.endHandler = endHandler;
            return this;
        }

        @Override
        public ReadStream<WebSocket> pause() {
            return this;
        }

        @Override
        public ReadStream<WebSocket> resume() {
            return this;
        }
    }
}

