/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.http.impl;

import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import znaishaded.io.netty.bootstrap.ServerBootstrap;
import znaishaded.io.netty.buffer.ByteBuf;
import znaishaded.io.netty.buffer.Unpooled;
import znaishaded.io.netty.channel.Channel;
import znaishaded.io.netty.channel.ChannelFutureListener;
import znaishaded.io.netty.channel.ChannelHandler;
import znaishaded.io.netty.channel.ChannelHandlerContext;
import znaishaded.io.netty.channel.ChannelInboundHandlerAdapter;
import znaishaded.io.netty.channel.ChannelInitializer;
import znaishaded.io.netty.channel.ChannelPipeline;
import znaishaded.io.netty.channel.group.ChannelGroup;
import znaishaded.io.netty.channel.group.ChannelGroupFuture;
import znaishaded.io.netty.channel.group.DefaultChannelGroup;
import znaishaded.io.netty.handler.codec.http.DefaultFullHttpRequest;
import znaishaded.io.netty.handler.codec.http.DefaultFullHttpResponse;
import znaishaded.io.netty.handler.codec.http.FullHttpRequest;
import znaishaded.io.netty.handler.codec.http.HttpContent;
import znaishaded.io.netty.handler.codec.http.HttpContentDecompressor;
import znaishaded.io.netty.handler.codec.http.HttpHeaderNames;
import znaishaded.io.netty.handler.codec.http.HttpHeaderValues;
import znaishaded.io.netty.handler.codec.http.HttpMethod;
import znaishaded.io.netty.handler.codec.http.HttpRequest;
import znaishaded.io.netty.handler.codec.http.HttpRequestDecoder;
import znaishaded.io.netty.handler.codec.http.HttpResponseStatus;
import znaishaded.io.netty.handler.codec.http.LastHttpContent;
import znaishaded.io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import znaishaded.io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import znaishaded.io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import znaishaded.io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import znaishaded.io.netty.handler.codec.http.websocketx.WebSocketVersion;
import znaishaded.io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import znaishaded.io.netty.handler.codec.http2.DefaultHttp2Headers;
import znaishaded.io.netty.handler.codec.http2.DefaultHttp2HeadersFrame;
import znaishaded.io.netty.handler.codec.http2.Http2CodecUtil;
import znaishaded.io.netty.handler.codec.http2.Http2ConnectionHandler;
import znaishaded.io.netty.handler.codec.http2.Http2Headers;
import znaishaded.io.netty.handler.codec.http2.Http2Settings;
import znaishaded.io.netty.handler.logging.LoggingHandler;
import znaishaded.io.netty.handler.ssl.SslHandler;
import znaishaded.io.netty.handler.stream.ChunkedWriteHandler;
import znaishaded.io.netty.handler.timeout.IdleState;
import znaishaded.io.netty.handler.timeout.IdleStateEvent;
import znaishaded.io.netty.handler.timeout.IdleStateHandler;
import znaishaded.io.netty.util.CharsetUtil;
import znaishaded.io.netty.util.concurrent.GenericFutureListener;
import znaishaded.io.netty.util.concurrent.GlobalEventExecutor;
import znaishaded.io.vertx.core.AsyncResult;
import znaishaded.io.vertx.core.Closeable;
import znaishaded.io.vertx.core.Future;
import znaishaded.io.vertx.core.Handler;
import znaishaded.io.vertx.core.buffer.Buffer;
import znaishaded.io.vertx.core.http.HttpConnection;
import znaishaded.io.vertx.core.http.HttpHeaders;
import znaishaded.io.vertx.core.http.HttpServer;
import znaishaded.io.vertx.core.http.HttpServerOptions;
import znaishaded.io.vertx.core.http.HttpServerRequest;
import znaishaded.io.vertx.core.http.HttpVersion;
import znaishaded.io.vertx.core.http.ServerWebSocket;
import znaishaded.io.vertx.core.http.impl.HeadersAdaptor;
import znaishaded.io.vertx.core.http.impl.Http1xOrH2CHandler;
import znaishaded.io.vertx.core.http.impl.Http1xServerConnection;
import znaishaded.io.vertx.core.http.impl.Http1xServerHandler;
import znaishaded.io.vertx.core.http.impl.Http2ServerConnection;
import znaishaded.io.vertx.core.http.impl.HttpChunkContentCompressor;
import znaishaded.io.vertx.core.http.impl.HttpHandlers;
import znaishaded.io.vertx.core.http.impl.HttpUtils;
import znaishaded.io.vertx.core.http.impl.ServerWebSocketImpl;
import znaishaded.io.vertx.core.http.impl.VertxHttp2ConnectionHandler;
import znaishaded.io.vertx.core.http.impl.VertxHttp2ConnectionHandlerBuilder;
import znaishaded.io.vertx.core.http.impl.VertxHttpResponseEncoder;
import znaishaded.io.vertx.core.http.impl.cgbystrom.FlashPolicyHandler;
import znaishaded.io.vertx.core.http.impl.ws.WebSocketFrameInternal;
import znaishaded.io.vertx.core.impl.ContextImpl;
import znaishaded.io.vertx.core.impl.VertxInternal;
import znaishaded.io.vertx.core.logging.Logger;
import znaishaded.io.vertx.core.logging.LoggerFactory;
import znaishaded.io.vertx.core.net.SocketAddress;
import znaishaded.io.vertx.core.net.impl.AsyncResolveConnectHelper;
import znaishaded.io.vertx.core.net.impl.ConnectionBase;
import znaishaded.io.vertx.core.net.impl.HandlerHolder;
import znaishaded.io.vertx.core.net.impl.HandlerManager;
import znaishaded.io.vertx.core.net.impl.SSLHelper;
import znaishaded.io.vertx.core.net.impl.ServerID;
import znaishaded.io.vertx.core.net.impl.SocketAddressImpl;
import znaishaded.io.vertx.core.net.impl.VertxEventLoopGroup;
import znaishaded.io.vertx.core.net.impl.VertxHandler;
import znaishaded.io.vertx.core.net.impl.VertxSniHandler;
import znaishaded.io.vertx.core.spi.metrics.HttpServerMetrics;
import znaishaded.io.vertx.core.spi.metrics.Metrics;
import znaishaded.io.vertx.core.spi.metrics.MetricsProvider;
import znaishaded.io.vertx.core.spi.metrics.VertxMetrics;
import znaishaded.io.vertx.core.streams.ReadStream;

public class HttpServerImpl
implements HttpServer,
Closeable,
MetricsProvider {
    private static final Logger log = LoggerFactory.getLogger(HttpServerImpl.class);
    private static final Handler<Throwable> DEFAULT_EXCEPTION_HANDLER = t -> log.trace((Object)"Connection failure", (Throwable)t);
    private static final String FLASH_POLICY_HANDLER_PROP_NAME = "vertx.flashPolicyHandler";
    private static final boolean USE_FLASH_POLICY_HANDLER = Boolean.getBoolean("vertx.flashPolicyHandler");
    private static final String DISABLE_WEBSOCKETS_PROP_NAME = "vertx.disableWebsockets";
    private static final boolean DISABLE_WEBSOCKETS = Boolean.getBoolean("vertx.disableWebsockets");
    private static final String DISABLE_H2C_PROP_NAME = "vertx.disableH2c";
    private final boolean DISABLE_H2C = Boolean.getBoolean("vertx.disableH2c");
    private final HttpServerOptions options;
    private final VertxInternal vertx;
    private final SSLHelper sslHelper;
    private final ContextImpl creatingContext;
    private final Map<Channel, ConnectionBase> connectionMap = new ConcurrentHashMap<Channel, ConnectionBase>();
    private final VertxEventLoopGroup availableWorkers = new VertxEventLoopGroup();
    private final HandlerManager<HttpHandlers> httpHandlerMgr = new HandlerManager(this.availableWorkers);
    private final HttpStreamHandler<ServerWebSocket> wsStream = new HttpStreamHandler();
    private final HttpStreamHandler<HttpServerRequest> requestStream = new HttpStreamHandler();
    private Handler<HttpConnection> connectionHandler;
    private String serverOrigin;
    private ChannelGroup serverChannelGroup;
    private volatile boolean listening;
    private AsyncResolveConnectHelper bindFuture;
    private ServerID id;
    private HttpServerImpl actualServer;
    private volatile int actualPort;
    private ContextImpl listenContext;
    private HttpServerMetrics metrics;
    private boolean logEnabled;
    private Handler<Throwable> exceptionHandler;

    public HttpServerImpl(VertxInternal vertx, HttpServerOptions options) {
        this.options = new HttpServerOptions(options);
        this.vertx = vertx;
        this.creatingContext = vertx.getContext();
        if (this.creatingContext != null) {
            if (this.creatingContext.isMultiThreadedWorkerContext()) {
                throw new IllegalStateException("Cannot use HttpServer in a multi-threaded worker verticle");
            }
            this.creatingContext.addCloseHook(this);
        }
        this.sslHelper = new SSLHelper(options, options.getKeyCertOptions(), options.getTrustOptions());
        this.logEnabled = options.getLogActivity();
    }

    @Override
    public synchronized HttpServer requestHandler(Handler<HttpServerRequest> handler) {
        this.requestStream.handler(handler);
        return this;
    }

    @Override
    public ReadStream<HttpServerRequest> requestStream() {
        return this.requestStream;
    }

    @Override
    public HttpServer websocketHandler(Handler<ServerWebSocket> handler) {
        this.websocketStream().handler(handler);
        return this;
    }

    @Override
    public Handler<HttpServerRequest> requestHandler() {
        return this.requestStream.handler();
    }

    @Override
    public synchronized HttpServer connectionHandler(Handler<HttpConnection> handler) {
        if (this.listening) {
            throw new IllegalStateException("Please set handler before server is listening");
        }
        this.connectionHandler = handler;
        return this;
    }

    @Override
    public synchronized HttpServer exceptionHandler(Handler<Throwable> handler) {
        if (this.listening) {
            throw new IllegalStateException("Please set handler before server is listening");
        }
        this.exceptionHandler = handler;
        return this;
    }

    @Override
    public Handler<ServerWebSocket> websocketHandler() {
        return this.wsStream.handler();
    }

    @Override
    public ReadStream<ServerWebSocket> websocketStream() {
        return this.wsStream;
    }

    @Override
    public HttpServer listen() {
        return this.listen(this.options.getPort(), this.options.getHost(), null);
    }

    @Override
    public HttpServer listen(Handler<AsyncResult<HttpServer>> listenHandler) {
        return this.listen(this.options.getPort(), this.options.getHost(), listenHandler);
    }

    @Override
    public HttpServer listen(int port2, String host) {
        return this.listen(port2, host, null);
    }

    @Override
    public HttpServer listen(int port2) {
        return this.listen(port2, "0.0.0.0", null);
    }

    @Override
    public HttpServer listen(int port2, Handler<AsyncResult<HttpServer>> listenHandler) {
        return this.listen(port2, "0.0.0.0", listenHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized HttpServer listen(int port2, String host, Handler<AsyncResult<HttpServer>> listenHandler) {
        if (this.requestStream.handler() == null && this.wsStream.handler() == null) {
            throw new IllegalStateException("Set request or websocket handler first");
        }
        if (this.listening) {
            throw new IllegalStateException("Already listening");
        }
        this.listenContext = this.vertx.getOrCreateContext();
        this.listening = true;
        this.serverOrigin = (this.options.isSsl() ? "https" : "http") + "://" + host + ":" + port2;
        List<HttpVersion> applicationProtocols = this.options.getAlpnVersions();
        if (this.listenContext.isWorkerContext()) {
            applicationProtocols = applicationProtocols.stream().filter(v -> v != HttpVersion.HTTP_2).collect(Collectors.toList());
        }
        this.sslHelper.setApplicationProtocols(applicationProtocols);
        Map<ServerID, HttpServerImpl> map = this.vertx.sharedHttpServers();
        synchronized (map) {
            this.actualPort = port2;
            this.id = new ServerID(port2, host);
            HttpServerImpl shared = this.vertx.sharedHttpServers().get(this.id);
            if (shared == null || port2 == 0) {
                this.serverChannelGroup = new DefaultChannelGroup("vertx-acceptor-channels", GlobalEventExecutor.INSTANCE);
                ServerBootstrap bootstrap = new ServerBootstrap();
                bootstrap.group(this.vertx.getAcceptorEventLoopGroup(), this.availableWorkers);
                this.applyConnectionOptions(bootstrap);
                this.sslHelper.validate(this.vertx);
                bootstrap.childHandler(new ChannelInitializer<Channel>(){

                    @Override
                    protected void initChannel(final Channel ch) throws Exception {
                        if (HttpServerImpl.this.requestStream.isPaused() || HttpServerImpl.this.wsStream.isPaused()) {
                            ch.close();
                            return;
                        }
                        final ChannelPipeline pipeline = ch.pipeline();
                        if (HttpServerImpl.this.sslHelper.isSSL()) {
                            znaishaded.io.netty.util.concurrent.Future<Channel> handshakeFuture;
                            if (HttpServerImpl.this.options.isSni()) {
                                VertxSniHandler sniHandler = new VertxSniHandler(HttpServerImpl.this.sslHelper, HttpServerImpl.this.vertx);
                                pipeline.addLast(sniHandler);
                                handshakeFuture = sniHandler.handshakeFuture();
                            } else {
                                SslHandler handler = new SslHandler(HttpServerImpl.this.sslHelper.createEngine(HttpServerImpl.this.vertx));
                                pipeline.addLast("ssl", (ChannelHandler)handler);
                                handshakeFuture = handler.handshakeFuture();
                            }
                            handshakeFuture.addListener(future -> {
                                if (future.isSuccess()) {
                                    if (HttpServerImpl.this.options.isUseAlpn()) {
                                        SslHandler sslHandler = pipeline.get(SslHandler.class);
                                        String protocol = sslHandler.applicationProtocol();
                                        if ("h2".equals(protocol)) {
                                            HttpServerImpl.this.handleHttp2(ch);
                                        } else {
                                            HttpServerImpl.this.handleHttp1(ch);
                                        }
                                    } else {
                                        HttpServerImpl.this.handleHttp1(ch);
                                    }
                                } else {
                                    HandlerHolder handler = HttpServerImpl.this.httpHandlerMgr.chooseHandler(ch.eventLoop());
                                    handler.context.executeFromIO(() -> ((HttpHandlers)handler.handler).exceptionHandler.handle(future.cause()));
                                }
                            });
                        } else if (HttpServerImpl.this.DISABLE_H2C) {
                            HttpServerImpl.this.handleHttp1(ch);
                        } else {
                            IdleStateHandler idle;
                            if (HttpServerImpl.this.options.getIdleTimeout() > 0) {
                                idle = new IdleStateHandler(0, 0, HttpServerImpl.this.options.getIdleTimeout());
                                pipeline.addLast("idle", (ChannelHandler)idle);
                            } else {
                                idle = null;
                            }
                            pipeline.addLast(new Http1xOrH2CHandler(){

                                @Override
                                protected void configure(ChannelHandlerContext ctx, boolean h2c) {
                                    if (idle != null) {
                                        pipeline.remove(idle);
                                    }
                                    if (h2c) {
                                        HttpServerImpl.this.handleHttp2(ctx.channel());
                                    } else {
                                        HttpServerImpl.this.handleHttp1(ch);
                                    }
                                }

                                @Override
                                public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                                    if (evt instanceof IdleStateEvent && ((IdleStateEvent)evt).state() == IdleState.ALL_IDLE) {
                                        ctx.close();
                                    }
                                }

                                @Override
                                public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                                    super.exceptionCaught(ctx, cause);
                                    HandlerHolder handler = HttpServerImpl.this.httpHandlerMgr.chooseHandler(ctx.channel().eventLoop());
                                    handler.context.executeFromIO(() -> ((HttpHandlers)handler.handler).exceptionHandler.handle(cause));
                                }
                            });
                        }
                    }
                });
                this.addHandlers(this, this.listenContext);
                try {
                    this.bindFuture = AsyncResolveConnectHelper.doBind(this.vertx, SocketAddress.inetSocketAddress(port2, host), bootstrap);
                    this.bindFuture.addListener(res -> {
                        if (res.failed()) {
                            this.vertx.sharedHttpServers().remove(this.id);
                        } else {
                            Channel serverChannel = (Channel)res.result();
                            this.actualPort = ((InetSocketAddress)serverChannel.localAddress()).getPort();
                            this.serverChannelGroup.add(serverChannel);
                            VertxMetrics metrics = this.vertx.metricsSPI();
                            this.metrics = metrics != null ? metrics.createMetrics(this, new SocketAddressImpl(port2, host), this.options) : null;
                        }
                    });
                }
                catch (Throwable t) {
                    if (listenHandler != null) {
                        this.vertx.runOnContext(v -> listenHandler.handle(Future.failedFuture(t)));
                    } else {
                        log.error(t);
                    }
                    this.listening = false;
                    return this;
                }
                this.vertx.sharedHttpServers().put(this.id, this);
                this.actualServer = this;
            } else {
                this.actualServer = shared;
                this.actualPort = shared.actualPort;
                this.addHandlers(this.actualServer, this.listenContext);
                VertxMetrics metrics = this.vertx.metricsSPI();
                this.metrics = metrics != null ? metrics.createMetrics(this, new SocketAddressImpl(port2, host), this.options) : null;
            }
            this.actualServer.bindFuture.addListener(future -> {
                if (listenHandler != null) {
                    Future<HttpServerImpl> res;
                    if (future.succeeded()) {
                        res = Future.succeededFuture(this);
                    } else {
                        res = Future.failedFuture(future.cause());
                        this.listening = false;
                    }
                    this.listenContext.runOnContext(v -> listenHandler.handle(res));
                } else if (future.failed()) {
                    this.listening = false;
                    log.error(future.cause());
                }
            });
        }
        return this;
    }

    private VertxHttp2ConnectionHandler<Http2ServerConnection> buildHttp2ConnectionHandler(HandlerHolder<HttpHandlers> holder) {
        Http2ConnectionHandler handler = ((VertxHttp2ConnectionHandlerBuilder)new VertxHttp2ConnectionHandlerBuilder().server(true)).useCompression(this.options.isCompressionSupported()).useDecompression(this.options.isDecompressionSupported()).compressionLevel(this.options.getCompressionLevel()).initialSettings(this.options.getInitialSettings()).connectionFactory(connHandler -> new Http2ServerConnection(holder.context, this.serverOrigin, (VertxHttp2ConnectionHandler)connHandler, this.options, ((HttpHandlers)holder.handler).requestHandler, this.metrics)).logEnabled(this.logEnabled).build();
        ((VertxHttp2ConnectionHandler)handler).addHandler(conn -> {
            this.connectionMap.put(conn.channel(), (ConnectionBase)conn);
            if (this.metrics != null) {
                conn.metric(this.metrics.connected(conn.remoteAddress(), conn.remoteName()));
            }
            if (this.options.getHttp2ConnectionWindowSize() > 0) {
                conn.setWindowSize(this.options.getHttp2ConnectionWindowSize());
            }
            if (((HttpHandlers)holder.handler).connectionHandler != null) {
                holder.context.executeFromIO(() -> ((HttpHandlers)holder.handler).connectionHandler.handle((HttpConnection)conn));
            }
        });
        ((VertxHttp2ConnectionHandler)handler).removeHandler(conn -> this.connectionMap.remove(conn.channel()));
        return handler;
    }

    private void configureHttp1(ChannelPipeline pipeline, HandlerHolder<HttpHandlers> holder) {
        if (this.logEnabled) {
            pipeline.addLast("logging", (ChannelHandler)new LoggingHandler());
        }
        if (USE_FLASH_POLICY_HANDLER) {
            pipeline.addLast("flashpolicy", (ChannelHandler)new FlashPolicyHandler());
        }
        pipeline.addLast("httpDecoder", (ChannelHandler)new HttpRequestDecoder(this.options.getMaxInitialLineLength(), this.options.getMaxHeaderSize(), this.options.getMaxChunkSize(), false, this.options.getDecoderInitialBufferSize()));
        pipeline.addLast("httpEncoder", (ChannelHandler)new VertxHttpResponseEncoder());
        if (this.options.isDecompressionSupported()) {
            pipeline.addLast("inflater", (ChannelHandler)new HttpContentDecompressor(true));
        }
        if (this.options.isCompressionSupported()) {
            pipeline.addLast("deflater", (ChannelHandler)new HttpChunkContentCompressor(this.options.getCompressionLevel()));
        }
        if (this.sslHelper.isSSL() || this.options.isCompressionSupported()) {
            pipeline.addLast("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
        }
        if (this.options.getIdleTimeout() > 0) {
            pipeline.addLast("idle", (ChannelHandler)new IdleStateHandler(0, 0, this.options.getIdleTimeout()));
        }
        if (!this.DISABLE_H2C) {
            pipeline.addLast("h2c", (ChannelHandler)new Http2UpgradeHandler());
        }
        Http1xServerHandler handler = DISABLE_WEBSOCKETS ? new Http1xServerHandler(this.sslHelper, this.options, this.serverOrigin, holder, this.metrics) : new ServerHandlerWithWebSockets(this.sslHelper, this.options, this.serverOrigin, holder, this.metrics);
        handler.addHandler(conn -> this.connectionMap.put(pipeline.channel(), (ConnectionBase)conn));
        handler.removeHandler(conn -> this.connectionMap.remove(pipeline.channel()));
        pipeline.addLast("handler", (ChannelHandler)handler);
    }

    private void handleHttp1(Channel ch) {
        HandlerHolder<HttpHandlers> holder = this.httpHandlerMgr.chooseHandler(ch.eventLoop());
        if (holder == null) {
            this.sendServiceUnavailable(ch);
            return;
        }
        this.configureHttp1(ch.pipeline(), holder);
    }

    private void sendServiceUnavailable(Channel ch) {
        ch.writeAndFlush(Unpooled.copiedBuffer("HTTP/1.1 503 Service Unavailable\r\nContent-Length:0\r\n\r\n", StandardCharsets.ISO_8859_1)).addListener(ChannelFutureListener.CLOSE);
    }

    private void handleHttp2(Channel ch) {
        HandlerHolder<HttpHandlers> holder = this.httpHandlerMgr.chooseHandler(ch.eventLoop());
        if (holder == null) {
            ch.close();
            return;
        }
        VertxHttp2ConnectionHandler<Http2ServerConnection> handler = this.buildHttp2ConnectionHandler(holder);
        ch.pipeline().addLast("handler", handler);
        this.configureHttp2(ch.pipeline());
    }

    private void configureHttp2(ChannelPipeline pipeline) {
        if (this.options.getIdleTimeout() > 0) {
            pipeline.addBefore("handler", "idle", new IdleStateHandler(0, 0, this.options.getIdleTimeout()));
        }
    }

    @Override
    public void close() {
        this.close(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close(Handler<AsyncResult<Void>> done) {
        if (this.wsStream.endHandler() != null || this.requestStream.endHandler() != null) {
            Handler<Void> wsEndHandler = this.wsStream.endHandler();
            this.wsStream.endHandler(null);
            Handler<Void> requestEndHandler = this.requestStream.endHandler();
            this.requestStream.endHandler(null);
            Handler<AsyncResult<Void>> next = done;
            done = event -> {
                if (event.succeeded()) {
                    if (wsEndHandler != null) {
                        wsEndHandler.handle((Void)event.result());
                    }
                    if (requestEndHandler != null) {
                        requestEndHandler.handle((Void)event.result());
                    }
                }
                if (next != null) {
                    next.handle((AsyncResult<Void>)event);
                }
            };
        }
        ContextImpl context = this.vertx.getOrCreateContext();
        if (!this.listening) {
            this.executeCloseDone(context, done, null);
            return;
        }
        this.listening = false;
        Map<ServerID, HttpServerImpl> map = this.vertx.sharedHttpServers();
        synchronized (map) {
            if (this.actualServer != null) {
                this.actualServer.httpHandlerMgr.removeHandler(new HttpHandlers(this.requestStream.handler(), this.wsStream.handler(), this.connectionHandler, this.exceptionHandler == null ? DEFAULT_EXCEPTION_HANDLER : this.exceptionHandler), this.listenContext);
                if (this.actualServer.httpHandlerMgr.hasHandlers()) {
                    if (done != null) {
                        this.executeCloseDone(context, done, null);
                    }
                } else {
                    this.actualServer.actualClose(context, done);
                }
            }
        }
        if (this.creatingContext != null) {
            this.creatingContext.removeCloseHook(this);
        }
    }

    @Override
    public Metrics getMetrics() {
        return this.metrics;
    }

    @Override
    public boolean isMetricsEnabled() {
        return this.metrics != null;
    }

    public SSLHelper getSslHelper() {
        return this.sslHelper;
    }

    private void applyConnectionOptions(ServerBootstrap bootstrap) {
        this.vertx.transport().configure(this.options, bootstrap);
    }

    private void addHandlers(HttpServerImpl server, ContextImpl context) {
        server.httpHandlerMgr.addHandler(new HttpHandlers(this.requestStream.handler(), this.wsStream.handler(), this.connectionHandler, this.exceptionHandler == null ? DEFAULT_EXCEPTION_HANDLER : this.exceptionHandler), context);
    }

    private void actualClose(ContextImpl closeContext, Handler<AsyncResult<Void>> done) {
        if (this.id != null) {
            this.vertx.sharedHttpServers().remove(this.id);
        }
        ContextImpl currCon = this.vertx.getContext();
        for (ConnectionBase conn : this.connectionMap.values()) {
            conn.close();
        }
        if (this.vertx.getContext() != currCon) {
            throw new IllegalStateException("Context was changed");
        }
        if (this.metrics != null) {
            this.metrics.close();
        }
        ChannelGroupFuture fut = this.serverChannelGroup.close();
        fut.addListener((GenericFutureListener<? extends znaishaded.io.netty.util.concurrent.Future<? super Void>>)((GenericFutureListener<znaishaded.io.netty.util.concurrent.Future>)cgf -> this.executeCloseDone(closeContext, done, fut.cause())));
    }

    @Override
    public int actualPort() {
        return this.actualPort;
    }

    private void executeCloseDone(ContextImpl closeContext, Handler<AsyncResult<Void>> done, Exception e) {
        if (done != null) {
            Future fut = e != null ? Future.failedFuture(e) : Future.succeededFuture();
            closeContext.runOnContext(v -> done.handle(fut));
        }
    }

    static void sendError(CharSequence err, HttpResponseStatus status, Channel ch) {
        DefaultFullHttpResponse resp = new DefaultFullHttpResponse(znaishaded.io.netty.handler.codec.http.HttpVersion.HTTP_1_1, status);
        if (status.code() == HttpResponseStatus.METHOD_NOT_ALLOWED.code()) {
            resp.headers().set(HttpHeaders.ALLOW, (Object)HttpHeaders.GET);
        }
        if (err != null) {
            resp.content().writeBytes(err.toString().getBytes(CharsetUtil.UTF_8));
            znaishaded.io.netty.handler.codec.http.HttpHeaders.setContentLength(resp, err.length());
        } else {
            znaishaded.io.netty.handler.codec.http.HttpHeaders.setContentLength(resp, 0L);
        }
        ch.writeAndFlush(resp);
    }

    static String getWebSocketLocation(ChannelPipeline pipeline, HttpRequest req) throws Exception {
        String prefix = pipeline.get(SslHandler.class) == null ? "ws://" : "wss://";
        URI uri = new URI(req.getUri());
        String path2 = uri.getRawPath();
        String loc = prefix + znaishaded.io.netty.handler.codec.http.HttpHeaders.getHost(req) + path2;
        String query = uri.getRawQuery();
        if (query != null) {
            loc = loc + "?" + query;
        }
        return loc;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    HttpServerOptions options() {
        return this.options;
    }

    private class Http2UpgradeHandler
    extends ChannelInboundHandlerAdapter {
        private VertxHttp2ConnectionHandler<Http2ServerConnection> handler;

        private Http2UpgradeHandler() {
        }

        @Override
        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            if (msg instanceof HttpRequest) {
                HttpRequest request = (HttpRequest)msg;
                if (request.headers().contains(HttpHeaders.UPGRADE, Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME, true)) {
                    Http2Settings settings;
                    String settingsHeader;
                    String connection = request.headers().get(HttpHeaders.CONNECTION);
                    int found = 0;
                    if (connection != null && connection.length() > 0) {
                        StringBuilder buff = new StringBuilder();
                        int pos = 0;
                        int len = connection.length();
                        while (pos < len) {
                            char c;
                            if ((c = connection.charAt(pos++)) != ' ' && c != ',') {
                                buff.append(Character.toLowerCase(c));
                            }
                            if (c != ',' && pos != len) continue;
                            if (buff.indexOf("upgrade") == 0 && buff.length() == 7) {
                                found |= 1;
                            } else if (buff.indexOf("http2-settings") == 0 && buff.length() == 14) {
                                found |= 2;
                            }
                            buff.setLength(0);
                        }
                    }
                    if (found == 3 && (settingsHeader = request.headers().get(Http2CodecUtil.HTTP_UPGRADE_SETTINGS_HEADER)) != null && (settings = HttpUtils.decodeSettings(settingsHeader)) != null) {
                        HandlerHolder reqHandler = HttpServerImpl.this.httpHandlerMgr.chooseHandler(ctx.channel().eventLoop());
                        if (reqHandler != null && reqHandler.context.isEventLoopContext()) {
                            ChannelPipeline pipeline = ctx.pipeline();
                            DefaultFullHttpResponse res = new DefaultFullHttpResponse(znaishaded.io.netty.handler.codec.http.HttpVersion.HTTP_1_1, HttpResponseStatus.SWITCHING_PROTOCOLS, Unpooled.EMPTY_BUFFER, false);
                            res.headers().add((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.UPGRADE);
                            res.headers().add((CharSequence)HttpHeaderNames.UPGRADE, (Object)Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME);
                            res.headers().add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)HttpHeaderValues.ZERO);
                            ctx.writeAndFlush(res);
                            pipeline.remove("httpEncoder");
                            pipeline.remove("handler");
                            this.handler = HttpServerImpl.this.buildHttp2ConnectionHandler(reqHandler);
                            pipeline.addLast("handler", this.handler);
                            this.handler.serverUpgrade(ctx, settings, request);
                            DefaultHttp2Headers headers = new DefaultHttp2Headers();
                            headers.method(request.method().name());
                            headers.path(request.uri());
                            headers.authority(request.headers().get("host"));
                            headers.scheme("http");
                            request.headers().remove("http2-settings");
                            request.headers().remove("host");
                            request.headers().forEach(header -> {
                                Http2Headers cfr_ignored_0 = (Http2Headers)headers.set(((String)header.getKey()).toLowerCase(), header.getValue());
                            });
                            ctx.fireChannelRead(new DefaultHttp2HeadersFrame(headers, false));
                        } else {
                            log.warn("Cannot perform HTTP/2 upgrade in a worker verticle");
                        }
                    }
                    if (this.handler == null) {
                        DefaultFullHttpResponse res = new DefaultFullHttpResponse(znaishaded.io.netty.handler.codec.http.HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST, Unpooled.EMPTY_BUFFER, false);
                        res.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
                        ctx.writeAndFlush(res);
                    }
                } else {
                    ctx.fireChannelRead(msg);
                    ctx.pipeline().remove(this);
                }
            } else if (this.handler != null) {
                if (msg instanceof HttpContent) {
                    HttpContent content = (HttpContent)msg;
                    ByteBuf buf = VertxHandler.safeBuffer(content.content(), ctx.alloc());
                    boolean end = msg instanceof LastHttpContent;
                    ctx.fireChannelRead(new DefaultHttp2DataFrame(buf, end, 0));
                    if (end) {
                        ChannelPipeline pipeline = ctx.pipeline();
                        for (Map.Entry handler : pipeline) {
                            if (handler.getValue() instanceof Http2ConnectionHandler) continue;
                            pipeline.remove((String)handler.getKey());
                        }
                        HttpServerImpl.this.configureHttp2(pipeline);
                    }
                } else {
                    super.channelRead(ctx, msg);
                }
            }
        }
    }

    private class HttpStreamHandler<C extends ReadStream<Buffer>>
    implements ReadStream<C> {
        private Handler<C> handler;
        private boolean paused;
        private Handler<Void> endHandler;

        private HttpStreamHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Handler<C> handler() {
            HttpServerImpl httpServerImpl = HttpServerImpl.this;
            synchronized (httpServerImpl) {
                return this.handler;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isPaused() {
            HttpServerImpl httpServerImpl = HttpServerImpl.this;
            synchronized (httpServerImpl) {
                return this.paused;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Handler<Void> endHandler() {
            HttpServerImpl httpServerImpl = HttpServerImpl.this;
            synchronized (httpServerImpl) {
                return this.endHandler;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ReadStream handler(Handler<C> handler) {
            HttpServerImpl httpServerImpl = HttpServerImpl.this;
            synchronized (httpServerImpl) {
                if (HttpServerImpl.this.listening) {
                    throw new IllegalStateException("Please set handler before server is listening");
                }
                this.handler = handler;
                return this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ReadStream pause() {
            HttpServerImpl httpServerImpl = HttpServerImpl.this;
            synchronized (httpServerImpl) {
                if (!this.paused) {
                    this.paused = true;
                }
                return this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ReadStream resume() {
            HttpServerImpl httpServerImpl = HttpServerImpl.this;
            synchronized (httpServerImpl) {
                if (this.paused) {
                    this.paused = false;
                }
                return this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ReadStream endHandler(Handler<Void> endHandler) {
            HttpServerImpl httpServerImpl = HttpServerImpl.this;
            synchronized (httpServerImpl) {
                this.endHandler = endHandler;
                return this;
            }
        }

        @Override
        public ReadStream exceptionHandler(Handler<Throwable> handler) {
            return this;
        }
    }

    public class ServerHandlerWithWebSockets
    extends Http1xServerHandler {
        private boolean closeFrameSent;
        private FullHttpRequest wsRequest;
        private HttpResponseStatus handshakeErrorStatus;
        private String handshakeErrorMsg;

        public ServerHandlerWithWebSockets(SSLHelper sslHelper, HttpServerOptions options, String serverOrigin, HandlerHolder<HttpHandlers> holder, HttpServerMetrics metrics) {
            super(sslHelper, options, serverOrigin, holder, metrics);
        }

        @Override
        protected void handleMessage(Http1xServerConnection conn, ContextImpl context, ChannelHandlerContext chctx, Object msg) throws Exception {
            Channel ch = chctx.channel();
            if (msg instanceof HttpRequest) {
                HttpRequest request = (HttpRequest)msg;
                if (log.isTraceEnabled()) {
                    log.trace("Server received request: " + request.getUri());
                }
                if (request.headers().contains(HttpHeaders.UPGRADE, HttpHeaders.WEBSOCKET, true)) {
                    String connectionHeader = request.headers().get(HttpHeaders.CONNECTION);
                    if (connectionHeader == null || !connectionHeader.toLowerCase().contains("upgrade")) {
                        this.handshakeErrorStatus = HttpResponseStatus.BAD_REQUEST;
                        this.handshakeErrorMsg = "\"Connection\" must be \"Upgrade\".";
                        return;
                    }
                    if (request.getMethod() != HttpMethod.GET) {
                        this.handshakeErrorStatus = HttpResponseStatus.METHOD_NOT_ALLOWED;
                        HttpServerImpl.sendError(null, HttpResponseStatus.METHOD_NOT_ALLOWED, ch);
                        return;
                    }
                    if (this.wsRequest == null) {
                        if (request instanceof FullHttpRequest) {
                            this.handshake(conn, (FullHttpRequest)request, ch, chctx);
                        } else {
                            this.wsRequest = new DefaultFullHttpRequest(request.getProtocolVersion(), request.getMethod(), request.getUri());
                            this.wsRequest.headers().set(request.headers());
                        }
                    }
                } else {
                    conn.handleMessage(msg);
                }
            } else if (msg instanceof WebSocketFrameInternal) {
                WebSocketFrameInternal wsFrame = (WebSocketFrameInternal)msg;
                switch (wsFrame.type()) {
                    case BINARY: 
                    case CONTINUATION: 
                    case TEXT: 
                    case PONG: {
                        conn.handleMessage(msg);
                        break;
                    }
                    case PING: {
                        conn.channel().writeAndFlush(new PongWebSocketFrame(wsFrame.getBinaryData().copy()));
                        break;
                    }
                    case CLOSE: {
                        if (!this.closeFrameSent) {
                            CloseWebSocketFrame closeFrame = new CloseWebSocketFrame(wsFrame.closeStatusCode(), wsFrame.closeReason());
                            ch.writeAndFlush(closeFrame).addListener(ChannelFutureListener.CLOSE);
                            this.closeFrameSent = true;
                        }
                        conn.handleMessage(msg);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Invalid type: " + (Object)((Object)wsFrame.type()));
                    }
                }
            } else if (msg instanceof HttpContent) {
                if (this.wsRequest != null) {
                    ByteBuf content = this.wsRequest.content();
                    boolean overflow = content.readableBytes() > 8192;
                    content.writeBytes(((HttpContent)msg).content());
                    if (content.readableBytes() > 8192) {
                        if (!overflow) {
                            DefaultFullHttpResponse resp = new DefaultFullHttpResponse(znaishaded.io.netty.handler.codec.http.HttpVersion.HTTP_1_1, HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE);
                            chctx.writeAndFlush(resp);
                            chctx.close();
                        }
                        if (msg instanceof LastHttpContent) {
                            this.wsRequest = null;
                            return;
                        }
                    }
                    if (msg instanceof LastHttpContent) {
                        FullHttpRequest req = this.wsRequest;
                        this.wsRequest = null;
                        this.handshake(conn, req, ch, chctx);
                        return;
                    }
                } else if (this.handshakeErrorStatus != null) {
                    if (msg instanceof LastHttpContent) {
                        HttpServerImpl.sendError(this.handshakeErrorMsg, this.handshakeErrorStatus, ch);
                        this.handshakeErrorMsg = null;
                        this.handshakeErrorMsg = null;
                    }
                    return;
                }
                conn.handleMessage(msg);
            } else {
                throw new IllegalStateException("Invalid message " + msg);
            }
        }

        protected void handshake(Http1xServerConnection conn, FullHttpRequest request, Channel ch, ChannelHandlerContext ctx) throws Exception {
            WebSocketServerHandshaker shake = this.createHandshaker(conn, ch, request);
            if (shake == null) {
                return;
            }
            HandlerHolder wsHandler = HttpServerImpl.this.httpHandlerMgr.chooseHandler(ch.eventLoop());
            if (wsHandler == null || ((HttpHandlers)wsHandler.handler).wsHandler == null) {
                conn.handleMessage(request);
            } else {
                wsHandler.context.executeFromIO(() -> {
                    URI theURI;
                    try {
                        theURI = new URI(request.getUri());
                    }
                    catch (URISyntaxException e2) {
                        throw new IllegalArgumentException("Invalid uri " + request.getUri());
                    }
                    if (HttpServerImpl.this.metrics != null) {
                        conn.metric(HttpServerImpl.this.metrics.connected(conn.remoteAddress(), conn.remoteName()));
                    }
                    conn.wsHandler(shake, (HttpHandlers)wsHandler.handler);
                    Supplier<String> connectRunnable = () -> {
                        try {
                            shake.handshake(ch, request);
                            return shake.selectedSubprotocol();
                        }
                        catch (WebSocketHandshakeException e) {
                            conn.handleException(e);
                            return null;
                        }
                        catch (Exception e) {
                            log.error((Object)"Failed to generate shake response", e);
                            return null;
                        }
                    };
                    ServerWebSocketImpl ws = new ServerWebSocketImpl(HttpServerImpl.this.vertx, theURI.toString(), theURI.getPath(), theURI.getQuery(), new HeadersAdaptor(request.headers()), conn, shake.version() != WebSocketVersion.V00, connectRunnable, HttpServerImpl.this.options.getMaxWebsocketFrameSize(), HttpServerImpl.this.options().getMaxWebsocketMessageSize());
                    if (Metrics.METRICS_ENABLED && HttpServerImpl.this.metrics != null) {
                        ws.setMetric(HttpServerImpl.this.metrics.connected(conn.metric(), ws));
                    }
                    conn.handleWebsocketConnect(ws);
                    if (!ws.isRejected()) {
                        HttpChunkContentCompressor handler = ctx.pipeline().get(HttpChunkContentCompressor.class);
                        if (handler != null) {
                            ctx.pipeline().remove(handler);
                        }
                        ws.connectNow();
                    } else {
                        ch.writeAndFlush(new DefaultFullHttpResponse(znaishaded.io.netty.handler.codec.http.HttpVersion.HTTP_1_1, ws.getRejectedStatus()));
                    }
                });
            }
        }
    }
}

