/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.http.impl;

import java.util.function.Function;
import znaishaded.io.netty.buffer.ByteBuf;
import znaishaded.io.netty.channel.ChannelFuture;
import znaishaded.io.netty.channel.ChannelHandlerContext;
import znaishaded.io.netty.channel.ChannelPromise;
import znaishaded.io.netty.handler.codec.http.HttpRequest;
import znaishaded.io.netty.handler.codec.http2.DelegatingDecompressorFrameListener;
import znaishaded.io.netty.handler.codec.http2.Http2Connection;
import znaishaded.io.netty.handler.codec.http2.Http2ConnectionDecoder;
import znaishaded.io.netty.handler.codec.http2.Http2ConnectionEncoder;
import znaishaded.io.netty.handler.codec.http2.Http2ConnectionHandler;
import znaishaded.io.netty.handler.codec.http2.Http2DataFrame;
import znaishaded.io.netty.handler.codec.http2.Http2Exception;
import znaishaded.io.netty.handler.codec.http2.Http2Flags;
import znaishaded.io.netty.handler.codec.http2.Http2FrameListener;
import znaishaded.io.netty.handler.codec.http2.Http2Headers;
import znaishaded.io.netty.handler.codec.http2.Http2HeadersFrame;
import znaishaded.io.netty.handler.codec.http2.Http2RemoteFlowController;
import znaishaded.io.netty.handler.codec.http2.Http2Settings;
import znaishaded.io.netty.handler.codec.http2.Http2Stream;
import znaishaded.io.netty.handler.codec.http2.Http2StreamFrame;
import znaishaded.io.netty.handler.timeout.IdleState;
import znaishaded.io.netty.handler.timeout.IdleStateEvent;
import znaishaded.io.netty.util.concurrent.EventExecutor;
import znaishaded.io.netty.util.concurrent.GenericFutureListener;
import znaishaded.io.vertx.core.AsyncResult;
import znaishaded.io.vertx.core.Future;
import znaishaded.io.vertx.core.Handler;
import znaishaded.io.vertx.core.http.impl.Http2ConnectionBase;
import znaishaded.io.vertx.core.impl.ContextImpl;

class VertxHttp2ConnectionHandler<C extends Http2ConnectionBase>
extends Http2ConnectionHandler
implements Http2FrameListener,
Http2Connection.Listener {
    private final Function<VertxHttp2ConnectionHandler<C>, C> connectionFactory;
    private C connection;
    private ChannelHandlerContext chctx;
    private Handler<C> addHandler;
    private Handler<C> removeHandler;
    private final boolean useDecompressor;

    public VertxHttp2ConnectionHandler(Function<VertxHttp2ConnectionHandler<C>, C> connectionFactory, boolean useDecompressor, Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings) {
        super(decoder, encoder, initialSettings);
        this.connectionFactory = connectionFactory;
        this.useDecompressor = useDecompressor;
        this.encoder().flowController().listener(s2 -> {
            if (this.connection != null) {
                ((Http2ConnectionBase)this.connection).onStreamwritabilityChanged(s2);
            }
        });
        this.connection().addListener(this);
    }

    public ChannelHandlerContext context() {
        return this.chctx;
    }

    public VertxHttp2ConnectionHandler<C> addHandler(Handler<C> handler) {
        this.addHandler = handler;
        return this;
    }

    public VertxHttp2ConnectionHandler<C> removeHandler(Handler<C> handler) {
        this.removeHandler = handler;
        return this;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        this.chctx = ctx;
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.onError(ctx, cause);
        ctx.close();
    }

    public void serverUpgrade(ChannelHandlerContext ctx, Http2Settings serverUpgradeSettings, HttpRequest request) throws Exception {
        this.onHttpServerUpgrade(serverUpgradeSettings);
        this.onSettingsRead(ctx, serverUpgradeSettings);
    }

    public void clientUpgrade(ChannelHandlerContext ctx) throws Exception {
        this.onHttpClientUpgrade();
        ctx.flush();
    }

    @Override
    public void channelInactive(ChannelHandlerContext chctx) throws Exception {
        super.channelInactive(chctx);
        if (this.connection != null) {
            ContextImpl ctx = ((Http2ConnectionBase)this.connection).getContext();
            ctx.executeFromIO(() -> ((Http2ConnectionBase)this.connection).handleClosed());
            if (this.removeHandler != null) {
                this.removeHandler.handle(this.connection);
            }
        }
    }

    @Override
    protected void onConnectionError(ChannelHandlerContext ctx, Throwable cause, Http2Exception http2Ex) {
        ((Http2ConnectionBase)this.connection).getContext().executeFromIO(() -> ((Http2ConnectionBase)this.connection).onConnectionError(cause));
        super.onConnectionError(ctx, cause, http2Ex);
    }

    @Override
    protected void onStreamError(ChannelHandlerContext ctx, Throwable cause, Http2Exception.StreamException http2Ex) {
        ((Http2ConnectionBase)this.connection).getContext().executeFromIO(() -> ((Http2ConnectionBase)this.connection).onStreamError(http2Ex.streamId(), http2Ex));
        super.onStreamError(ctx, cause, http2Ex);
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        try {
            super.userEventTriggered(ctx, evt);
        }
        finally {
            if (evt instanceof IdleStateEvent && ((IdleStateEvent)evt).state() == IdleState.ALL_IDLE) {
                ctx.close();
            }
        }
    }

    @Override
    public void onStreamClosed(Http2Stream stream) {
        ((Http2ConnectionBase)this.connection).onStreamClosed(stream);
    }

    @Override
    public void onStreamAdded(Http2Stream stream) {
    }

    @Override
    public void onStreamActive(Http2Stream stream) {
    }

    @Override
    public void onStreamHalfClosed(Http2Stream stream) {
    }

    @Override
    public void onStreamRemoved(Http2Stream stream) {
    }

    @Override
    public void onGoAwaySent(int lastStreamId, long errorCode, ByteBuf debugData) {
        ((Http2ConnectionBase)this.connection).onGoAwaySent(lastStreamId, errorCode, debugData);
    }

    @Override
    public void onGoAwayReceived(int lastStreamId, long errorCode, ByteBuf debugData) {
        ((Http2ConnectionBase)this.connection).onGoAwayReceived(lastStreamId, errorCode, debugData);
    }

    void writeHeaders(Http2Stream stream, Http2Headers headers, boolean end) {
        EventExecutor executor = this.chctx.executor();
        if (executor.inEventLoop()) {
            this._writeHeaders(stream, headers, end);
        } else {
            executor.execute(() -> this._writeHeaders(stream, headers, end));
        }
    }

    private void _writeHeaders(Http2Stream stream, Http2Headers headers, boolean end) {
        this.encoder().writeHeaders(this.chctx, stream.id(), headers, 0, end, this.chctx.newPromise());
    }

    void writeData(Http2Stream stream, ByteBuf chunk, boolean end) {
        EventExecutor executor = this.chctx.executor();
        if (executor.inEventLoop()) {
            this._writeData(stream, chunk, end);
        } else {
            executor.execute(() -> this._writeData(stream, chunk, end));
        }
    }

    private void _writeData(Http2Stream stream, ByteBuf chunk, boolean end) {
        this.encoder().writeData(this.chctx, stream.id(), chunk, 0, end, this.chctx.newPromise());
        Http2RemoteFlowController controller = this.encoder().flowController();
        if (!controller.isWritable(stream) || end) {
            try {
                this.encoder().flowController().writePendingBytes();
            }
            catch (Http2Exception e) {
                this.onError(this.chctx, e);
            }
        }
        this.chctx.channel().flush();
    }

    ChannelFuture writePing(ByteBuf data) {
        ChannelPromise promise = this.chctx.newPromise();
        EventExecutor executor = this.chctx.executor();
        if (executor.inEventLoop()) {
            this._writePing(data, promise);
        } else {
            executor.execute(() -> this._writePing(data, promise));
        }
        return promise;
    }

    private void _writePing(ByteBuf data, ChannelPromise promise) {
        this.encoder().writePing(this.chctx, false, data, promise);
        this.chctx.channel().flush();
    }

    void consume(Http2Stream stream, int numBytes) {
        try {
            boolean windowUpdateSent = this.decoder().flowController().consumeBytes(stream, numBytes);
            if (windowUpdateSent) {
                this.chctx.channel().flush();
            }
        }
        catch (Http2Exception e) {
            this.onError(this.chctx, e);
        }
    }

    void writeFrame(Http2Stream stream, byte type, short flags, ByteBuf payload) {
        EventExecutor executor = this.chctx.executor();
        if (executor.inEventLoop()) {
            this._writeFrame(stream, type, flags, payload);
        } else {
            executor.execute(() -> this._writeFrame(stream, type, flags, payload));
        }
    }

    private void _writeFrame(Http2Stream stream, byte type, short flags, ByteBuf payload) {
        this.encoder().writeFrame(this.chctx, type, stream.id(), new Http2Flags(flags), payload, this.chctx.newPromise());
        this.chctx.flush();
    }

    void writeReset(int streamId, long code) {
        EventExecutor executor = this.chctx.executor();
        if (executor.inEventLoop()) {
            this._writeReset(streamId, code);
        } else {
            executor.execute(() -> this._writeReset(streamId, code));
        }
    }

    private void _writeReset(int streamId, long code) {
        this.encoder().writeRstStream(this.chctx, streamId, code, this.chctx.newPromise());
        this.chctx.flush();
    }

    void writeGoAway(long errorCode, int lastStreamId, ByteBuf debugData) {
        EventExecutor executor = this.chctx.executor();
        if (executor.inEventLoop()) {
            this._writeGoAway(errorCode, lastStreamId, debugData);
        } else {
            executor.execute(() -> this._writeGoAway(errorCode, lastStreamId, debugData));
        }
    }

    private void _writeGoAway(long errorCode, int lastStreamId, ByteBuf debugData) {
        this.encoder().writeGoAway(this.chctx, lastStreamId, errorCode, debugData, this.chctx.newPromise());
        this.chctx.flush();
    }

    ChannelFuture writeSettings(Http2Settings settingsUpdate) {
        ChannelPromise promise = this.chctx.newPromise();
        EventExecutor executor = this.chctx.executor();
        if (executor.inEventLoop()) {
            this._writeSettings(settingsUpdate, promise);
        } else {
            executor.execute(() -> this._writeSettings(settingsUpdate, promise));
        }
        return promise;
    }

    private void _writeSettings(Http2Settings settingsUpdate, ChannelPromise promise) {
        this.encoder().writeSettings(this.chctx, settingsUpdate, promise);
        this.chctx.flush();
    }

    void writePushPromise(int streamId, Http2Headers headers, Handler<AsyncResult<Integer>> completionHandler) {
        int promisedStreamId = this.connection().local().incrementAndGetNextStreamId();
        ChannelPromise promise = this.chctx.newPromise();
        promise.addListener((GenericFutureListener<? extends znaishaded.io.netty.util.concurrent.Future<? super Void>>)((GenericFutureListener<znaishaded.io.netty.util.concurrent.Future>)fut -> {
            if (fut.isSuccess()) {
                completionHandler.handle(Future.succeededFuture(promisedStreamId));
            } else {
                completionHandler.handle(Future.failedFuture(fut.cause()));
            }
        }));
        EventExecutor executor = this.chctx.executor();
        if (executor.inEventLoop()) {
            this._writePushPromise(streamId, promisedStreamId, headers, promise);
        } else {
            executor.execute(() -> this._writePushPromise(streamId, promisedStreamId, headers, promise));
        }
    }

    private void _writePushPromise(int streamId, int promisedStreamId, Http2Headers headers, ChannelPromise promise) {
        this.encoder().writePushPromise(this.chctx, streamId, promisedStreamId, headers, 0, promise);
    }

    @Override
    public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endOfStream) throws Http2Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream) throws Http2Exception {
        assert (this.connection != null);
        ((Http2ConnectionBase)this.connection).onHeadersRead(ctx, streamId, headers, streamDependency, weight, exclusive, padding, endOfStream);
    }

    @Override
    public void onPriorityRead(ChannelHandlerContext ctx, int streamId, int streamDependency, short weight, boolean exclusive) throws Http2Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void onRstStreamRead(ChannelHandlerContext ctx, int streamId, long errorCode) throws Http2Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void onSettingsAckRead(ChannelHandlerContext ctx) throws Http2Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void onSettingsRead(ChannelHandlerContext ctx, Http2Settings settings) throws Http2Exception {
        this.connection = (Http2ConnectionBase)this.connectionFactory.apply(this);
        if (this.useDecompressor) {
            this.decoder().frameListener(new DelegatingDecompressorFrameListener(this.decoder().connection(), (Http2FrameListener)this.connection));
        } else {
            this.decoder().frameListener((Http2FrameListener)this.connection);
        }
        ((Http2ConnectionBase)this.connection).onSettingsRead(ctx, settings);
        if (this.addHandler != null) {
            this.addHandler.handle(this.connection);
        }
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof Http2StreamFrame) {
            if (msg instanceof Http2HeadersFrame) {
                Http2HeadersFrame frame = (Http2HeadersFrame)msg;
                this.connection.onHeadersRead(ctx, 1, frame.headers(), frame.padding(), frame.isEndStream());
            } else if (msg instanceof Http2DataFrame) {
                Http2DataFrame frame = (Http2DataFrame)msg;
                ((Http2ConnectionBase)this.connection).onDataRead(ctx, 1, frame.content(), frame.padding(), frame.isEndStream());
            }
        } else {
            super.channelRead(ctx, msg);
        }
    }

    @Override
    public void onPingRead(ChannelHandlerContext ctx, ByteBuf data) throws Http2Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void onPingAckRead(ChannelHandlerContext ctx, ByteBuf data) throws Http2Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void onPushPromiseRead(ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding) throws Http2Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void onGoAwayRead(ChannelHandlerContext ctx, int lastStreamId, long errorCode, ByteBuf debugData) throws Http2Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void onWindowUpdateRead(ChannelHandlerContext ctx, int streamId, int windowSizeIncrement) throws Http2Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void onUnknownFrame(ChannelHandlerContext ctx, byte frameType, int streamId, Http2Flags flags, ByteBuf payload) throws Http2Exception {
        throw new UnsupportedOperationException();
    }
}

