/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.http.impl;

import znaishaded.io.netty.buffer.ByteBuf;
import znaishaded.io.netty.buffer.ByteBufAllocator;
import znaishaded.io.netty.buffer.ByteBufHolder;
import znaishaded.io.netty.buffer.Unpooled;
import znaishaded.io.netty.handler.codec.http.DefaultHttpContent;
import znaishaded.io.netty.handler.codec.http.HttpContent;
import znaishaded.io.netty.handler.codec.http.LastHttpContent;
import znaishaded.io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import znaishaded.io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import znaishaded.io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import znaishaded.io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import znaishaded.io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import znaishaded.io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import znaishaded.io.netty.handler.codec.http.websocketx.WebSocketFrame;
import znaishaded.io.vertx.core.http.impl.AssembledLastHttpContent;
import znaishaded.io.vertx.core.http.impl.FrameType;
import znaishaded.io.vertx.core.http.impl.ws.WebSocketFrameImpl;
import znaishaded.io.vertx.core.net.impl.ConnectionBase;
import znaishaded.io.vertx.core.net.impl.VertxHandler;

public abstract class VertxHttpHandler<C extends ConnectionBase>
extends VertxHandler<C> {
    private static ByteBuf safeBuffer(ByteBufHolder holder, ByteBufAllocator allocator) {
        return VertxHttpHandler.safeBuffer(holder.content(), allocator);
    }

    @Override
    protected Object decode(Object msg, ByteBufAllocator allocator) throws Exception {
        if (msg instanceof HttpContent) {
            HttpContent content = (HttpContent)msg;
            ByteBuf buf = content.content();
            if (buf != Unpooled.EMPTY_BUFFER && buf.isDirect()) {
                ByteBuf newBuf = VertxHttpHandler.safeBuffer(content, allocator);
                if (msg instanceof LastHttpContent) {
                    LastHttpContent last = (LastHttpContent)msg;
                    return new AssembledLastHttpContent(newBuf, last.trailingHeaders(), last.getDecoderResult());
                }
                return new DefaultHttpContent(newBuf);
            }
        } else if (msg instanceof WebSocketFrame) {
            FrameType frameType;
            ByteBuf payload = VertxHttpHandler.safeBuffer((WebSocketFrame)msg, allocator);
            boolean isFinal = ((WebSocketFrame)msg).isFinalFragment();
            if (msg instanceof BinaryWebSocketFrame) {
                frameType = FrameType.BINARY;
            } else if (msg instanceof CloseWebSocketFrame) {
                frameType = FrameType.CLOSE;
            } else if (msg instanceof PingWebSocketFrame) {
                frameType = FrameType.PING;
            } else if (msg instanceof PongWebSocketFrame) {
                frameType = FrameType.PONG;
            } else if (msg instanceof TextWebSocketFrame) {
                frameType = FrameType.TEXT;
            } else if (msg instanceof ContinuationWebSocketFrame) {
                frameType = FrameType.CONTINUATION;
            } else {
                throw new IllegalStateException("Unsupported websocket msg " + msg);
            }
            return new WebSocketFrameImpl(frameType, payload, isFinal);
        }
        return msg;
    }
}

