/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.impl.launcher.commands;

import java.util.List;
import znaishaded.io.vertx.core.impl.Utils;

public class ExecUtils {
    private static final String SINGLE_QUOTE = "'";
    private static final String DOUBLE_QUOTE = "\"";
    public static final int VERTX_INITIALIZATION_EXIT_CODE = 11;
    public static final int VERTX_DEPLOYMENT_EXIT_CODE = 15;
    public static final int PROCESS_ERROR_EXIT_CODE = 12;
    public static final int SYSTEM_CONFIGURATION_EXIT_CODE = 14;
    private static String osName = System.getProperty("os.name").toLowerCase();

    public static String quoteArgument(String argument) {
        String cleanedArgument = argument.trim();
        while (cleanedArgument.startsWith(SINGLE_QUOTE) && cleanedArgument.endsWith(SINGLE_QUOTE) || cleanedArgument.startsWith(DOUBLE_QUOTE) && cleanedArgument.endsWith(DOUBLE_QUOTE)) {
            cleanedArgument = cleanedArgument.substring(1, cleanedArgument.length() - 1);
        }
        StringBuilder buf = new StringBuilder();
        if (cleanedArgument.contains(DOUBLE_QUOTE)) {
            if (cleanedArgument.contains(SINGLE_QUOTE)) {
                throw new IllegalArgumentException("Can't handle single and double quotes in same argument");
            }
            if (Utils.isWindows()) {
                return buf.append(DOUBLE_QUOTE).append(cleanedArgument.replace(DOUBLE_QUOTE, "\\\"")).append(DOUBLE_QUOTE).toString();
            }
            return buf.append(SINGLE_QUOTE).append(cleanedArgument).append(SINGLE_QUOTE).toString();
        }
        if (cleanedArgument.contains(SINGLE_QUOTE) || cleanedArgument.contains(" ")) {
            return buf.append(DOUBLE_QUOTE).append(cleanedArgument).append(DOUBLE_QUOTE).toString();
        }
        return cleanedArgument;
    }

    public static void addArgument(List<String> args, String argument) {
        args.add(ExecUtils.quoteArgument(argument));
    }

    public static boolean isWindows() {
        return osName.contains("windows");
    }

    public static boolean isLinux() {
        return osName.contains("nux");
    }

    public static void exit(int code) {
        System.exit(code);
    }

    public static void exitBecauseOfVertxInitializationIssue() {
        ExecUtils.exit(11);
    }

    public static void exitBecauseOfVertxDeploymentIssue() {
        ExecUtils.exit(15);
    }

    public static void exitBecauseOfProcessIssue() {
        ExecUtils.exit(12);
    }

    public static void exitBecauseOfSystemConfigurationIssue() {
        ExecUtils.exit(14);
    }
}

