/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.net;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import znaishaded.io.vertx.codegen.annotations.DataObject;
import znaishaded.io.vertx.core.buffer.Buffer;
import znaishaded.io.vertx.core.impl.Arguments;
import znaishaded.io.vertx.core.json.JsonObject;
import znaishaded.io.vertx.core.net.PemTrustOptionsConverter;
import znaishaded.io.vertx.core.net.TrustOptions;

@DataObject(generateConverter=true, publicConverter=false)
public class PemTrustOptions
implements TrustOptions,
Cloneable {
    private ArrayList<String> certPaths;
    private ArrayList<Buffer> certValues;

    public PemTrustOptions() {
        this.certPaths = new ArrayList();
        this.certValues = new ArrayList();
    }

    public PemTrustOptions(PemTrustOptions other) {
        this.certPaths = new ArrayList<String>(other.getCertPaths());
        this.certValues = new ArrayList<Buffer>(other.getCertValues());
    }

    public PemTrustOptions(JsonObject json) {
        this();
        PemTrustOptionsConverter.fromJson(json, this);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        PemTrustOptionsConverter.toJson(this, json);
        return json;
    }

    public List<String> getCertPaths() {
        return this.certPaths;
    }

    public PemTrustOptions addCertPath(String certPath) throws NullPointerException {
        Objects.requireNonNull(certPath, "No null certificate accepted");
        Arguments.require(!certPath.isEmpty(), "No empty certificate path accepted");
        this.certPaths.add(certPath);
        return this;
    }

    public List<Buffer> getCertValues() {
        return this.certValues;
    }

    public PemTrustOptions addCertValue(Buffer certValue) throws NullPointerException {
        Objects.requireNonNull(certValue, "No null certificate accepted");
        this.certValues.add(certValue);
        return this;
    }

    @Override
    public PemTrustOptions clone() {
        return new PemTrustOptions(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PemTrustOptions that = (PemTrustOptions)o;
        if (!this.certPaths.equals(that.certPaths)) {
            return false;
        }
        return this.certValues.equals(that.certValues);
    }

    public int hashCode() {
        int result = this.certPaths.hashCode();
        result = 31 * result + this.certValues.hashCode();
        return result;
    }
}

