/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.ext.web.handler.impl;

import znaishaded.io.vertx.core.MultiMap;
import znaishaded.io.vertx.core.http.HttpHeaders;
import znaishaded.io.vertx.ext.web.RoutingContext;
import znaishaded.io.vertx.ext.web.handler.ResponseContentTypeHandler;

public class ResponseContentTypeHandlerImpl
implements ResponseContentTypeHandler {
    private final String disableFlag;

    public ResponseContentTypeHandlerImpl(String disableFlag) {
        this.disableFlag = disableFlag;
    }

    @Override
    public void handle(RoutingContext rc) {
        rc.addHeadersEndHandler(v -> {
            if (rc.get(this.disableFlag) != null) {
                return;
            }
            String acceptableContentType = rc.getAcceptableContentType();
            if (acceptableContentType == null) {
                return;
            }
            MultiMap headers = rc.response().headers();
            if (headers.contains(HttpHeaders.CONTENT_TYPE)) {
                return;
            }
            if (!"0".equals(headers.get(HttpHeaders.CONTENT_LENGTH))) {
                headers.add(HttpHeaders.CONTENT_TYPE, (CharSequence)acceptableContentType);
            }
        });
        rc.next();
    }
}

