/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.ext.web.handler.sockjs.impl;

import znaishaded.io.vertx.core.Handler;
import znaishaded.io.vertx.core.Vertx;
import znaishaded.io.vertx.core.buffer.Buffer;
import znaishaded.io.vertx.core.http.HttpServerRequest;
import znaishaded.io.vertx.core.logging.Logger;
import znaishaded.io.vertx.core.logging.LoggerFactory;
import znaishaded.io.vertx.core.shareddata.LocalMap;
import znaishaded.io.vertx.ext.web.Router;
import znaishaded.io.vertx.ext.web.RoutingContext;
import znaishaded.io.vertx.ext.web.handler.sockjs.SockJSHandlerOptions;
import znaishaded.io.vertx.ext.web.handler.sockjs.SockJSSocket;
import znaishaded.io.vertx.ext.web.handler.sockjs.impl.BaseTransport;
import znaishaded.io.vertx.ext.web.handler.sockjs.impl.SockJSSession;

class EventSourceTransport
extends BaseTransport {
    private static final Logger log = LoggerFactory.getLogger(EventSourceTransport.class);

    EventSourceTransport(Vertx vertx, Router router, LocalMap<String, SockJSSession> sessions, SockJSHandlerOptions options, Handler<SockJSSocket> sockHandler) {
        super(vertx, sessions, options);
        String eventSourceRE = "\\/[^\\/\\.]+\\/([^\\/\\.]+)\\/eventsource";
        router.getWithRegex(eventSourceRE).handler(rc -> {
            if (log.isTraceEnabled()) {
                log.trace("EventSource transport, get: " + rc.request().uri());
            }
            String sessionID = rc.request().getParam("param0");
            SockJSSession session = this.getSession((RoutingContext)rc, options.getSessionTimeout(), options.getHeartbeatInterval(), sessionID, sockHandler);
            HttpServerRequest req = rc.request();
            session.register(req, new EventSourceListener(options.getMaxBytesStreaming(), (RoutingContext)rc, session));
        });
    }

    private class EventSourceListener
    extends BaseTransport.BaseListener {
        final int maxBytesStreaming;
        boolean headersWritten;
        int bytesSent;
        boolean closed;

        EventSourceListener(int maxBytesStreaming, RoutingContext rc, SockJSSession session) {
            super(rc, session);
            this.maxBytesStreaming = maxBytesStreaming;
            this.addCloseHandler(rc.response(), session);
        }

        @Override
        public void sendFrame(String body) {
            if (log.isTraceEnabled()) {
                log.trace("EventSource, sending frame");
            }
            if (!this.headersWritten) {
                this.rc.response().putHeader("Content-Type", "text/event-stream; charset=UTF-8");
                BaseTransport.setNoCacheHeaders(this.rc);
                BaseTransport.setJSESSIONID(EventSourceTransport.this.options, this.rc);
                this.rc.response().setChunked(true).write("\r\n");
                this.headersWritten = true;
            }
            String sb = "data: " + body + "\r\n\r\n";
            Buffer buff = Buffer.buffer(sb);
            this.rc.response().write(buff);
            this.bytesSent += buff.length();
            if (this.bytesSent >= this.maxBytesStreaming) {
                if (log.isTraceEnabled()) {
                    log.trace("More than maxBytes sent so closing connection");
                }
                this.close();
            }
        }

        @Override
        public void close() {
            if (!this.closed) {
                try {
                    this.session.resetListener();
                    this.rc.response().end();
                    this.rc.response().close();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                this.closed = true;
            }
        }
    }
}

