/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.ext.web.handler.sockjs.impl;

import znaishaded.io.vertx.core.Handler;
import znaishaded.io.vertx.core.Vertx;
import znaishaded.io.vertx.core.http.HttpHeaders;
import znaishaded.io.vertx.core.http.HttpServerRequest;
import znaishaded.io.vertx.core.http.ServerWebSocket;
import znaishaded.io.vertx.core.logging.Logger;
import znaishaded.io.vertx.core.logging.LoggerFactory;
import znaishaded.io.vertx.core.shareddata.LocalMap;
import znaishaded.io.vertx.ext.web.Router;
import znaishaded.io.vertx.ext.web.RoutingContext;
import znaishaded.io.vertx.ext.web.handler.sockjs.SockJSHandlerOptions;
import znaishaded.io.vertx.ext.web.handler.sockjs.SockJSSocket;
import znaishaded.io.vertx.ext.web.handler.sockjs.impl.BaseTransport;
import znaishaded.io.vertx.ext.web.handler.sockjs.impl.SockJSSession;
import znaishaded.io.vertx.ext.web.handler.sockjs.impl.TransportListener;

class WebSocketTransport
extends BaseTransport {
    private static final Logger log = LoggerFactory.getLogger(WebSocketTransport.class);

    WebSocketTransport(Vertx vertx, Router router, LocalMap<String, SockJSSession> sessions, SockJSHandlerOptions options, Handler<SockJSSocket> sockHandler) {
        super(vertx, sessions, options);
        String wsRE = "\\/[^\\/\\.]+\\/([^\\/\\.]+)\\/websocket";
        router.getWithRegex(wsRE).handler(rc -> {
            HttpServerRequest req = rc.request();
            String connectionHeader = req.headers().get(HttpHeaders.CONNECTION);
            if (connectionHeader == null || !connectionHeader.toLowerCase().contains("upgrade")) {
                rc.response().setStatusCode(400);
                rc.response().end("Can \"Upgrade\" only to \"WebSocket\".");
            } else {
                ServerWebSocket ws = rc.request().upgrade();
                if (log.isTraceEnabled()) {
                    log.trace("WS, handler");
                }
                SockJSSession session = new SockJSSession(vertx, sessions, (RoutingContext)rc, options.getHeartbeatInterval(), sockHandler);
                session.register(req, new WebSocketListener(ws, session));
            }
        });
        router.getWithRegex(wsRE).handler(rc -> {
            if (log.isTraceEnabled()) {
                log.trace("WS, get: " + rc.request().uri());
            }
            rc.response().setStatusCode(400);
            rc.response().end("Can \"Upgrade\" only to \"WebSocket\".");
        });
        router.routeWithRegex(wsRE).handler(rc -> {
            if (log.isTraceEnabled()) {
                log.trace("WS, all: " + rc.request().uri());
            }
            rc.response().putHeader("Allow", "GET").setStatusCode(405).end();
        });
    }

    private static class WebSocketListener
    implements TransportListener {
        final ServerWebSocket ws;
        final SockJSSession session;
        boolean closed;

        WebSocketListener(ServerWebSocket ws, SockJSSession session) {
            this.ws = ws;
            this.session = session;
            ws.textMessageHandler(this::handleMessages);
            ws.closeHandler(v -> {
                this.closed = true;
                session.shutdown();
            });
            ws.exceptionHandler(t -> {
                this.closed = true;
                session.shutdown();
                session.handleException((Throwable)t);
            });
        }

        private void handleMessages(String msgs) {
            if (!this.session.isClosed() && !msgs.equals("")) {
                if (msgs.startsWith("[\"") && msgs.endsWith("\"]") || msgs.startsWith("\"") && msgs.endsWith("\"")) {
                    this.session.handleMessages(msgs);
                } else {
                    this.close();
                }
            }
        }

        @Override
        public void sendFrame(String body) {
            if (log.isTraceEnabled()) {
                log.trace("WS, sending frame");
            }
            if (!this.closed) {
                this.ws.writeTextMessage(body);
            }
        }

        @Override
        public void close() {
            if (!this.closed) {
                this.ws.close();
                this.session.shutdown();
                this.closed = true;
            }
        }

        @Override
        public void sessionClosed() {
            this.session.writeClosed(this);
            this.closed = true;
            this.ws.close();
        }
    }
}

