/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml;

import znaishaded.net.sourceforge.plantuml.Annotated;
import znaishaded.net.sourceforge.plantuml.FontParam;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.EntityImageLegend;
import znaishaded.net.sourceforge.plantuml.cucadiagram.DisplayPositionned;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockUtils;
import znaishaded.net.sourceforge.plantuml.svek.DecorateEntityImage;
import znaishaded.net.sourceforge.plantuml.svek.TextBlockBackcolored;

public class AnnotatedWorker {
    private final Annotated annotated;
    private final ISkinParam skinParam;

    public AnnotatedWorker(Annotated annotated, ISkinParam iSkinParam) {
        this.annotated = annotated;
        this.skinParam = iSkinParam;
    }

    public TextBlockBackcolored addAdd(TextBlock textBlock) {
        textBlock = this.addLegend(textBlock);
        textBlock = this.addTitle(textBlock);
        textBlock = this.addCaption(textBlock);
        textBlock = this.addHeaderAndFooter(textBlock);
        return (TextBlockBackcolored)textBlock;
    }

    private TextBlock addLegend(TextBlock textBlock) {
        if (DisplayPositionned.isNull(this.annotated.getLegend())) {
            return textBlock;
        }
        TextBlock textBlock2 = EntityImageLegend.create(this.annotated.getLegend().getDisplay(), this.getSkinParam());
        return DecorateEntityImage.add(textBlock, textBlock2, this.annotated.getLegend().getHorizontalAlignment(), this.annotated.getLegend().getVerticalAlignment());
    }

    private ISkinParam getSkinParam() {
        return this.skinParam;
    }

    private TextBlock addCaption(TextBlock textBlock) {
        if (DisplayPositionned.isNull(this.annotated.getCaption())) {
            return textBlock;
        }
        TextBlock textBlock2 = this.getCaption();
        return DecorateEntityImage.addBottom(textBlock, textBlock2, HorizontalAlignment.CENTER);
    }

    public TextBlock getCaption() {
        if (DisplayPositionned.isNull(this.annotated.getCaption())) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        return this.annotated.getCaption().getDisplay().create(new FontConfiguration(this.getSkinParam(), FontParam.CAPTION, null), HorizontalAlignment.CENTER, this.getSkinParam());
    }

    private TextBlock addTitle(TextBlock textBlock) {
        DisplayPositionned displayPositionned = this.annotated.getTitle();
        if (DisplayPositionned.isNull(displayPositionned)) {
            return textBlock;
        }
        ISkinParam iSkinParam = this.getSkinParam();
        FontConfiguration fontConfiguration = new FontConfiguration(iSkinParam, FontParam.TITLE, null);
        TextBlock textBlock2 = TextBlockUtils.title(fontConfiguration, displayPositionned.getDisplay(), iSkinParam);
        return DecorateEntityImage.addTop(textBlock, textBlock2, HorizontalAlignment.CENTER);
    }

    private TextBlock addHeaderAndFooter(TextBlock textBlock) {
        if (DisplayPositionned.isNull(this.annotated.getFooter()) && DisplayPositionned.isNull(this.annotated.getHeader())) {
            return textBlock;
        }
        TextBlock textBlock2 = DisplayPositionned.isNull(this.annotated.getFooter()) ? null : this.annotated.getFooter().getDisplay().create(new FontConfiguration(this.getSkinParam(), FontParam.FOOTER, null), this.annotated.getFooter().getHorizontalAlignment(), this.getSkinParam());
        TextBlock textBlock3 = DisplayPositionned.isNull(this.annotated.getHeader()) ? null : this.annotated.getHeader().getDisplay().create(new FontConfiguration(this.getSkinParam(), FontParam.HEADER, null), this.annotated.getHeader().getHorizontalAlignment(), this.getSkinParam());
        return new DecorateEntityImage(textBlock, textBlock3, this.annotated.getHeader().getHorizontalAlignment(), textBlock2, this.annotated.getFooter().getHorizontalAlignment());
    }
}

